/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.ConfigGroupEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
@RequiresSession
public class ConfigGroupDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public ConfigGroupEntity findByName(String groupName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("configGroupByName", ConfigGroupEntity.class);
        query.setParameter("groupName", (Object)groupName);
        try {
            return (ConfigGroupEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public ConfigGroupEntity findById(Long id) {
        return (ConfigGroupEntity)((EntityManager)this.entityManagerProvider.get()).find(ConfigGroupEntity.class, (Object)id);
    }

    @RequiresSession
    public List<ConfigGroupEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allConfigGroups", ConfigGroupEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @RequiresSession
    public List<ConfigGroupEntity> findAllByTag(String tag) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("configGroupsByTag", ConfigGroupEntity.class);
        query.setParameter("tagName", (Object)tag);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Transactional
    public void create(ConfigGroupEntity configGroupEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)configGroupEntity);
    }

    @Transactional
    public ConfigGroupEntity merge(ConfigGroupEntity configGroupEntity) {
        return (ConfigGroupEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)configGroupEntity);
    }

    @Transactional
    public void remove(ConfigGroupEntity configGroupEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(configGroupEntity));
    }

    @Transactional
    public void removeByPK(Long id) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findById(id));
    }

    @Transactional
    public void refresh(ConfigGroupEntity configGroupEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)configGroupEntity);
    }
}

