/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ConfigGroupConfigMappingEntity;
import id.onyx.obdp.server.orm.entities.ConfigGroupConfigMappingEntityPK;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class ConfigGroupConfigMappingDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public ConfigGroupConfigMappingEntity findByPK(ConfigGroupConfigMappingEntityPK configGroupConfigMappingEntityPK) {
        return (ConfigGroupConfigMappingEntity)((EntityManager)this.entityManagerProvider.get()).find(ConfigGroupConfigMappingEntity.class, (Object)configGroupConfigMappingEntityPK);
    }

    @RequiresSession
    public List<ConfigGroupConfigMappingEntity> findByGroup(Long groupId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("configsByGroup", ConfigGroupConfigMappingEntity.class);
        query.setParameter("groupId", (Object)groupId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ConfigGroupConfigMappingEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), ConfigGroupConfigMappingEntity.class);
    }

    @Transactional
    public void create(ConfigGroupConfigMappingEntity configGroupConfigMappingEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)configGroupConfigMappingEntity);
    }

    @Transactional
    public ConfigGroupConfigMappingEntity merge(ConfigGroupConfigMappingEntity configGroupConfigMappingEntity) {
        return (ConfigGroupConfigMappingEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)configGroupConfigMappingEntity);
    }

    @Transactional
    public void refresh(ConfigGroupConfigMappingEntity configGroupConfigMappingEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)configGroupConfigMappingEntity);
    }

    @Transactional
    public void remove(ConfigGroupConfigMappingEntity configGroupConfigMappingEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(configGroupConfigMappingEntity));
    }

    @Transactional
    public void removeByPK(ConfigGroupConfigMappingEntityPK configGroupConfigMappingEntityPK) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findByPK(configGroupConfigMappingEntityPK));
    }

    @Transactional
    public void removeAllByGroup(Long groupId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery("DELETE FROM ConfigGroupConfigMappingEntity configs WHERE configs.configGroupId = ?1", Long.class);
        this.daoUtils.executeUpdate((Query)query, groupId);
        ((EntityManager)this.entityManagerProvider.get()).flush();
    }
}

