/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ClusterStateEntity;
import jakarta.persistence.EntityManager;
import java.util.List;

@Singleton
public class ClusterStateDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public ClusterStateEntity findByPK(long clusterId) {
        return (ClusterStateEntity)((EntityManager)this.entityManagerProvider.get()).find(ClusterStateEntity.class, (Object)clusterId);
    }

    @RequiresSession
    public List<ClusterStateEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), ClusterStateEntity.class);
    }

    @Transactional
    public void refresh(ClusterStateEntity clusterStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)clusterStateEntity);
    }

    @Transactional
    public void create(ClusterStateEntity clusterStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)clusterStateEntity);
    }

    @Transactional
    public ClusterStateEntity merge(ClusterStateEntity clusterStateEntity) {
        return (ClusterStateEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)clusterStateEntity);
    }

    @Transactional
    public void remove(ClusterStateEntity clusterStateEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(clusterStateEntity));
    }

    @Transactional
    public void removeByPK(long clusterId) {
        this.remove(this.findByPK(clusterId));
    }
}

