/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntity;
import id.onyx.obdp.server.orm.entities.ClusterServiceEntityPK;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class ClusterServiceDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    DaoUtils daoUtils;

    @RequiresSession
    public ClusterServiceEntity findByPK(ClusterServiceEntityPK clusterServiceEntityPK) {
        return (ClusterServiceEntity)((EntityManager)this.entityManagerProvider.get()).find(ClusterServiceEntity.class, (Object)clusterServiceEntityPK);
    }

    @RequiresSession
    public ClusterServiceEntity findByClusterAndServiceNames(String clusterName, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("clusterServiceByClusterAndServiceNames", ClusterServiceEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        query.setParameter("serviceName", (Object)serviceName);
        try {
            return (ClusterServiceEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public List<ClusterServiceEntity> findAll() {
        return this.daoUtils.selectAll((EntityManager)this.entityManagerProvider.get(), ClusterServiceEntity.class);
    }

    @Transactional
    public void refresh(ClusterServiceEntity clusterServiceEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)clusterServiceEntity);
    }

    @Transactional
    public void create(ClusterServiceEntity clusterServiceEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)clusterServiceEntity);
    }

    @Transactional
    public ClusterServiceEntity merge(ClusterServiceEntity clusterServiceEntity) {
        return (ClusterServiceEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)clusterServiceEntity);
    }

    @Transactional
    public void remove(ClusterServiceEntity clusterServiceEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(clusterServiceEntity));
    }

    @Transactional
    public void removeByPK(ClusterServiceEntityPK clusterServiceEntityPK) {
        ClusterServiceEntity entity = this.findByPK(clusterServiceEntityPK);
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
    }
}

