/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.ClusterConfigEntity;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.StackId;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Singleton
public class ClusterDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;
    @Inject
    private StackDAO stackDAO;

    @RequiresSession
    public ClusterEntity findById(long id) {
        return (ClusterEntity)((EntityManager)this.entityManagerProvider.get()).find(ClusterEntity.class, (Object)id);
    }

    @RequiresSession
    public ClusterEntity findByName(String clusterName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("clusterByName", ClusterEntity.class);
        query.setParameter("clusterName", (Object)clusterName);
        try {
            return (ClusterEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public ClusterEntity findByResourceId(long resourceId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("clusterByResourceId", ClusterEntity.class);
        query.setParameter("resourceId", (Object)resourceId);
        try {
            return (ClusterEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public List<ClusterEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allClusters", ClusterEntity.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @RequiresSession
    public ClusterConfigEntity findConfig(Long configEntityPK) {
        return (ClusterConfigEntity)((EntityManager)this.entityManagerProvider.get()).find(ClusterConfigEntity.class, (Object)configEntityPK);
    }

    @RequiresSession
    public ClusterConfigEntity findConfig(Long clusterId, String type, String tag) {
        CriteriaBuilder cb = ((EntityManager)this.entityManagerProvider.get()).getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(ClusterConfigEntity.class);
        Root config = cq.from(ClusterConfigEntity.class);
        cq.where(new Predicate[]{cb.and(new Predicate[]{cb.equal((Expression)config.get("clusterId"), (Object)clusterId)}), cb.equal((Expression)config.get("type"), (Object)type), cb.equal((Expression)config.get("tag"), (Object)tag)});
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(cq);
        return (ClusterConfigEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public List<ClusterConfigEntity> getEnabledConfigsByTypes(Long clusterId, Collection<String> types) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findEnabledConfigsByTypes", ClusterConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("types", types);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public ClusterConfigEntity findConfig(Long clusterId, String type, Long version) {
        CriteriaBuilder cb = ((EntityManager)this.entityManagerProvider.get()).getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(ClusterConfigEntity.class);
        Root config = cq.from(ClusterConfigEntity.class);
        cq.where(new Predicate[]{cb.and(new Predicate[]{cb.equal((Expression)config.get("clusterId"), (Object)clusterId)}), cb.equal((Expression)config.get("type"), (Object)type), cb.equal((Expression)config.get("version"), (Object)version)});
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createQuery(cq);
        return (ClusterConfigEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public Long findNextConfigVersion(long clusterId, String configType) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findNextConfigVersion", Number.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("configType", (Object)configType);
        return ((Number)this.daoUtils.selectSingle(query, new Object[0])).longValue();
    }

    @RequiresSession
    public List<ClusterConfigEntity> getAllConfigurations(Long clusterId, StackId stackId) {
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findAllConfigsByStack", ClusterConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("stack", (Object)stackEntity);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ClusterConfigEntity> getLatestConfigurations(long clusterId, StackId stackId) {
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findLatestConfigsByStack", ClusterConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("stack", (Object)stackEntity);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ClusterConfigEntity> getLatestConfigurationsWithTypes(long clusterId, StackId stackId, Collection<String> configTypes) {
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        if (configTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return this.daoUtils.selectList(((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findLatestConfigsByStackWithTypes", ClusterConfigEntity.class).setParameter("clusterId", (Object)clusterId).setParameter("stack", (Object)stackEntity).setParameter("types", configTypes), new Object[0]);
    }

    @RequiresSession
    public List<ClusterConfigEntity> getEnabledConfigsByStack(long clusterId, StackId stackId) {
        StackEntity stackEntity = this.stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findEnabledConfigsByStack", ClusterConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("stack", (Object)stackEntity);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<ClusterConfigEntity> getEnabledConfigs(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findEnabledConfigs", ClusterConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public ClusterConfigEntity findEnabledConfigByType(long clusterId, String type) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("ClusterConfigEntity.findEnabledConfigByType", ClusterConfigEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("type", (Object)type);
        return (ClusterConfigEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @Transactional
    public void create(ClusterEntity clusterEntity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)clusterEntity);
    }

    @Transactional
    public void createConfig(ClusterConfigEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public void removeConfig(ClusterConfigEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)entity);
    }

    @Transactional
    public void refresh(ClusterEntity clusterEntity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)clusterEntity);
    }

    public ClusterEntity merge(ClusterEntity clusterEntity) {
        return this.merge(clusterEntity, false);
    }

    @Transactional
    public ClusterEntity merge(ClusterEntity clusterEntity, boolean flush) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        clusterEntity = (ClusterEntity)entityManager.merge((Object)clusterEntity);
        if (flush) {
            entityManager.flush();
        }
        return clusterEntity;
    }

    @Transactional
    public ClusterConfigEntity merge(ClusterConfigEntity clusterConfigEntity) {
        return this.merge(clusterConfigEntity, false);
    }

    @Transactional
    public void merge(Collection<ClusterConfigEntity> clusterConfigEntities) {
        this.merge(clusterConfigEntities, false);
    }

    @Transactional
    public ClusterConfigEntity merge(ClusterConfigEntity clusterConfigEntity, boolean flush) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        ClusterConfigEntity clusterConfigEntityRes = (ClusterConfigEntity)entityManager.merge((Object)clusterConfigEntity);
        if (flush) {
            entityManager.flush();
        }
        return clusterConfigEntityRes;
    }

    @Transactional
    public void merge(Collection<ClusterConfigEntity> clusterConfigEntities, boolean flush) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        for (ClusterConfigEntity clusterConfigEntity : clusterConfigEntities) {
            entityManager.merge((Object)clusterConfigEntity);
        }
        if (flush) {
            entityManager.flush();
        }
    }

    @Transactional
    public void remove(ClusterEntity clusterEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)clusterEntity);
    }

    @Transactional
    public void removeByName(String clusterName) {
        this.remove(this.findByName(clusterName));
    }

    @Transactional
    public void removeByPK(long id) {
        this.remove(this.findById(id));
    }

    @RequiresSession
    public boolean isManaged(ClusterEntity entity) {
        return ((EntityManager)this.entityManagerProvider.get()).contains((Object)entity);
    }
}

