/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.BlueprintEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;

@Singleton
public class BlueprintDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;
    @Inject
    StackDAO stackDAO;

    @RequiresSession
    public BlueprintEntity findByName(String blueprint_name) {
        return (BlueprintEntity)((EntityManager)this.entityManagerProvider.get()).find(BlueprintEntity.class, (Object)blueprint_name);
    }

    @RequiresSession
    public List<BlueprintEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("allBlueprints", BlueprintEntity.class);
        return query.getResultList();
    }

    @Transactional
    public void refresh(BlueprintEntity blueprintEntity) {
        this.ensureStackIdSet(blueprintEntity);
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)blueprintEntity);
    }

    @Transactional
    public void create(BlueprintEntity blueprintEntity) {
        this.ensureStackIdSet(blueprintEntity);
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)blueprintEntity);
    }

    @Transactional
    public BlueprintEntity merge(BlueprintEntity blueprintEntity) {
        this.ensureStackIdSet(blueprintEntity);
        return (BlueprintEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)blueprintEntity);
    }

    @Transactional
    public void remove(BlueprintEntity blueprintEntity) {
        this.ensureStackIdSet(blueprintEntity);
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(blueprintEntity));
    }

    @Transactional
    public void removeByName(String blueprint_name) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.findByName(blueprint_name));
    }

    private void ensureStackIdSet(BlueprintEntity entity) {
        StackEntity stack = entity.getStack();
        if (stack != null && stack.getStackId() == null) {
            entity.setStack(this.stackDAO.find(stack.getStackName(), stack.getStackVersion()));
        }
    }
}

