/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.entities.ArtifactEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.TreeMap;

@Singleton
public class ArtifactDAO {
    @Inject
    Provider<EntityManager> entityManagerProvider;

    @RequiresSession
    public ArtifactEntity findByNameAndForeignKeys(String artifactName, TreeMap<String, String> foreignKeys) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("artifactByNameAndForeignKeys", ArtifactEntity.class);
        query.setParameter("artifactName", (Object)artifactName);
        query.setParameter("foreignKeys", (Object)ArtifactEntity.serializeForeignKeys(foreignKeys));
        try {
            return (ArtifactEntity)query.getSingleResult();
        }
        catch (NoResultException ignored) {
            return null;
        }
    }

    @RequiresSession
    public List<ArtifactEntity> findByForeignKeys(TreeMap<String, String> foreignKeys) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("artifactByForeignKeys", ArtifactEntity.class);
        query.setParameter("foreignKeys", (Object)ArtifactEntity.serializeForeignKeys(foreignKeys));
        return query.getResultList();
    }

    @RequiresSession
    public List<ArtifactEntity> findByName(String artifactName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("artifactByName", ArtifactEntity.class);
        query.setParameter("artifactName", (Object)artifactName);
        return query.getResultList();
    }

    @Transactional
    public void refresh(ArtifactEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)entity);
    }

    @Transactional
    public void create(ArtifactEntity entity) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)entity);
    }

    @Transactional
    public ArtifactEntity merge(ArtifactEntity artifactEntity) {
        return (ArtifactEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)artifactEntity);
    }

    @Transactional
    public void remove(ArtifactEntity artifactEntity) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(artifactEntity));
    }
}

