/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.query.JpaPredicateVisitor;
import id.onyx.obdp.server.api.query.JpaSortBuilder;
import id.onyx.obdp.server.cleanup.TimeBasedCleanupPolicy;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.AlertCurrentRequest;
import id.onyx.obdp.server.controller.AlertHistoryRequest;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.events.AggregateAlertRecalculateEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.AlertHostSummaryDTO;
import id.onyx.obdp.server.orm.dao.AlertSummaryDTO;
import id.onyx.obdp.server.orm.dao.Cleanable;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.dao.HostAlertSummaryDTO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity_;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity_;
import id.onyx.obdp.server.orm.entities.AlertNoticeEntity;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.alert.Scope;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertsDAO
implements Cleanable {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsDAO.class);
    private static final String ALERT_COUNT_SQL_TEMPLATE = "SELECT NEW %s(SUM(CASE WHEN history.alertState = :okState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN history.alertState = :warningState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN history.alertState = :criticalState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN history.alertState = :unknownState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN alert.maintenanceState != :maintenanceStateOff THEN 1 ELSE 0 END)) FROM AlertCurrentEntity alert JOIN alert.alertHistory history WHERE history.clusterId = :clusterId";
    private static final String ALERT_COUNT_PER_HOST_SQL_TEMPLATE = "SELECT NEW %s(history.hostName, SUM(CASE WHEN history.alertState = :okState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN history.alertState = :warningState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN history.alertState = :criticalState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN history.alertState = :unknownState AND alert.maintenanceState = :maintenanceStateOff THEN 1 ELSE 0 END), SUM(CASE WHEN alert.maintenanceState != :maintenanceStateOff THEN 1 ELSE 0 END)) FROM AlertCurrentEntity alert JOIN alert.alertHistory history WHERE history.clusterId = :clusterId GROUP BY history.hostName";
    @Inject
    private Provider<EntityManager> m_entityManagerProvider;
    @Inject
    private DaoUtils m_daoUtils;
    @Inject
    private AlertEventPublisher m_alertEventPublisher;
    @Inject
    private Provider<Clusters> m_clusters;
    private final Configuration m_configuration;
    private LoadingCache<AlertCacheKey, AlertCurrentEntity> m_currentAlertCache = null;
    private static final int BATCH_SIZE = 999;

    @Inject
    public AlertsDAO(Configuration configuration) {
        this.m_configuration = configuration;
        if (this.m_configuration.isAlertCacheEnabled()) {
            int maximumSize = this.m_configuration.getAlertCacheSize();
            LOG.info("Alert caching is enabled (size={}, flushInterval={}m)", (Object)maximumSize, (Object)this.m_configuration.getAlertCacheFlushInterval());
            this.m_currentAlertCache = CacheBuilder.newBuilder().maximumSize((long)maximumSize).build((CacheLoader)new CacheLoader<AlertCacheKey, AlertCurrentEntity>(){

                public AlertCurrentEntity load(AlertCacheKey key) throws Exception {
                    LOG.debug("Cache miss for alert key {}, fetching from JPA", (Object)key);
                    long clusterId = key.getClusterId();
                    String alertDefinitionName = key.getAlertDefinitionName();
                    String hostName = key.getHostName();
                    AlertCurrentEntity alertCurrentEntity = StringUtils.isEmpty((String)hostName) ? AlertsDAO.this.findCurrentByNameNoHostInternalInJPA(clusterId, alertDefinitionName) : AlertsDAO.this.findCurrentByHostAndNameInJPA(clusterId, hostName, alertDefinitionName);
                    if (null == alertCurrentEntity) {
                        LOG.trace("Cache lookup failed for {} because the alert does not yet exist", (Object)key);
                        throw new AlertNotYetCreatedException();
                    }
                    return alertCurrentEntity;
                }
            });
        }
    }

    @RequiresSession
    public AlertHistoryEntity findById(long alertId) {
        return (AlertHistoryEntity)((EntityManager)this.m_entityManagerProvider.get()).find(AlertHistoryEntity.class, (Object)alertId);
    }

    @RequiresSession
    public List<AlertHistoryEntity> findAll() {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertHistoryEntity.findAll", AlertHistoryEntity.class);
        return this.m_daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertHistoryEntity> findAll(long clusterId) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertHistoryEntity.findAllInCluster", AlertHistoryEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.m_daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertHistoryEntity> findAll(long clusterId, List<AlertState> alertStates) {
        if (null == alertStates || alertStates.size() == 0) {
            return Collections.emptyList();
        }
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertHistoryEntity.findAllInClusterWithState", AlertHistoryEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("alertStates", alertStates);
        return this.m_daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertHistoryEntity> findAll(long clusterId, Date startDate, Date endDate) {
        if (null == startDate && null == endDate) {
            return Collections.emptyList();
        }
        TypedQuery query = null;
        if (null != startDate && null != endDate) {
            if (startDate.after(endDate)) {
                return Collections.emptyList();
            }
            query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertHistoryEntity.findAllInClusterBetweenDates", AlertHistoryEntity.class);
            query.setParameter("clusterId", (Object)clusterId);
            query.setParameter("startDate", (Object)startDate.getTime());
            query.setParameter("endDate", (Object)endDate.getTime());
        } else if (null != startDate) {
            query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertHistoryEntity.findAllInClusterAfterDate", AlertHistoryEntity.class);
            query.setParameter("clusterId", (Object)clusterId);
            query.setParameter("afterDate", (Object)startDate.getTime());
        } else if (null != endDate) {
            query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertHistoryEntity.findAllInClusterBeforeDate", AlertHistoryEntity.class);
            query.setParameter("clusterId", (Object)clusterId);
            query.setParameter("beforeDate", (Object)endDate.getTime());
        }
        if (null == query) {
            return Collections.emptyList();
        }
        return this.m_daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertHistoryEntity> findAll(AlertHistoryRequest request) {
        EntityManager entityManager = (EntityManager)this.m_entityManagerProvider.get();
        HistoryPredicateVisitor visitor = new HistoryPredicateVisitor();
        PredicateHelper.visit(request.Predicate, visitor);
        CriteriaQuery query = visitor.getCriteriaQuery();
        Predicate jpaPredicate = visitor.getJpaPredicate();
        if (null != jpaPredicate) {
            query.where((Expression)jpaPredicate);
        }
        JpaSortBuilder<AlertHistoryEntity> sortBuilder = new JpaSortBuilder<AlertHistoryEntity>();
        List<Order> sortOrders = sortBuilder.buildSortOrders(request.Sort, visitor);
        query.orderBy(sortOrders);
        TypedQuery typedQuery = entityManager.createQuery(query);
        if (null != request.Pagination) {
            typedQuery.setFirstResult(request.Pagination.getOffset());
            typedQuery.setMaxResults(request.Pagination.getPageSize());
        }
        return this.m_daoUtils.selectList(typedQuery, new Object[0]);
    }

    @Transactional
    public List<AlertCurrentEntity> findAll(AlertCurrentRequest request) {
        EntityManager entityManager = (EntityManager)this.m_entityManagerProvider.get();
        CurrentPredicateVisitor visitor = new CurrentPredicateVisitor();
        PredicateHelper.visit(request.Predicate, visitor);
        CriteriaQuery query = visitor.getCriteriaQuery();
        Predicate jpaPredicate = visitor.getJpaPredicate();
        if (null != jpaPredicate) {
            query.where((Expression)jpaPredicate);
        }
        JpaSortBuilder<AlertCurrentEntity> sortBuilder = new JpaSortBuilder<AlertCurrentEntity>();
        List<Order> sortOrders = sortBuilder.buildSortOrders(request.Sort, visitor);
        query.orderBy(sortOrders);
        TypedQuery typedQuery = entityManager.createQuery(query);
        if (null != request.Pagination) {
            int offset = request.Pagination.getOffset();
            if (offset < 0) {
                offset = 0;
            }
            typedQuery.setFirstResult(offset);
            typedQuery.setMaxResults(request.Pagination.getPageSize());
        }
        List<AlertCurrentEntity> alerts = this.m_daoUtils.selectList(typedQuery, new Object[0]);
        if (this.m_configuration.isAlertCacheEnabled()) {
            alerts = this.supplementWithCachedAlerts(alerts);
        }
        return alerts;
    }

    public int getCount(id.onyx.obdp.server.controller.spi.Predicate predicate) {
        return 0;
    }

    @RequiresSession
    public List<AlertCurrentEntity> findCurrent() {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findAll", AlertCurrentEntity.class);
        List<AlertCurrentEntity> alerts = this.m_daoUtils.selectList(query, new Object[0]);
        if (this.m_configuration.isAlertCacheEnabled()) {
            alerts = this.supplementWithCachedAlerts(alerts);
        }
        return alerts;
    }

    @RequiresSession
    public AlertCurrentEntity findCurrentById(long alertId) {
        return (AlertCurrentEntity)((EntityManager)this.m_entityManagerProvider.get()).find(AlertCurrentEntity.class, (Object)alertId);
    }

    @RequiresSession
    public List<AlertCurrentEntity> findCurrentByDefinitionId(long definitionId) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByDefinitionId", AlertCurrentEntity.class);
        query.setParameter("definitionId", (Object)definitionId);
        List<AlertCurrentEntity> alerts = this.m_daoUtils.selectList(query, new Object[0]);
        if (this.m_configuration.isAlertCacheEnabled()) {
            alerts = this.supplementWithCachedAlerts(alerts);
        }
        return alerts;
    }

    @RequiresSession
    public List<AlertCurrentEntity> findCurrentByCluster(long clusterId) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByCluster", AlertCurrentEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        List<AlertCurrentEntity> alerts = this.m_daoUtils.selectList(query, new Object[0]);
        if (this.m_configuration.isAlertCacheEnabled()) {
            alerts = this.supplementWithCachedAlerts(alerts);
        }
        return alerts;
    }

    @RequiresSession
    public AlertSummaryDTO findCurrentCounts(long clusterId, String serviceName, String hostName) {
        String sql = String.format(ALERT_COUNT_SQL_TEMPLATE, AlertSummaryDTO.class.getName());
        StringBuilder sb = new StringBuilder(sql);
        if (null != serviceName) {
            sb.append(" AND history.serviceName = :serviceName");
        }
        if (null != hostName) {
            sb.append(" AND history.hostName = :hostName");
        }
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createQuery(sb.toString(), AlertSummaryDTO.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("okState", (Object)AlertState.OK);
        query.setParameter("warningState", (Object)AlertState.WARNING);
        query.setParameter("criticalState", (Object)AlertState.CRITICAL);
        query.setParameter("unknownState", (Object)AlertState.UNKNOWN);
        query.setParameter("maintenanceStateOff", (Object)MaintenanceState.OFF);
        if (null != serviceName) {
            query.setParameter("serviceName", (Object)serviceName);
        }
        if (null != hostName) {
            query.setParameter("hostName", (Object)hostName);
        }
        return (AlertSummaryDTO)this.m_daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public Map<String, AlertSummaryDTO> findCurrentPerHostCounts(long clusterId) {
        String sql = String.format(ALERT_COUNT_PER_HOST_SQL_TEMPLATE, HostAlertSummaryDTO.class.getName());
        StringBuilder sb = new StringBuilder(sql);
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createQuery(sb.toString(), HostAlertSummaryDTO.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("okState", (Object)AlertState.OK);
        query.setParameter("warningState", (Object)AlertState.WARNING);
        query.setParameter("criticalState", (Object)AlertState.CRITICAL);
        query.setParameter("unknownState", (Object)AlertState.UNKNOWN);
        query.setParameter("maintenanceStateOff", (Object)MaintenanceState.OFF);
        HashMap<String, AlertSummaryDTO> map = new HashMap<String, AlertSummaryDTO>();
        List resultList = this.m_daoUtils.selectList(query, new Object[0]);
        for (HostAlertSummaryDTO result : resultList) {
            map.put(result.getHostName(), result);
        }
        return map;
    }

    @RequiresSession
    public AlertHostSummaryDTO findCurrentHostCounts(long clusterId) {
        String sql = String.format(ALERT_COUNT_PER_HOST_SQL_TEMPLATE, HostAlertSummaryDTO.class.getName());
        StringBuilder sb = new StringBuilder(sql);
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createQuery(sb.toString(), HostAlertSummaryDTO.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("okState", (Object)AlertState.OK);
        query.setParameter("criticalState", (Object)AlertState.CRITICAL);
        query.setParameter("warningState", (Object)AlertState.WARNING);
        query.setParameter("unknownState", (Object)AlertState.UNKNOWN);
        query.setParameter("maintenanceStateOff", (Object)MaintenanceState.OFF);
        int okCount = 0;
        int warningCount = 0;
        int criticalCount = 0;
        int unknownCount = 0;
        List resultList = this.m_daoUtils.selectList(query, new Object[0]);
        for (HostAlertSummaryDTO result : resultList) {
            if (result.getHostName() == null) continue;
            if (result.getCriticalCount() > 0) {
                ++criticalCount;
                continue;
            }
            if (result.getWarningCount() > 0) {
                ++warningCount;
                continue;
            }
            if (result.getUnknownCount() > 0) {
                ++unknownCount;
                continue;
            }
            ++okCount;
        }
        AlertHostSummaryDTO hostSummary = new AlertHostSummaryDTO(okCount, unknownCount, warningCount, criticalCount);
        return hostSummary;
    }

    @RequiresSession
    public List<AlertCurrentEntity> findCurrentByService(long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByService", AlertCurrentEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("inlist", EnumSet.of(Scope.ANY, Scope.SERVICE));
        List<AlertCurrentEntity> alerts = this.m_daoUtils.selectList(query, new Object[0]);
        if (this.m_configuration.isAlertCacheEnabled()) {
            alerts = this.supplementWithCachedAlerts(alerts);
        }
        return alerts;
    }

    public AlertCurrentEntity findCurrentByHostAndName(long clusterId, String hostName, String alertName) {
        block3: {
            if (this.m_configuration.isAlertCacheEnabled()) {
                AlertCacheKey key = new AlertCacheKey(clusterId, alertName, hostName);
                try {
                    return (AlertCurrentEntity)this.m_currentAlertCache.get((Object)key);
                }
                catch (ExecutionException executionException) {
                    Throwable cause = executionException.getCause();
                    if (cause instanceof AlertNotYetCreatedException) break block3;
                    LOG.warn("Unable to retrieve alert for key {} from the cache", (Object)key);
                }
            }
        }
        return this.findCurrentByHostAndNameInJPA(clusterId, hostName, alertName);
    }

    @RequiresSession
    private AlertCurrentEntity findCurrentByHostAndNameInJPA(long clusterId, String hostName, String alertName) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByHostAndName", AlertCurrentEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("hostName", (Object)hostName);
        query.setParameter("definitionName", (Object)alertName);
        return (AlertCurrentEntity)this.m_daoUtils.selectOne(query, new Object[0]);
    }

    @Transactional
    public void removeByDefinitionId(long definitionId) {
        EntityManager entityManager = (EntityManager)this.m_entityManagerProvider.get();
        TypedQuery currentQuery = entityManager.createNamedQuery("AlertCurrentEntity.removeByDefinitionId", AlertCurrentEntity.class);
        currentQuery.setParameter("definitionId", (Object)definitionId);
        currentQuery.executeUpdate();
        TypedQuery historyQuery = entityManager.createNamedQuery("AlertHistoryEntity.removeByDefinitionId", AlertHistoryEntity.class);
        historyQuery.setParameter("definitionId", (Object)definitionId);
        historyQuery.executeUpdate();
        entityManager.clear();
        if (this.m_configuration.isAlertCacheEnabled()) {
            this.m_currentAlertCache.invalidateAll();
        }
    }

    @Transactional
    public int removeCurrentByHistoryId(long historyId) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.removeByHistoryId", AlertCurrentEntity.class);
        query.setParameter("historyId", (Object)historyId);
        int rowsRemoved = query.executeUpdate();
        if (this.m_configuration.isAlertCacheEnabled()) {
            this.m_currentAlertCache.invalidateAll();
        }
        return rowsRemoved;
    }

    @Transactional
    public int removeCurrentDisabledAlerts() {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findDisabled", AlertCurrentEntity.class);
        int rowsRemoved = 0;
        List currentEntities = this.m_daoUtils.selectList(query, new Object[0]);
        if (currentEntities != null) {
            for (AlertCurrentEntity currentEntity : currentEntities) {
                this.remove(currentEntity);
                ++rowsRemoved;
            }
        }
        if (this.m_configuration.isAlertCacheEnabled()) {
            this.m_currentAlertCache.invalidateAll();
        }
        return rowsRemoved;
    }

    @Transactional
    public int removeCurrentByService(long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByServiceName", AlertCurrentEntity.class);
        query.setParameter("serviceName", (Object)serviceName);
        int removedItems = 0;
        List currentEntities = this.m_daoUtils.selectList(query, new Object[0]);
        if (currentEntities != null) {
            for (AlertCurrentEntity currentEntity : currentEntities) {
                this.remove(currentEntity);
                ++removedItems;
            }
        }
        if (this.m_configuration.isAlertCacheEnabled()) {
            this.m_currentAlertCache.invalidateAll();
        }
        this.m_alertEventPublisher.publish(new AggregateAlertRecalculateEvent(clusterId));
        return removedItems;
    }

    @Transactional
    public int removeCurrentByHost(String hostName) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByHost", AlertCurrentEntity.class);
        query.setParameter("hostName", (Object)hostName);
        List currentEntities = this.m_daoUtils.selectList(query, new Object[0]);
        int removedItems = 0;
        if (currentEntities != null) {
            for (AlertCurrentEntity currentEntity : currentEntities) {
                this.remove(currentEntity);
                ++removedItems;
            }
        }
        if (this.m_configuration.isAlertCacheEnabled()) {
            this.m_currentAlertCache.invalidateAll();
        }
        try {
            Map<String, Cluster> clusters = ((Clusters)this.m_clusters.get()).getClusters();
            for (Map.Entry<String, Cluster> entry : clusters.entrySet()) {
                this.m_alertEventPublisher.publish(new AggregateAlertRecalculateEvent(entry.getValue().getClusterId()));
            }
        }
        catch (Exception ambariException) {
            LOG.warn("Unable to recalcuate aggregate alerts after removing host {}", (Object)hostName);
        }
        return removedItems;
    }

    @Transactional
    public int removeCurrentByServiceComponentHost(long clusterId, String serviceName, String componentName, String hostName) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByHostComponent", AlertCurrentEntity.class);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        query.setParameter("hostName", (Object)hostName);
        List currentEntities = this.m_daoUtils.selectList(query, new Object[0]);
        int removedItems = 0;
        if (currentEntities != null) {
            for (AlertCurrentEntity currentEntity : currentEntities) {
                this.remove(currentEntity);
                ++removedItems;
            }
        }
        if (this.m_configuration.isAlertCacheEnabled()) {
            this.m_currentAlertCache.invalidateAll();
        }
        this.m_alertEventPublisher.publish(new AggregateAlertRecalculateEvent(clusterId));
        return removedItems;
    }

    @Transactional
    public void create(AlertHistoryEntity alert) {
        ((EntityManager)this.m_entityManagerProvider.get()).persist((Object)alert);
    }

    @Transactional
    public void refresh(AlertHistoryEntity alert) {
        ((EntityManager)this.m_entityManagerProvider.get()).refresh((Object)alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertHistoryEntity merge(AlertHistoryEntity alert) {
        if (this.m_configuration.isAlertCacheEnabled()) {
            AlertsDAO alertsDAO = this;
            synchronized (alertsDAO) {
                return this.mergeTransactional(alert);
            }
        }
        return this.mergeTransactional(alert);
    }

    @Transactional
    protected AlertHistoryEntity mergeTransactional(AlertHistoryEntity alert) {
        return (AlertHistoryEntity)((EntityManager)this.m_entityManagerProvider.get()).merge((Object)alert);
    }

    @Transactional
    public void remove(AlertHistoryEntity alert) {
        alert = this.merge(alert);
        this.removeCurrentByHistoryId(alert.getAlertId());
        ((EntityManager)this.m_entityManagerProvider.get()).remove((Object)alert);
    }

    @Transactional
    public void create(AlertCurrentEntity alert) {
        ((EntityManager)this.m_entityManagerProvider.get()).persist((Object)alert);
    }

    @Transactional
    public void refresh(AlertCurrentEntity alert) {
        ((EntityManager)this.m_entityManagerProvider.get()).refresh((Object)alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertCurrentEntity merge(AlertCurrentEntity alert) {
        if (this.m_configuration.isAlertCacheEnabled()) {
            AlertsDAO alertsDAO = this;
            synchronized (alertsDAO) {
                return this.mergeTransactional(alert);
            }
        }
        return this.mergeTransactional(alert);
    }

    @Transactional
    protected AlertCurrentEntity mergeTransactional(AlertCurrentEntity alert) {
        alert = (AlertCurrentEntity)((EntityManager)this.m_entityManagerProvider.get()).merge((Object)alert);
        if (this.m_configuration.isAlertCacheEnabled()) {
            AlertCacheKey key = AlertCacheKey.build(alert);
            this.m_currentAlertCache.put((Object)key, (Object)alert);
        }
        return alert;
    }

    public AlertCurrentEntity merge(AlertCurrentEntity alert, boolean updateCacheOnly) {
        if (updateCacheOnly) {
            AlertCacheKey key = AlertCacheKey.build(alert);
            if (!this.m_configuration.isAlertCacheEnabled()) {
                LOG.error("Unable to update a cached alert instance for {} because cached alerts are not enabled", (Object)key);
            } else {
                this.m_currentAlertCache.put((Object)key, (Object)alert);
                return alert;
            }
        }
        return this.merge(alert);
    }

    @Transactional
    public void remove(AlertCurrentEntity alert) {
        ((EntityManager)this.m_entityManagerProvider.get()).remove((Object)this.merge(alert));
    }

    @RequiresSession
    public AlertSummaryDTO findAggregateCounts(long clusterId, String alertName) {
        String sql = String.format(ALERT_COUNT_SQL_TEMPLATE, AlertSummaryDTO.class.getName());
        StringBuilder buffer = new StringBuilder(sql);
        buffer.append(" AND history.alertDefinition.definitionName = :definitionName");
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createQuery(buffer.toString(), AlertSummaryDTO.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("okState", (Object)AlertState.OK);
        query.setParameter("warningState", (Object)AlertState.WARNING);
        query.setParameter("criticalState", (Object)AlertState.CRITICAL);
        query.setParameter("unknownState", (Object)AlertState.UNKNOWN);
        query.setParameter("maintenanceStateOff", (Object)MaintenanceState.OFF);
        query.setParameter("definitionName", (Object)alertName);
        return (AlertSummaryDTO)this.m_daoUtils.selectSingle(query, new Object[0]);
    }

    public AlertCurrentEntity findCurrentByNameNoHost(long clusterId, String alertName) {
        block3: {
            if (this.m_configuration.isAlertCacheEnabled()) {
                AlertCacheKey key = new AlertCacheKey(clusterId, alertName);
                try {
                    return (AlertCurrentEntity)this.m_currentAlertCache.get((Object)key);
                }
                catch (ExecutionException executionException) {
                    Throwable cause = executionException.getCause();
                    if (cause instanceof AlertNotYetCreatedException) break block3;
                    LOG.warn("Unable to retrieve alert for key {} from, the cache", (Object)key);
                }
            }
        }
        return this.findCurrentByNameNoHostInternalInJPA(clusterId, alertName);
    }

    @RequiresSession
    private AlertCurrentEntity findCurrentByNameNoHostInternalInJPA(long clusterId, String alertName) {
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery("AlertCurrentEntity.findByNameAndNoHost", AlertCurrentEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("definitionName", (Object)alertName);
        return (AlertCurrentEntity)this.m_daoUtils.selectOne(query, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCachedEntitiesToJPA() {
        if (this.m_configuration.isAlertCacheEnabled()) {
            AlertsDAO alertsDAO = this;
            synchronized (alertsDAO) {
                this.flushCachedEntitiesToJPATransactional();
            }
        } else {
            LOG.warn("Unable to flush cached alerts to JPA because caching is not enabled");
        }
    }

    @Transactional
    protected void flushCachedEntitiesToJPATransactional() {
        long cachedEntityCount = this.m_currentAlertCache.size();
        ConcurrentMap map = this.m_currentAlertCache.asMap();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            this.merge((AlertCurrentEntity)entry.getValue());
        }
        this.m_currentAlertCache.invalidateAll();
        LOG.info("Flushed {} cached alerts to the database", (Object)cachedEntityCount);
    }

    private List<AlertCurrentEntity> supplementWithCachedAlerts(List<AlertCurrentEntity> alerts) {
        ArrayList<AlertCurrentEntity> cachedAlerts = new ArrayList<AlertCurrentEntity>(alerts.size());
        for (AlertCurrentEntity alert : alerts) {
            AlertCacheKey key = AlertCacheKey.build(alert);
            AlertCurrentEntity cachedEntity = (AlertCurrentEntity)this.m_currentAlertCache.getIfPresent((Object)key);
            if (null != cachedEntity) {
                if (cachedEntity.getAlertHistory() == null) {
                    LOG.warn("There is current entity with null history in the cache, currentId: {}, persisted historyId: {}", (Object)cachedEntity.getAlertId(), (Object)alert.getHistoryId());
                }
                alert = cachedEntity;
            }
            cachedAlerts.add(alert);
        }
        return cachedAlerts;
    }

    @Override
    @Transactional
    public long cleanup(TimeBasedCleanupPolicy policy) {
        long affectedRows = 0L;
        Long clusterId = null;
        try {
            clusterId = ((Clusters)this.m_clusters.get()).getCluster(policy.getClusterName()).getClusterId();
            affectedRows += (long)this.cleanAlertNoticesForClusterBeforeDate(clusterId, policy.getToDateInMillis());
            affectedRows += (long)this.cleanAlertCurrentsForClusterBeforeDate(clusterId, policy.getToDateInMillis());
        }
        catch (OBDPException e) {
            LOG.error("Error while looking up cluster with name: {}", (Object)policy.getClusterName(), (Object)e);
            throw new IllegalStateException(e);
        }
        return affectedRows += (long)this.cleanAlertHistoriesForClusterBeforeDate(clusterId, policy.getToDateInMillis());
    }

    private List<Integer> findAllAlertHistoryIdsBeforeDate(Long clusterId, long beforeDateMillis) {
        EntityManager entityManager = (EntityManager)this.m_entityManagerProvider.get();
        TypedQuery alertHistoryQuery = entityManager.createNamedQuery("AlertHistoryEntity.findAllIdsInClusterBeforeDate", Integer.class);
        alertHistoryQuery.setParameter("clusterId", (Object)clusterId);
        alertHistoryQuery.setParameter("beforeDate", (Object)beforeDateMillis);
        return this.m_daoUtils.selectList(alertHistoryQuery, new Object[0]);
    }

    @Transactional
    int cleanAlertNoticesForClusterBeforeDate(Long clusterId, long beforeDateMillis) {
        LOG.info("Deleting AlertNotice entities before date " + new Date(beforeDateMillis));
        EntityManager entityManager = (EntityManager)this.m_entityManagerProvider.get();
        List<Integer> ids = this.findAllAlertHistoryIdsBeforeDate(clusterId, beforeDateMillis);
        int affectedRows = 0;
        TypedQuery noticeQuery = entityManager.createNamedQuery("AlertNoticeEntity.removeByHistoryIds", AlertNoticeEntity.class);
        if (ids != null && !ids.isEmpty()) {
            for (int i = 0; i < ids.size(); i += 999) {
                int endIndex = i + 999 > ids.size() ? ids.size() : i + 999;
                List<Integer> idsSubList = ids.subList(i, endIndex);
                LOG.info("Deleting AlertNotice entity batch with history ids: " + idsSubList.get(0) + " - " + idsSubList.get(idsSubList.size() - 1));
                noticeQuery.setParameter("historyIds", idsSubList);
                affectedRows += noticeQuery.executeUpdate();
            }
        }
        return affectedRows;
    }

    @Transactional
    int cleanAlertCurrentsForClusterBeforeDate(long clusterId, long beforeDateMillis) {
        LOG.info("Deleting AlertCurrent entities before date " + new Date(beforeDateMillis));
        EntityManager entityManager = (EntityManager)this.m_entityManagerProvider.get();
        List<Integer> ids = this.findAllAlertHistoryIdsBeforeDate(clusterId, beforeDateMillis);
        int affectedRows = 0;
        TypedQuery currentQuery = entityManager.createNamedQuery("AlertCurrentEntity.removeByHistoryIds", AlertCurrentEntity.class);
        if (ids != null && !ids.isEmpty()) {
            for (int i = 0; i < ids.size(); i += 999) {
                int endIndex = i + 999 > ids.size() ? ids.size() : i + 999;
                List<Integer> idsSubList = ids.subList(i, endIndex);
                LOG.info("Deleting AlertCurrent entity batch with history ids: " + idsSubList.get(0) + " - " + idsSubList.get(idsSubList.size() - 1));
                currentQuery.setParameter("historyIds", ids.subList(i, endIndex));
                affectedRows += currentQuery.executeUpdate();
            }
        }
        return affectedRows;
    }

    @Transactional
    int cleanAlertHistoriesForClusterBeforeDate(Long clusterId, long beforeDateMillis) {
        return this.executeQuery("AlertHistoryEntity.removeInClusterBeforeDate", AlertHistoryEntity.class, clusterId, beforeDateMillis);
    }

    private int executeQuery(String namedQuery, Class entityType, long clusterId, long timestamp) {
        LOG.info("Starting: Delete/update entries older than [ {} ] for entity [{}]", (Object)timestamp, (Object)entityType);
        TypedQuery query = ((EntityManager)this.m_entityManagerProvider.get()).createNamedQuery(namedQuery, entityType);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("beforeDate", (Object)timestamp);
        int affectedRows = query.executeUpdate();
        ((EntityManager)this.m_entityManagerProvider.get()).flush();
        ((EntityManager)this.m_entityManagerProvider.get()).clear();
        LOG.info("Completed: Delete/update entries older than [ {} ] for entity: [{}]. Number of entities deleted: [{}]", new Object[]{timestamp, entityType, affectedRows});
        return affectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEntities(List<AlertCurrentEntity> toMerge, List<AlertCurrentEntity> toCreateHistoryAndMerge) {
        if (this.m_configuration.isAlertCacheEnabled()) {
            AlertsDAO alertsDAO = this;
            synchronized (alertsDAO) {
                this.saveEntitiesTransactional(toMerge, toCreateHistoryAndMerge);
            }
        } else {
            this.saveEntitiesTransactional(toMerge, toCreateHistoryAndMerge);
        }
    }

    @Transactional
    protected void saveEntitiesTransactional(List<AlertCurrentEntity> toMerge, List<AlertCurrentEntity> toCreateHistoryAndMerge) {
        for (AlertCurrentEntity entity : toMerge) {
            this.merge(entity, this.m_configuration.isAlertCacheEnabled());
        }
        for (AlertCurrentEntity entity : toCreateHistoryAndMerge) {
            this.create(entity.getAlertHistory());
            this.merge(entity);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Alert State Merged: CurrentId {}, CurrentTimestamp {}, HistoryId {}, HistoryState {}", new Object[]{entity.getAlertId(), entity.getLatestTimestamp(), entity.getAlertHistory().getAlertId(), entity.getAlertHistory().getAlertState()});
        }
    }

    private final class HistoryPredicateVisitor
    extends JpaPredicateVisitor<AlertHistoryEntity> {
        public HistoryPredicateVisitor() {
            super((EntityManager)AlertsDAO.this.m_entityManagerProvider.get(), AlertHistoryEntity.class);
        }

        @Override
        public Class<AlertHistoryEntity> getEntityClass() {
            return AlertHistoryEntity.class;
        }

        @Override
        public List<? extends SingularAttribute<?, ?>> getPredicateMapping(String propertyId) {
            return AlertHistoryEntity_.getPredicateMapping().get(propertyId);
        }
    }

    private final class CurrentPredicateVisitor
    extends JpaPredicateVisitor<AlertCurrentEntity> {
        public CurrentPredicateVisitor() {
            super((EntityManager)AlertsDAO.this.m_entityManagerProvider.get(), AlertCurrentEntity.class);
        }

        @Override
        public Class<AlertCurrentEntity> getEntityClass() {
            return AlertCurrentEntity.class;
        }

        @Override
        public List<? extends SingularAttribute<?, ?>> getPredicateMapping(String propertyId) {
            return AlertCurrentEntity_.getPredicateMapping().get(propertyId);
        }
    }

    private static final class AlertCacheKey {
        private final long m_clusterId;
        private final String m_hostName;
        private final String m_alertDefinitionName;

        private AlertCacheKey(long clusterId, String alertDefinitionName) {
            this(clusterId, alertDefinitionName, null);
        }

        private AlertCacheKey(long clusterId, String alertDefinitionName, String hostName) {
            this.m_clusterId = clusterId;
            this.m_alertDefinitionName = alertDefinitionName;
            this.m_hostName = hostName;
        }

        public static AlertCacheKey build(AlertCurrentEntity current) {
            AlertHistoryEntity history = current.getAlertHistory();
            AlertCacheKey key = new AlertCacheKey(history.getClusterId(), history.getAlertDefinition().getDefinitionName(), history.getHostName());
            return key;
        }

        public long getClusterId() {
            return this.m_clusterId;
        }

        public String getHostName() {
            return this.m_hostName;
        }

        public String getAlertDefinitionName() {
            return this.m_alertDefinitionName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_alertDefinitionName == null ? 0 : this.m_alertDefinitionName.hashCode());
            result = 31 * result + (int)(this.m_clusterId ^ this.m_clusterId >>> 32);
            result = 31 * result + (this.m_hostName == null ? 0 : this.m_hostName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AlertCacheKey other = (AlertCacheKey)obj;
            if (this.m_clusterId != other.m_clusterId) {
                return false;
            }
            if (this.m_alertDefinitionName == null ? other.m_alertDefinitionName != null : !this.m_alertDefinitionName.equals(other.m_alertDefinitionName)) {
                return false;
            }
            return !(this.m_hostName == null ? other.m_hostName != null : !this.m_hostName.equals(other.m_hostName));
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("AlertCacheKey{");
            buffer.append("cluserId=").append(this.m_clusterId);
            buffer.append(", alertName=").append(this.m_alertDefinitionName);
            if (null != this.m_hostName) {
                buffer.append(", hostName=").append(this.m_hostName);
            }
            buffer.append("}");
            return buffer.toString();
        }
    }

    private static final class AlertNotYetCreatedException
    extends Exception {
        private AlertNotYetCreatedException() {
        }
    }
}

