/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.dto.AlertGroupUpdate;
import id.onyx.obdp.server.api.query.JpaPredicateVisitor;
import id.onyx.obdp.server.api.query.JpaSortBuilder;
import id.onyx.obdp.server.controller.AlertNoticeRequest;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.events.AlertGroupsUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.orm.entities.AlertNoticeEntity;
import id.onyx.obdp.server.orm.entities.AlertNoticeEntity_;
import id.onyx.obdp.server.orm.entities.AlertTargetEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.NotificationState;
import id.onyx.obdp.server.state.Service;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertDispatchDAO {
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;
    @Inject
    private Provider<Clusters> m_clusters;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    private Striped<Lock> m_locksByService = Striped.lazyWeakLock((int)20);
    private static final Logger LOG = LoggerFactory.getLogger(AlertDispatchDAO.class);

    @RequiresSession
    public AlertGroupEntity findGroupById(long groupId) {
        return (AlertGroupEntity)((EntityManager)this.entityManagerProvider.get()).find(AlertGroupEntity.class, (Object)groupId);
    }

    @RequiresSession
    public List<AlertGroupEntity> findGroupsById(List<Long> groupIds) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertGroupEntity.findByIds", AlertGroupEntity.class);
        query.setParameter("groupIds", groupIds);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public AlertTargetEntity findTargetById(long targetId) {
        return (AlertTargetEntity)((EntityManager)this.entityManagerProvider.get()).find(AlertTargetEntity.class, (Object)targetId);
    }

    @RequiresSession
    public List<AlertTargetEntity> findTargetsById(List<Long> targetIds) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertTargetEntity.findByIds", AlertTargetEntity.class);
        query.setParameter("targetIds", targetIds);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public AlertNoticeEntity findNoticeById(long noticeId) {
        return (AlertNoticeEntity)((EntityManager)this.entityManagerProvider.get()).find(AlertNoticeEntity.class, (Object)noticeId);
    }

    @RequiresSession
    public AlertNoticeEntity findNoticeByUuid(String uuid) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertNoticeEntity.findByUuid", AlertNoticeEntity.class);
        query.setParameter("uuid", (Object)uuid);
        return (AlertNoticeEntity)this.daoUtils.selectOne(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertNoticeEntity> findPendingNotices() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertNoticeEntity.findByState", AlertNoticeEntity.class);
        query.setParameter("notifyState", (Object)NotificationState.PENDING);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public AlertGroupEntity findGroupByName(long clusterId, String groupName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertGroupEntity.findByNameInCluster", AlertGroupEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("groupName", (Object)groupName);
        return (AlertGroupEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public AlertTargetEntity findTargetByName(String targetName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertTargetEntity.findByName", AlertTargetEntity.class);
        query.setParameter("targetName", (Object)targetName);
        return (AlertTargetEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertGroupEntity> findAllGroups() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertGroupEntity.findAll", AlertGroupEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertGroupEntity> findAllGroups(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertGroupEntity.findAllInCluster", AlertGroupEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertTargetEntity> findAllTargets() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertTargetEntity.findAll", AlertTargetEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertTargetEntity> findAllGlobalTargets() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertTargetEntity.findAllGlobal", AlertTargetEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertGroupEntity> findGroupsByDefinition(AlertDefinitionEntity definitionEntity) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertGroupEntity.findByAssociatedDefinition", AlertGroupEntity.class);
        query.setParameter("alertDefinition", (Object)definitionEntity);
        query.setHint("eclipselink.refresh", (Object)"True");
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public AlertGroupEntity findDefaultServiceGroup(long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertGroupEntity.findServiceDefaultGroup", AlertGroupEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        return (AlertGroupEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertNoticeEntity> findAllNotices() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertNoticeEntity.findAll", AlertNoticeEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertNoticeEntity> findAllNotices(AlertNoticeRequest request) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        NoticePredicateVisitor visitor = new NoticePredicateVisitor();
        PredicateHelper.visit(request.Predicate, visitor);
        CriteriaQuery query = visitor.getCriteriaQuery();
        Predicate jpaPredicate = visitor.getJpaPredicate();
        if (null != jpaPredicate) {
            query.where((Expression)jpaPredicate);
        }
        JpaSortBuilder<AlertNoticeEntity> sortBuilder = new JpaSortBuilder<AlertNoticeEntity>();
        List<Order> sortOrders = sortBuilder.buildSortOrders(request.Sort, visitor);
        query.orderBy(sortOrders);
        TypedQuery typedQuery = entityManager.createQuery(query);
        if (null != request.Pagination) {
            typedQuery.setFirstResult(request.Pagination.getOffset());
            typedQuery.setMaxResults(request.Pagination.getPageSize());
        }
        return this.daoUtils.selectList(typedQuery, new Object[0]);
    }

    @RequiresSession
    public int getNoticesCount(id.onyx.obdp.server.controller.spi.Predicate predicate) {
        return 0;
    }

    @Transactional
    public void createGroups(List<AlertGroupEntity> entities) {
        if (null == entities) {
            return;
        }
        ArrayList<AlertGroupUpdate> alertGroupUpdates = new ArrayList<AlertGroupUpdate>(entities.size());
        for (AlertGroupEntity entity : entities) {
            this.create(entity, false);
            alertGroupUpdates.add(new AlertGroupUpdate(entity));
        }
        AlertGroupsUpdateEvent alertGroupsUpdateEvent = new AlertGroupsUpdateEvent(alertGroupUpdates, UpdateEventType.CREATE);
        this.STOMPUpdatePublisher.publish(alertGroupsUpdateEvent);
    }

    @Transactional
    public void create(AlertGroupEntity group) {
        this.create(group, true);
    }

    @Transactional
    public void create(AlertGroupEntity group, boolean fireEvent) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)group);
        List<AlertTargetEntity> targets = this.findAllGlobalTargets();
        if (!targets.isEmpty()) {
            for (AlertTargetEntity target : targets) {
                group.addAlertTarget(target);
            }
            ((EntityManager)this.entityManagerProvider.get()).merge((Object)group);
        }
        if (fireEvent) {
            AlertGroupsUpdateEvent alertGroupsUpdateEvent = new AlertGroupsUpdateEvent(Collections.singletonList(new AlertGroupUpdate(group)), UpdateEventType.CREATE);
            this.STOMPUpdatePublisher.publish(alertGroupsUpdateEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public AlertGroupEntity createDefaultGroup(long clusterId, String serviceName) throws OBDPException {
        Cluster cluster;
        Map<String, Service> services;
        String ambariServiceName = RootService.OBDP.name();
        if (!ambariServiceName.equals(serviceName) && !(services = (cluster = ((Clusters)this.m_clusters.get()).getClusterById(clusterId)).getServices()).containsKey(serviceName)) {
            String message = MessageFormat.format("Unable to create a default alert group for unknown service {0} in cluster {1}", serviceName, cluster.getClusterName());
            throw new OBDPException(message);
        }
        Lock lock = (Lock)this.m_locksByService.get((Object)serviceName);
        lock.lock();
        try {
            AlertGroupEntity group = this.findDefaultServiceGroup(clusterId, serviceName);
            if (null != group) {
                AlertGroupEntity alertGroupEntity = group;
                return alertGroupEntity;
            }
            group = new AlertGroupEntity();
            group.setClusterId(clusterId);
            group.setDefault(true);
            group.setGroupName(serviceName);
            group.setServiceName(serviceName);
            this.create(group);
            AlertGroupEntity alertGroupEntity = group;
            return alertGroupEntity;
        }
        finally {
            lock.unlock();
        }
    }

    @Transactional
    public void refresh(AlertGroupEntity alertGroup) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)alertGroup);
    }

    @Transactional
    public AlertGroupEntity merge(AlertGroupEntity alertGroup) {
        return (AlertGroupEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)alertGroup);
    }

    @Transactional
    public void remove(AlertGroupEntity alertGroup) {
        this.remove(alertGroup, true);
    }

    @Transactional
    public void remove(AlertGroupEntity alertGroup, boolean fireEvent) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)this.merge(alertGroup));
        if (fireEvent) {
            AlertGroupsUpdateEvent alertGroupsUpdateEvent = AlertGroupsUpdateEvent.deleteAlertGroupsUpdateEvent(Collections.singletonList(alertGroup.getGroupId()));
            this.STOMPUpdatePublisher.publish(alertGroupsUpdateEvent);
        }
    }

    @Transactional
    public void removeAllGroups(long clusterId) {
        List<AlertGroupEntity> groups = this.findAllGroups(clusterId);
        for (AlertGroupEntity group : groups) {
            this.remove(group, false);
        }
        AlertGroupsUpdateEvent alertGroupsUpdateEvent = AlertGroupsUpdateEvent.deleteAlertGroupsUpdateEvent(groups.stream().map(AlertGroupEntity::getGroupId).collect(Collectors.toList()));
        this.STOMPUpdatePublisher.publish(alertGroupsUpdateEvent);
    }

    @Transactional
    public void createTargets(List<AlertTargetEntity> entities) {
        if (null == entities) {
            return;
        }
        for (AlertTargetEntity entity : entities) {
            this.create(entity);
        }
    }

    @Transactional
    public List<AlertNoticeEntity> createNotices(List<AlertNoticeEntity> entities) {
        if (null == entities || entities.isEmpty()) {
            return entities;
        }
        ArrayList<AlertNoticeEntity> managedEntities = new ArrayList<AlertNoticeEntity>(entities.size());
        for (AlertNoticeEntity entity : entities) {
            AlertNoticeEntity managedEntity = this.merge(entity);
            managedEntities.add(managedEntity);
        }
        return managedEntities;
    }

    @Transactional
    public void create(AlertTargetEntity alertTarget) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)alertTarget);
        if (alertTarget.isGlobal()) {
            List<AlertGroupEntity> groups = this.findAllGroups();
            for (AlertGroupEntity group : groups) {
                group.addAlertTarget(alertTarget);
                this.merge(group);
                AlertGroupsUpdateEvent alertGroupsUpdateEvent = new AlertGroupsUpdateEvent(Collections.singletonList(new AlertGroupUpdate(group)), UpdateEventType.UPDATE);
                this.STOMPUpdatePublisher.publish(alertGroupsUpdateEvent);
            }
        }
    }

    @Transactional
    public void refresh(AlertTargetEntity alertTarget) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)alertTarget);
    }

    @Transactional
    public AlertTargetEntity merge(AlertTargetEntity alertTarget) {
        return (AlertTargetEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)alertTarget);
    }

    @Transactional
    public void remove(AlertTargetEntity alertTarget) {
        ArrayList<AlertGroupUpdate> alertGroupUpdates = new ArrayList<AlertGroupUpdate>();
        for (AlertGroupEntity alertGroupEntity : alertTarget.getAlertGroups()) {
            AlertGroupUpdate alertGroupUpdate = new AlertGroupUpdate(alertGroupEntity);
            alertGroupUpdate.getTargets().remove(alertTarget.getTargetId());
            alertGroupUpdates.add(alertGroupUpdate);
        }
        this.STOMPUpdatePublisher.publish(new AlertGroupsUpdateEvent(alertGroupUpdates, UpdateEventType.UPDATE));
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)alertTarget);
    }

    @Transactional
    public void create(AlertNoticeEntity alertNotice) {
        ((EntityManager)this.entityManagerProvider.get()).persist((Object)alertNotice);
    }

    @Transactional
    public void refresh(AlertNoticeEntity alertNotice) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)alertNotice);
    }

    @Transactional
    public AlertNoticeEntity merge(AlertNoticeEntity alertNotice) {
        return (AlertNoticeEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)alertNotice);
    }

    @Transactional
    public void remove(AlertNoticeEntity alertNotice) {
        ((EntityManager)this.entityManagerProvider.get()).remove((Object)alertNotice);
    }

    @Transactional
    public void removeNoticeByDefinitionId(long definitionId) {
        LOG.info("Deleting AlertNotice entities by definition id.");
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        TypedQuery historyIdQuery = entityManager.createNamedQuery("AlertHistoryEntity.findHistoryIdsByDefinitionId", Integer.class);
        historyIdQuery.setParameter("definitionId", (Object)definitionId);
        List ids = this.daoUtils.selectList(historyIdQuery, new Object[0]);
        int BATCH_SIZE = 999;
        TypedQuery noticeQuery = entityManager.createNamedQuery("AlertNoticeEntity.removeByHistoryIds", AlertNoticeEntity.class);
        if (ids != null && !ids.isEmpty()) {
            for (int i = 0; i < ids.size(); i += BATCH_SIZE) {
                int endIndex = i + BATCH_SIZE > ids.size() ? ids.size() : i + BATCH_SIZE;
                List idsSubList = ids.subList(i, endIndex);
                LOG.info("Deleting AlertNotice entity batch with history ids: " + idsSubList.get(0) + " - " + idsSubList.get(idsSubList.size() - 1));
                noticeQuery.setParameter("historyIds", idsSubList);
                noticeQuery.executeUpdate();
            }
        }
        entityManager.clear();
    }

    private final class NoticePredicateVisitor
    extends JpaPredicateVisitor<AlertNoticeEntity> {
        public NoticePredicateVisitor() {
            super((EntityManager)AlertDispatchDAO.this.entityManagerProvider.get(), AlertNoticeEntity.class);
        }

        @Override
        public Class<AlertNoticeEntity> getEntityClass() {
            return AlertNoticeEntity.class;
        }

        @Override
        public List<? extends SingularAttribute<?, ?>> getPredicateMapping(String propertyId) {
            return AlertNoticeEntity_.getPredicateMapping().get(propertyId);
        }
    }
}

