/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.dto.AlertGroupUpdate;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.events.AlertDefinitionChangedEvent;
import id.onyx.obdp.server.events.AlertDefinitionDeleteEvent;
import id.onyx.obdp.server.events.AlertDefinitionRegistrationEvent;
import id.onyx.obdp.server.events.AlertGroupsUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.RequiresSession;
import id.onyx.obdp.server.orm.dao.AlertDispatchDAO;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.dao.DaoUtils;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.Scope;
import id.onyx.obdp.server.state.alert.SourceType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertDefinitionDAO {
    private static final Logger LOG = LoggerFactory.getLogger(AlertDefinitionDAO.class);
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private DaoUtils daoUtils;
    @Inject
    private AlertsDAO alertsDao;
    @Inject
    private AlertDispatchDAO dispatchDao;
    @Inject
    private OBDPEventPublisher eventPublisher;
    @Inject
    private AlertDefinitionFactory alertDefinitionFactory;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;

    @RequiresSession
    public AlertDefinitionEntity findById(long definitionId) {
        return (AlertDefinitionEntity)((EntityManager)this.entityManagerProvider.get()).find(AlertDefinitionEntity.class, (Object)definitionId);
    }

    @RequiresSession
    public AlertDefinitionEntity findByName(long clusterId, String definitionName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findByName", AlertDefinitionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("definitionName", (Object)definitionName);
        return (AlertDefinitionEntity)this.daoUtils.selectSingle(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findAll() {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findAll", AlertDefinitionEntity.class);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findAll(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findAllInCluster", AlertDefinitionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findAllEnabled(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findAllEnabledInCluster", AlertDefinitionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findByIds(List<Long> definitionIds) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findByIds", AlertDefinitionEntity.class);
        query.setParameter("definitionIds", definitionIds);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findByService(long clusterId, String serviceName) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findByService", AlertDefinitionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findByServiceMaster(long clusterId, Set<String> services) {
        if (null == services || services.size() == 0) {
            return Collections.emptyList();
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findByServiceMaster", AlertDefinitionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("services", services);
        query.setParameter("scope", (Object)Scope.SERVICE);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findByServiceComponent(long clusterId, String serviceName, String componentName) {
        if (null == serviceName || null == componentName) {
            return Collections.emptyList();
        }
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findByServiceAndComponent", AlertDefinitionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)serviceName);
        query.setParameter("componentName", (Object)componentName);
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findAgentScoped(long clusterId) {
        TypedQuery query = ((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findByServiceAndComponent", AlertDefinitionEntity.class);
        query.setParameter("clusterId", (Object)clusterId);
        query.setParameter("serviceName", (Object)RootService.OBDP.name());
        query.setParameter("componentName", (Object)RootComponent.AMBARI_AGENT.name());
        return this.daoUtils.selectList(query, new Object[0]);
    }

    @RequiresSession
    public List<AlertDefinitionEntity> findBySourceType(Long clusterId, SourceType sourceType) {
        return this.daoUtils.selectList(((EntityManager)this.entityManagerProvider.get()).createNamedQuery("AlertDefinitionEntity.findBySourceType", AlertDefinitionEntity.class).setParameter("clusterId", (Object)clusterId).setParameter("sourceType", (Object)sourceType), new Object[0]);
    }

    @Transactional
    public void create(AlertDefinitionEntity alertDefinition) throws OBDPException {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        entityManager.persist((Object)alertDefinition);
        AlertGroupEntity group = this.dispatchDao.findDefaultServiceGroup(alertDefinition.getClusterId(), alertDefinition.getServiceName());
        if (null == group) {
            String serviceName = alertDefinition.getServiceName();
            group = this.dispatchDao.createDefaultGroup(alertDefinition.getClusterId(), serviceName);
        }
        group.addAlertDefinition(alertDefinition);
        AlertGroupsUpdateEvent alertGroupsUpdateEvent = new AlertGroupsUpdateEvent(Collections.singletonList(new AlertGroupUpdate(group)), UpdateEventType.UPDATE);
        this.STOMPUpdatePublisher.publish(alertGroupsUpdateEvent);
        this.dispatchDao.merge(group);
        AlertDefinition coerced = this.alertDefinitionFactory.coerce(alertDefinition);
        if (null != coerced) {
            AlertDefinitionRegistrationEvent event = new AlertDefinitionRegistrationEvent(alertDefinition.getClusterId(), coerced);
            this.eventPublisher.publish(event);
        } else {
            LOG.warn("Unable to broadcast alert registration event for {}", (Object)alertDefinition.getDefinitionName());
        }
        entityManager.refresh((Object)alertDefinition);
    }

    @Transactional
    public void refresh(AlertDefinitionEntity alertDefinition) {
        ((EntityManager)this.entityManagerProvider.get()).refresh((Object)alertDefinition);
    }

    @Transactional
    public AlertDefinitionEntity merge(AlertDefinitionEntity alertDefinition) {
        AlertDefinitionEntity entity = (AlertDefinitionEntity)((EntityManager)this.entityManagerProvider.get()).merge((Object)alertDefinition);
        AlertDefinition definition = this.alertDefinitionFactory.coerce(entity);
        AlertDefinitionChangedEvent event = new AlertDefinitionChangedEvent(alertDefinition.getClusterId(), definition);
        this.eventPublisher.publish(event);
        return entity;
    }

    public void createOrUpdate(AlertDefinitionEntity alertDefinition) throws OBDPException {
        if (null == alertDefinition.getDefinitionId()) {
            this.create(alertDefinition);
        } else {
            this.merge(alertDefinition);
        }
    }

    @Transactional
    public void remove(AlertDefinitionEntity alertDefinition) {
        this.dispatchDao.removeNoticeByDefinitionId(alertDefinition.getDefinitionId());
        this.alertsDao.removeByDefinitionId(alertDefinition.getDefinitionId());
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        alertDefinition = this.findById(alertDefinition.getDefinitionId());
        if (null != alertDefinition) {
            entityManager.remove((Object)alertDefinition);
            AlertDefinition coerced = this.alertDefinitionFactory.coerce(alertDefinition);
            if (null != coerced) {
                AlertDefinitionDeleteEvent event = new AlertDefinitionDeleteEvent(alertDefinition.getClusterId(), coerced);
                this.eventPublisher.publish(event);
            } else {
                LOG.warn("Unable to broadcast alert removal event for {}", (Object)alertDefinition.getDefinitionName());
            }
        }
    }

    @Transactional
    public void removeAll(long clusterId) {
        List<AlertDefinitionEntity> definitions = this.findAll(clusterId);
        for (AlertDefinitionEntity definition : definitions) {
            this.remove(definition);
        }
    }
}

