/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.TransactionalLock;
import id.onyx.obdp.server.configuration.Configuration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Singleton
public class TransactionalLocks {
    private final Configuration m_configuration;
    private final ConcurrentHashMap<TransactionalLock.LockArea, ReadWriteLock> m_locks;

    @Inject
    private TransactionalLocks(Configuration configuration) {
        this.m_configuration = configuration;
        this.m_locks = new ConcurrentHashMap();
        for (TransactionalLock.LockArea lockArea : TransactionalLock.LockArea.values()) {
            ReadWriteLock lock = lockArea.isEnabled(this.m_configuration) ? new ReentrantReadWriteLock(true) : new NoOperationReadWriteLock();
            this.m_locks.put(lockArea, lock);
        }
    }

    public ReadWriteLock getLock(TransactionalLock.LockArea lockArea) {
        return this.m_locks.get((Object)lockArea);
    }

    private static final class NoOperationReadWriteLock
    implements ReadWriteLock {
        private final Lock m_readLock = new NoOperationLock();
        private final Lock m_writeLock = new NoOperationLock();

        private NoOperationReadWriteLock() {
        }

        @Override
        public Lock readLock() {
            return this.m_readLock;
        }

        @Override
        public Lock writeLock() {
            return this.m_writeLock;
        }
    }

    private static final class NoOperationLock
    implements Lock {
        private NoOperationLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            return null;
        }
    }
}

