/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm;

import com.google.inject.Inject;
import com.google.inject.persist.jpa.OBDPJpaPersistService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class OBDPLocalSessionInterceptor
implements MethodInterceptor {
    @Inject
    private OBDPJpaPersistService emProvider;
    private final ThreadLocal<Boolean> didWeStartWork = new ThreadLocal();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.emProvider.isWorking()) {
            this.emProvider.begin();
            this.didWeStartWork.set(true);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                if (null != this.didWeStartWork.get()) {
                    this.didWeStartWork.remove();
                    this.emProvider.end();
                }
            }
        }
        return invocation.proceed();
    }
}

