/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.google.inject.persist.UnitOfWork;
import com.google.inject.persist.jpa.OBDPJpaPersistService;
import id.onyx.obdp.annotations.TransactionalLock;
import id.onyx.obdp.server.orm.TransactionalLocks;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBDPJpaLocalTxnInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPJpaLocalTxnInterceptor.class);
    private static final ThreadLocal<LinkedList<TransactionalLock>> s_transactionalLocks = new ThreadLocal<LinkedList<TransactionalLock>>(){

        @Override
        protected LinkedList<TransactionalLock> initialValue() {
            return new LinkedList<TransactionalLock>();
        }
    };
    @Inject
    private final TransactionalLocks transactionLocks = null;
    @Inject
    private final OBDPJpaPersistService emProvider = null;
    @Inject
    private final UnitOfWork unitOfWork = null;
    private final ThreadLocal<Boolean> didWeStartWork = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (!this.emProvider.isWorking()) {
            this.emProvider.begin();
            this.didWeStartWork.set(true);
        }
        Transactional transactional = this.readTransactionMetadata(methodInvocation);
        EntityManager em = this.emProvider.get();
        this.lockTransaction(methodInvocation);
        if (em.getTransaction().isActive()) {
            return methodInvocation.proceed();
        }
        try {
            Object result;
            EntityTransaction txn = em.getTransaction();
            txn.begin();
            try {
                result = methodInvocation.proceed();
            }
            catch (Exception e) {
                if (OBDPJpaLocalTxnInterceptor.rollbackIfNecessary(transactional, e, txn)) {
                    txn.commit();
                }
                this.detailedLogForPersistenceError(e);
                throw e;
            }
            finally {
                if (null != this.didWeStartWork.get() && !txn.isActive()) {
                    this.didWeStartWork.remove();
                    this.unitOfWork.end();
                }
            }
            try {
                txn.commit();
            }
            catch (Exception e) {
                this.detailedLogForPersistenceError(e);
                throw e;
            }
            finally {
                if (null != this.didWeStartWork.get()) {
                    this.didWeStartWork.remove();
                    this.unitOfWork.end();
                }
            }
            Object object = result;
            return object;
        }
        finally {
            this.unlockTransaction();
        }
    }

    private void detailedLogForPersistenceError(Exception e) {
        PersistenceException rbe;
        Throwable cause;
        if (e instanceof PersistenceException && (cause = (rbe = (PersistenceException)e).getCause()) != null && cause instanceof EclipseLinkException) {
            EclipseLinkException de = (EclipseLinkException)cause;
            LOG.error("[DETAILED ERROR] Rollback reason: ", cause);
            Throwable internal = de.getInternalException();
            int exIndent = 1;
            if (internal != null && internal instanceof SQLException) {
                SQLException exception = (SQLException)internal;
                while (exception != null) {
                    LOG.error("[DETAILED ERROR] Internal exception (" + exIndent + ") : ", (Throwable)exception);
                    exception = exception.getNextException();
                    ++exIndent;
                }
            }
        }
    }

    private Transactional readTransactionMetadata(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = methodInvocation.getThis().getClass();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (null == transactional) {
            transactional = targetClass.getAnnotation(Transactional.class);
        }
        if (null == transactional) {
            transactional = Internal.class.getAnnotation(Transactional.class);
        }
        return transactional;
    }

    static boolean rollbackIfNecessary(Transactional transactional, Exception e, EntityTransaction txn) {
        if (txn.getRollbackOnly()) {
            txn.rollback();
            return false;
        }
        boolean commit = true;
        for (Class rollBackOn : transactional.rollbackOn()) {
            if (!rollBackOn.isInstance(e)) continue;
            commit = false;
            for (Class exceptOn : transactional.ignore()) {
                if (!exceptOn.isInstance(e)) continue;
                commit = true;
                break;
            }
            if (commit) break;
            txn.rollback();
            break;
        }
        return commit;
    }

    private void lockTransaction(MethodInvocation methodInvocation) {
        TransactionalLock annotation = methodInvocation.getMethod().getAnnotation(TransactionalLock.class);
        if (null == annotation) {
            return;
        }
        if (s_transactionalLocks.get().contains(annotation)) {
            return;
        }
        TransactionalLock.LockArea lockArea = annotation.lockArea();
        TransactionalLock.LockType lockType = annotation.lockType();
        ReadWriteLock rwLock = this.transactionLocks.getLock(lockArea);
        Lock lock = lockType == TransactionalLock.LockType.READ ? rwLock.readLock() : rwLock.writeLock();
        lock.lock();
        s_transactionalLocks.get().add(annotation);
    }

    private void unlockTransaction() {
        LinkedList<TransactionalLock> annotations = s_transactionalLocks.get();
        if (annotations.isEmpty()) {
            return;
        }
        Iterator<TransactionalLock> iterator = annotations.descendingIterator();
        while (iterator.hasNext()) {
            TransactionalLock annotation = iterator.next();
            TransactionalLock.LockArea lockArea = annotation.lockArea();
            TransactionalLock.LockType lockType = annotation.lockType();
            ReadWriteLock rwLock = this.transactionLocks.getLock(lockArea);
            Lock lock = lockType == TransactionalLock.LockType.READ ? rwLock.readLock() : rwLock.writeLock();
            lock.unlock();
            iterator.remove();
        }
    }

    @Transactional
    private static class Internal {
        private Internal() {
        }
    }
}

