/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.helpers.ScriptRunner;
import id.onyx.obdp.server.orm.helpers.dbms.DbmsHelper;
import id.onyx.obdp.server.orm.helpers.dbms.DerbyHelper;
import id.onyx.obdp.server.orm.helpers.dbms.GenericDbmsHelper;
import id.onyx.obdp.server.orm.helpers.dbms.H2Helper;
import id.onyx.obdp.server.orm.helpers.dbms.MySqlHelper;
import id.onyx.obdp.server.orm.helpers.dbms.OracleHelper;
import id.onyx.obdp.server.orm.helpers.dbms.PostgresHelper;
import id.onyx.obdp.server.utils.CustomStringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.DBPlatformHelper;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.H2Platform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.database.PostgreSQLPlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.JdbcUtils;

@Singleton
public class DBAccessorImpl
implements DBAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(DBAccessorImpl.class);
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String NULL_CATALOG_MEANS_CURRENT = "nullCatalogMeansCurrent";
    public static final String TRUE = "true";
    public static final int SUPPORT_CONNECTOR_VERSION = 5;
    private final DatabasePlatform databasePlatform;
    private final Connection connection;
    private final DbmsHelper dbmsHelper;
    private Configuration configuration;
    private DatabaseMetaData databaseMetaData;
    private static final String dbURLPatternString = "jdbc:(.*?):.*";
    private DBAccessor.DbType dbType;
    private final String dbSchema;

    @Inject
    public DBAccessorImpl(Configuration configuration) {
        this.configuration = configuration;
        try {
            Class.forName(configuration.getDatabaseDriver());
            this.connection = this.getNewConnection();
            this.connection.setAutoCommit(true);
            String vendorName = this.connection.getMetaData().getDatabaseProductName();
            String majorVersion = Integer.toString(this.connection.getMetaData().getDatabaseMajorVersion());
            String minorVersion = Integer.toString(this.connection.getMetaData().getDatabaseMinorVersion());
            String dbPlatform = DBPlatformHelper.getDBPlatform((String)vendorName, (String)majorVersion, (String)minorVersion, (SessionLog)new AbstractSessionLog(){

                public void log(SessionLogEntry sessionLogEntry) {
                    LOG.debug(sessionLogEntry.getMessage());
                }
            });
            this.databasePlatform = (DatabasePlatform)Class.forName(dbPlatform).newInstance();
            this.dbmsHelper = this.loadHelper(this.databasePlatform);
            this.dbSchema = this.convertObjectName(configuration.getDatabaseSchema());
        }
        catch (Exception e) {
            String message = "";
            message = e instanceof ClassNotFoundException ? "If you are using a non-default database for OBDP and a custom JDBC driver jar, you need to set property \"server.jdbc.driver.path={path/to/custom_jdbc_driver}\" in obdp.properties config file, to include it in obdp-server classpath." : "Error while creating database accessor ";
            LOG.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    protected DbmsHelper loadHelper(DatabasePlatform databasePlatform) {
        if (databasePlatform instanceof OraclePlatform) {
            this.dbType = DBAccessor.DbType.ORACLE;
            return new OracleHelper(databasePlatform);
        }
        if (databasePlatform instanceof MySQLPlatform) {
            this.dbType = DBAccessor.DbType.MYSQL;
            return new MySqlHelper(databasePlatform);
        }
        if (databasePlatform instanceof PostgreSQLPlatform) {
            this.dbType = DBAccessor.DbType.POSTGRES;
            return new PostgresHelper(databasePlatform);
        }
        if (databasePlatform instanceof DerbyPlatform) {
            this.dbType = DBAccessor.DbType.DERBY;
            return new DerbyHelper(databasePlatform);
        }
        if (databasePlatform instanceof H2Platform) {
            this.dbType = DBAccessor.DbType.H2;
            return new H2Helper(databasePlatform);
        }
        this.dbType = DBAccessor.DbType.UNKNOWN;
        return new GenericDbmsHelper(databasePlatform);
    }

    private static Class<?> fromSqlTypeToClass(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return Byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Timestamp.class;
            }
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Connection getNewConnection() {
        try {
            Properties properties = new Properties();
            properties.setProperty(USER, this.configuration.getDatabaseUser());
            properties.setProperty(PASSWORD, this.configuration.getDatabasePassword());
            if (this.configuration.getDatabaseUrl().contains("mysql") && DriverManager.getDriver(this.configuration.getDatabaseUrl()).getMajorVersion() > 5) {
                properties.setProperty(NULL_CATALOG_MEANS_CURRENT, TRUE);
            }
            return DriverManager.getConnection(this.configuration.getDatabaseUrl(), properties);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to connect to database", e);
        }
    }

    @Override
    public String quoteObjectName(String name) {
        return this.dbmsHelper.quoteObjectName(name);
    }

    @Override
    public void createTable(String tableName, List<DBAccessor.DBColumnInfo> columnInfo, String ... primaryKeyColumns) throws SQLException {
        if (this.tableExists(tableName)) {
            return;
        }
        primaryKeyColumns = ArrayUtils.nullToEmpty((String[])primaryKeyColumns);
        String query = this.dbmsHelper.getCreateTableStatement(tableName, columnInfo, Arrays.asList(primaryKeyColumns));
        this.executeQuery(query);
    }

    protected DatabaseMetaData getDatabaseMetaData() throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = this.connection.getMetaData();
        }
        return this.databaseMetaData;
    }

    private String convertObjectName(String objectName) throws SQLException {
        if (objectName == null) {
            return null;
        }
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        if (metaData.storesLowerCaseIdentifiers()) {
            return objectName.toLowerCase();
        }
        if (metaData.storesUpperCaseIdentifiers()) {
            return objectName.toUpperCase();
        }
        return objectName;
    }

    private void setArgumentsForPreparedStatement(PreparedStatement preparedStatement, Object[] arguments) throws SQLException {
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] instanceof byte[]) {
                byte[] binaryData = (byte[])arguments[i];
                preparedStatement.setBinaryStream(i + 1, (InputStream)new ByteArrayInputStream(binaryData), binaryData.length);
                continue;
            }
            preparedStatement.setObject(i + 1, arguments[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(String tableName) throws SQLException {
        boolean result = false;
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        ResultSet res = metaData.getTables(null, this.dbSchema, this.convertObjectName(tableName), new String[]{"TABLE"});
        if (res != null) {
            try {
                if (res.next()) {
                    boolean bl = result = res.getString("TABLE_NAME") != null && res.getString("TABLE_NAME").equalsIgnoreCase(tableName);
                }
                if (res.next()) {
                    throw new IllegalStateException(String.format("Request for table [%s] existing returned more than one results", tableName));
                }
            }
            finally {
                res.close();
            }
        }
        return result;
    }

    @Override
    public DBAccessor.DbType getDbType() {
        return this.dbType;
    }

    @Override
    public String getDbSchema() {
        return this.dbSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableHasData(String tableName) throws SQLException {
        String query = "SELECT count(*) from " + tableName;
        Statement statement = this.getConnection().createStatement();
        boolean retVal = false;
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query);
            if (rs != null && rs.next()) {
                boolean bl = rs.getInt(1) > 0;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to check if table " + tableName + " has any data. Exception: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableHasColumn(String tableName, String columnName) throws SQLException {
        boolean result = false;
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        ResultSet rs = metaData.getColumns(null, this.dbSchema, this.convertObjectName(tableName), this.convertObjectName(columnName));
        if (rs != null) {
            try {
                if (rs.next()) {
                    boolean bl = result = rs.getString("COLUMN_NAME") != null && rs.getString("COLUMN_NAME").equalsIgnoreCase(columnName);
                }
                if (rs.next()) {
                    throw new IllegalStateException(String.format("Request for column [%s] existing in table [%s] returned more than one results", columnName, tableName));
                }
            }
            finally {
                rs.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableHasColumn(String tableName, String ... columnName) throws SQLException {
        ArrayList<String> columnsList = new ArrayList<String>(Arrays.asList(columnName));
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        CustomStringUtils.toUpperCase(columnsList);
        HashSet<String> columnsListToCheckCopies = new HashSet<String>(columnsList);
        ArrayList<String> duplicatedColumns = new ArrayList<String>();
        ResultSet rs = metaData.getColumns(null, this.dbSchema, this.convertObjectName(tableName), null);
        if (rs != null) {
            try {
                while (rs.next()) {
                    boolean removingResult;
                    String actualColumnName = rs.getString("COLUMN_NAME");
                    if (actualColumnName == null || (removingResult = columnsList.remove(actualColumnName.toUpperCase())) || !columnsListToCheckCopies.contains(actualColumnName.toUpperCase())) continue;
                    duplicatedColumns.add(actualColumnName.toUpperCase());
                }
            }
            finally {
                rs.close();
            }
        }
        if (!duplicatedColumns.isEmpty()) {
            throw new IllegalStateException(String.format("Request for columns [%s] existing in table [%s] returned too many results [%s] for columns [%s]", Arrays.toString(columnName), tableName, duplicatedColumns.size(), ((Object)duplicatedColumns).toString()));
        }
        return columnsList.size() == 0;
    }

    @Override
    public boolean tableHasForeignKey(String tableName, String fkName) throws SQLException {
        return this.getCheckedForeignKey(tableName, fkName) != null;
    }

    public String getCheckedForeignKey(String rawTableName, String rawForeignKeyName) throws SQLException {
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        String tableName = this.convertObjectName(rawTableName);
        String foreignKeyName = this.convertObjectName(rawForeignKeyName);
        try (ResultSet rs = metaData.getImportedKeys(null, this.dbSchema, tableName);){
            while (rs.next()) {
                String foundName = rs.getString("FK_NAME");
                if (!StringUtils.equals((String)foreignKeyName, (String)foundName)) continue;
                String string = foundName;
                return string;
            }
        }
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        if (databaseType == Configuration.DatabaseType.ORACLE) {
            try (PreparedStatement ps = this.getConnection().prepareStatement("SELECT constraint_name FROM user_constraints WHERE table_name = ? AND constraint_type = 'R' AND constraint_name = ?");){
                ps.setString(1, tableName);
                ps.setString(2, foreignKeyName);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        String string = foreignKeyName;
                        return string;
                    }
                }
            }
        }
        LOG.warn("FK {} not found for table {}", (Object)foreignKeyName, (Object)tableName);
        return null;
    }

    @Override
    public boolean tableHasForeignKey(String tableName, String refTableName, String columnName, String refColumnName) throws SQLException {
        return this.tableHasForeignKey(tableName, refTableName, new String[]{columnName}, new String[]{refColumnName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableHasForeignKey(String tableName, String referenceTableName, String[] keyColumns, String[] referenceColumns) throws SQLException {
        DatabaseMetaData metaData = this.getDatabaseMetaData();
        ResultSet rs = metaData.getCrossReference(null, this.dbSchema, this.convertObjectName(referenceTableName), null, this.dbSchema, this.convertObjectName(tableName));
        ArrayList<String> pkColumns = new ArrayList<String>(referenceColumns.length);
        for (String referenceColumn : referenceColumns) {
            pkColumns.add(this.convertObjectName(referenceColumn));
        }
        ArrayList<String> fkColumns = new ArrayList<String>(keyColumns.length);
        for (String keyColumn : keyColumns) {
            fkColumns.add(this.convertObjectName(keyColumn));
        }
        if (rs != null) {
            try {
                while (rs.next()) {
                    String pkColumn = rs.getString("PKCOLUMN_NAME");
                    String fkColumn = rs.getString("FKCOLUMN_NAME");
                    int pkIndex = pkColumns.indexOf(pkColumn);
                    int fkIndex = fkColumns.indexOf(fkColumn);
                    if (pkIndex != -1 && fkIndex != -1) {
                        if (pkIndex != fkIndex) {
                            LOG.warn("Columns for FK constraint should be provided in exact order");
                            continue;
                        }
                        pkColumns.remove(pkIndex);
                        fkColumns.remove(fkIndex);
                        continue;
                    }
                    LOG.debug("pkCol={}, fkCol={} not found in provided column names, skipping", (Object)pkColumn, (Object)fkColumn);
                }
                if (pkColumns.isEmpty() && fkColumns.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                rs.close();
            }
        }
        return false;
    }

    @Override
    public boolean tableHasIndex(String tableName, boolean unique, String indexName) throws SQLException {
        if (this.tableExists(tableName)) {
            List<String> indexList = this.getIndexesList(tableName, false);
            return CustomStringUtils.containsCaseInsensitive(indexName, indexList);
        }
        return false;
    }

    @Override
    public void createIndex(String indexName, String tableName, String ... columnNames) throws SQLException {
        this.createIndex(indexName, tableName, false, columnNames);
    }

    @Override
    public void createIndex(String indexName, String tableName, boolean isUnique, String ... columnNames) throws SQLException {
        if (!this.tableHasIndex(tableName, false, indexName)) {
            String query = this.dbmsHelper.getCreateIndexStatement(indexName, tableName, isUnique, columnNames);
            this.executeQuery(query);
        } else {
            LOG.info("Index {} already exist, skipping creation, table = {}", (Object)indexName, (Object)tableName);
        }
    }

    @Override
    public void addFKConstraint(String tableName, String constraintName, String keyColumn, String referenceTableName, String referenceColumn, boolean ignoreFailure) throws SQLException {
        this.addFKConstraint(tableName, constraintName, new String[]{keyColumn}, referenceTableName, new String[]{referenceColumn}, false, ignoreFailure);
    }

    @Override
    public void addFKConstraint(String tableName, String constraintName, String keyColumn, String referenceTableName, String referenceColumn, boolean shouldCascadeOnDelete, boolean ignoreFailure) throws SQLException {
        this.addFKConstraint(tableName, constraintName, new String[]{keyColumn}, referenceTableName, new String[]{referenceColumn}, shouldCascadeOnDelete, ignoreFailure);
    }

    @Override
    public void addFKConstraint(String tableName, String constraintName, String[] keyColumns, String referenceTableName, String[] referenceColumns, boolean ignoreFailure) throws SQLException {
        this.addFKConstraint(tableName, constraintName, keyColumns, referenceTableName, referenceColumns, false, ignoreFailure);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addFKConstraint(String tableName, String constraintName, String[] keyColumns, String referenceTableName, String[] referenceColumns, boolean shouldCascadeOnDelete, boolean ignoreFailure) throws SQLException {
        if (!this.tableHasForeignKey(tableName, referenceTableName, keyColumns, referenceColumns)) {
            String query = this.dbmsHelper.getAddForeignKeyStatement(tableName, constraintName, Arrays.asList(keyColumns), referenceTableName, Arrays.asList(referenceColumns), shouldCascadeOnDelete);
            try {
                this.executeQuery(query, ignoreFailure);
                return;
            }
            catch (SQLException e) {
                LOG.warn("Add FK constraint failed, constraintName = " + constraintName + ", tableName = " + tableName, (Object)e.getMessage());
                if (ignoreFailure) return;
                throw e;
            }
        } else {
            LOG.info("Foreign Key constraint {} already exists, skipping", (Object)constraintName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableHasConstraint(String tableName, String constraintName) throws SQLException {
        String query = this.dbmsHelper.getTableConstraintsStatement(this.connection.getCatalog(), tableName);
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.getConnection().createStatement();
            rs = statement.executeQuery(query);
            if (rs != null) {
                while (rs.next()) {
                    if (!rs.getString("CONSTRAINT_NAME").equalsIgnoreCase(constraintName)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return false;
    }

    @Override
    public void addUniqueConstraint(String tableName, String constraintName, String ... columnNames) throws SQLException {
        if (!this.tableHasConstraint(tableName, constraintName) && this.tableHasColumn(tableName, columnNames)) {
            String query = this.dbmsHelper.getAddUniqueConstraintStatement(tableName, constraintName, columnNames);
            try {
                this.executeQuery(query);
            }
            catch (SQLException e) {
                LOG.warn("Add unique constraint failed, constraintName={},tableName={}", (Object)constraintName, (Object)tableName);
                throw e;
            }
        } else {
            LOG.info("Unique constraint {} already exists or columns {} not found, skipping", (Object)constraintName, (Object)StringUtils.join((Object[])columnNames, (String)", "));
        }
    }

    @Override
    public void updateUniqueConstraint(String tableName, String constraintName, String ... columnNames) throws SQLException {
        this.dropUniqueConstraint(tableName, constraintName);
        this.addUniqueConstraint(tableName, constraintName, columnNames);
    }

    @Override
    public void addPKConstraint(String tableName, String constraintName, boolean ignoreErrors, String ... columnName) throws SQLException {
        if (!this.tableHasPrimaryKey(tableName, null) && this.tableHasColumn(tableName, columnName)) {
            String query = this.dbmsHelper.getAddPrimaryKeyConstraintStatement(tableName, constraintName, columnName);
            this.executeQuery(query, ignoreErrors);
        } else {
            LOG.warn("Primary constraint {} not altered to table {} as column {} not present or constraint already exists", new Object[]{constraintName, tableName, columnName});
        }
    }

    @Override
    public void addPKConstraint(String tableName, String constraintName, String ... columnName) throws SQLException {
        this.addPKConstraint(tableName, constraintName, false, columnName);
    }

    @Override
    public void renameColumn(String tableName, String oldColumnName, DBAccessor.DBColumnInfo columnInfo) throws SQLException {
        String renameColumnStatement = this.dbmsHelper.getRenameColumnStatement(tableName, oldColumnName, columnInfo);
        this.executeQuery(renameColumnStatement);
    }

    @Override
    public void addColumn(String tableName, DBAccessor.DBColumnInfo columnInfo) throws SQLException {
        if (this.tableHasColumn(tableName, columnInfo.getName())) {
            return;
        }
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        switch (databaseType) {
            case ORACLE: {
                boolean originalNullable = columnInfo.isNullable();
                if (columnInfo.getDefaultValue() != null) {
                    columnInfo.setNullable(true);
                }
                String query = this.dbmsHelper.getAddColumnStatement(tableName, columnInfo);
                this.executeQuery(query);
                if (columnInfo.getDefaultValue() == null) break;
                this.updateTable(tableName, columnInfo.getName(), columnInfo.getDefaultValue(), "");
                if (!originalNullable) {
                    this.setColumnNullable(tableName, columnInfo, originalNullable);
                }
                this.addDefaultConstraint(tableName, columnInfo);
                break;
            }
            default: {
                String query = this.dbmsHelper.getAddColumnStatement(tableName, columnInfo);
                this.executeQuery(query);
                break;
            }
        }
    }

    @Override
    public void alterColumn(String tableName, DBAccessor.DBColumnInfo columnInfo) throws SQLException {
        if (this.dbmsHelper.supportsColumnTypeChange()) {
            String statement = this.dbmsHelper.getAlterColumnStatement(tableName, columnInfo);
            this.executeQuery(statement);
        } else {
            DBAccessor.DBColumnInfo columnInfoTmp = new DBAccessor.DBColumnInfo(columnInfo.getName() + "_TMP", columnInfo.getType(), columnInfo.getLength());
            String statement = this.dbmsHelper.getAddColumnStatement(tableName, columnInfoTmp);
            this.executeQuery(statement);
            this.updateTable(tableName, columnInfo, columnInfoTmp);
            this.dropColumn(tableName, columnInfo.getName());
            this.renameColumn(tableName, columnInfoTmp.getName(), columnInfo);
        }
        if (this.isColumnNullable(tableName, columnInfo.getName()) != columnInfo.isNullable()) {
            this.setColumnNullable(tableName, columnInfo, columnInfo.isNullable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTable(String tableName, DBAccessor.DBColumnInfo columnNameFrom, DBAccessor.DBColumnInfo columnNameTo) throws SQLException {
        LOG.info("Executing query: UPDATE TABLE " + tableName + " SET " + columnNameTo.getName() + "=" + columnNameFrom.getName());
        String statement = "SELECT * FROM " + tableName;
        int typeFrom = this.getColumnType(tableName, columnNameFrom.getName());
        int typeTo = this.getColumnType(tableName, columnNameTo.getName());
        Statement dbStatement = null;
        ResultSet rs = null;
        try {
            dbStatement = this.getConnection().createStatement(1005, 1008);
            rs = dbStatement.executeQuery(statement);
            while (rs.next()) {
                this.convertUpdateData(rs, columnNameFrom, typeFrom, columnNameTo, typeTo);
                rs.updateRow();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (dbStatement != null) {
                dbStatement.close();
            }
        }
    }

    private void convertUpdateData(ResultSet rs, DBAccessor.DBColumnInfo columnNameFrom, int typeFrom, DBAccessor.DBColumnInfo columnNameTo, int typeTo) throws SQLException {
        if (typeFrom == 2004 && typeTo == 2005) {
            Blob data = rs.getBlob(columnNameFrom.getName());
            if (data != null) {
                rs.updateClob(columnNameTo.getName(), (Reader)new BufferedReader(new InputStreamReader(data.getBinaryStream(), Charset.defaultCharset())));
            }
        } else {
            Object data = rs.getObject(columnNameFrom.getName());
            rs.updateObject(columnNameTo.getName(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insertRow(String tableName, String[] columnNames, String[] values, boolean ignoreFailure) throws SQLException {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(tableName).append("(");
        if (columnNames.length != values.length) {
            throw new IllegalArgumentException("number of columns should be equal to number of values");
        }
        for (i = 0; i < columnNames.length; ++i) {
            builder.append(columnNames[i]);
            if (i == columnNames.length - 1) continue;
            builder.append(",");
        }
        builder.append(") VALUES(");
        for (i = 0; i < values.length; ++i) {
            builder.append(values[i]);
            if (i == values.length - 1) continue;
            builder.append(",");
        }
        builder.append(")");
        Statement statement = this.getConnection().createStatement();
        int rowsUpdated = 0;
        String query = builder.toString();
        try {
            rowsUpdated = statement.executeUpdate(query);
        }
        catch (SQLException e) {
            LOG.warn("Unable to execute query: " + query, (Throwable)e);
            if (!ignoreFailure) {
                throw e;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return rowsUpdated != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insertRowIfMissing(String tableName, String[] columnNames, String[] values, boolean ignoreFailure) throws SQLException {
        if (columnNames.length == 0) {
            return false;
        }
        if (columnNames.length != values.length) {
            throw new IllegalArgumentException("number of columns should be equal to number of values");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT COUNT(*) FROM ").append(tableName);
        builder.append(" WHERE ").append(columnNames[0]).append("=").append(values[0]);
        for (int i = 1; i < columnNames.length; ++i) {
            builder.append(" AND ").append(columnNames[i]).append("=").append(values[i]);
        }
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = null;
        int count = -1;
        String query = builder.toString();
        try {
            resultSet = statement.executeQuery(query);
            if (resultSet != null && resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            LOG.warn("Unable to execute query: " + query, (Throwable)e);
            if (!ignoreFailure) {
                throw e;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return count == 0 && this.insertRow(tableName, columnNames, values, ignoreFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTable(String tableName, String columnName, Object value, String whereClause) throws SQLException {
        StringBuilder query = new StringBuilder(String.format("UPDATE %s SET %s = ", tableName, columnName));
        query.append(this.escapeParameter(value));
        query.append(" ");
        query.append(whereClause);
        int res = -1;
        try (Statement statement = this.getConnection().createStatement();){
            res = statement.executeUpdate(query.toString());
        }
        return res;
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        return this.executeUpdate(query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String query, boolean ignoreErrors) throws SQLException {
        try (Statement statement = this.getConnection().createStatement();){
            int n = statement.executeUpdate(query);
            return n;
        }
        return 0;
    }

    @Override
    public void executeQuery(String query, String tableName, String hasColumnName) throws SQLException {
        if (this.tableHasColumn(tableName, hasColumnName)) {
            this.executeQuery(query);
        }
    }

    @Override
    public void executeQuery(String query) throws SQLException {
        this.executeQuery(query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(String query, boolean ignoreFailure) throws SQLException {
        LOG.info("Executing query: {}", (Object)query);
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute(query);
        }
    }

    @Override
    public void executePreparedQuery(String query, Object ... arguments) throws SQLException {
        this.executePreparedQuery(query, false, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executePreparedQuery(String query, boolean ignoreFailure, Object ... arguments) throws SQLException {
        LOG.info("Executing prepared query: {}", (Object)query);
        this.setArgumentsForPreparedStatement(preparedStatement, arguments);
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(query);){
            preparedStatement.execute();
        }
    }

    @Override
    public void executePreparedUpdate(String query, Object ... arguments) throws SQLException {
        this.executePreparedUpdate(query, false, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executePreparedUpdate(String query, boolean ignoreFailure, Object ... arguments) throws SQLException {
        LOG.info("Executing prepared query: {}", (Object)query);
        this.setArgumentsForPreparedStatement(preparedStatement, arguments);
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(query);){
            preparedStatement.executeUpdate();
        }
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        if (this.tableExists(tableName)) {
            String query = this.dbmsHelper.getDropTableStatement(tableName);
            this.executeQuery(query);
        } else {
            LOG.warn("{} table doesn't exists, skipping", (Object)tableName);
        }
    }

    @Override
    public void truncateTable(String tableName) throws SQLException {
        String query = "DELETE FROM " + tableName;
        this.executeQuery(query);
    }

    @Override
    public void dropColumn(String tableName, String columnName) throws SQLException {
        if (this.tableHasColumn(tableName, columnName)) {
            String query = this.dbmsHelper.getDropTableColumnStatement(tableName, columnName);
            this.executeQuery(query);
        }
    }

    @Override
    public void dropSequence(String sequenceName) throws SQLException {
        this.executeQuery(this.dbmsHelper.getDropSequenceStatement(sequenceName), true);
    }

    @Override
    public void dropFKConstraint(String tableName, String constraintName) throws SQLException {
        this.dropFKConstraint(tableName, constraintName, false);
    }

    @Override
    public void dropFKConstraint(String tableName, String constraintName, boolean ignoreFailure) throws SQLException {
        String checkedConstraintName = this.getCheckedForeignKey(this.convertObjectName(tableName), constraintName);
        if (checkedConstraintName != null) {
            String query = this.dbmsHelper.getDropFKConstraintStatement(tableName, checkedConstraintName);
            this.executeQuery(query, ignoreFailure);
        } else {
            LOG.warn("Foreign key {} from {} table does not exist and will not be dropped", (Object)constraintName, (Object)tableName);
        }
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        if (databaseType == Configuration.DatabaseType.MYSQL && this.tableHasIndex(tableName, false, constraintName)) {
            String query = this.dbmsHelper.getDropIndexStatement(constraintName, tableName);
            this.executeQuery(query, true);
        }
    }

    @Override
    public void dropUniqueConstraint(String tableName, String constraintName, boolean ignoreFailure) throws SQLException {
        if (this.tableHasConstraint(this.convertObjectName(tableName), this.convertObjectName(constraintName))) {
            String query = this.dbmsHelper.getDropUniqueConstraintStatement(tableName, constraintName);
            this.executeQuery(query, ignoreFailure);
        } else {
            LOG.warn("Unique constraint {} from {} table not found, nothing to drop", (Object)constraintName, (Object)tableName);
        }
    }

    @Override
    public void dropUniqueConstraint(String tableName, String constraintName) throws SQLException {
        this.dropUniqueConstraint(tableName, constraintName, false);
    }

    @Override
    public void dropPKConstraint(String tableName, String constraintName, String columnName, boolean cascade) throws SQLException {
        if (this.tableHasPrimaryKey(tableName, columnName)) {
            String query = this.dbmsHelper.getDropPrimaryKeyStatement(this.convertObjectName(tableName), constraintName, cascade);
            this.executeQuery(query, false);
        } else {
            LOG.warn("Primary key doesn't exists for {} table, skipping", (Object)tableName);
        }
    }

    @Override
    public void dropPKConstraint(String tableName, String constraintName, boolean ignoreFailure, boolean cascade) throws SQLException {
        if (this.tableHasPrimaryKey(tableName, null)) {
            String query = this.dbmsHelper.getDropPrimaryKeyStatement(this.convertObjectName(tableName), constraintName, cascade);
            this.executeQuery(query, ignoreFailure);
        } else {
            LOG.warn("Primary key doesn't exists for {} table, skipping", (Object)tableName);
        }
    }

    @Override
    public void dropPKConstraint(String tableName, String constraintName, boolean cascade) throws SQLException {
        this.dropPKConstraint(tableName, constraintName, false, cascade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeScript(String filePath) throws SQLException, IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            ScriptRunner scriptRunner = new ScriptRunner(this.getConnection(), false, false);
            scriptRunner.runScript(br);
        }
    }

    @Override
    public DatabaseSession getNewDatabaseSession() {
        DatabaseLogin login = new DatabaseLogin();
        login.setUserName(this.configuration.getDatabaseUser());
        login.setPassword(this.configuration.getDatabasePassword());
        login.setDatasourcePlatform((Platform)this.databasePlatform);
        login.setDatabaseURL(this.configuration.getDatabaseUrl());
        login.setDriverClassName(this.configuration.getDatabaseDriver());
        return new DatabaseSessionImpl((Login)login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableHasPrimaryKey(String tableName, String columnName) throws SQLException {
        boolean res;
        block7: {
            res = false;
            try (ResultSet rs = this.getDatabaseMetaData().getPrimaryKeys(null, this.dbSchema, this.convertObjectName(tableName));){
                if (rs != null && columnName != null) {
                    while (rs.next()) {
                        if (!rs.getString("COLUMN_NAME").equalsIgnoreCase(columnName)) continue;
                        res = true;
                        break block7;
                    }
                    break block7;
                }
                if (rs != null) {
                    res = rs.next();
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnType(String tableName, String columnName) throws SQLException {
        int res;
        Statement statement = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            String query = String.format("SELECT %s FROM %s WHERE 1=2", columnName, this.convertObjectName(tableName));
            statement = this.getConnection().createStatement();
            rs = statement.executeQuery(query);
            rsmd = rs.getMetaData();
            res = rsmd.getColumnType(1);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class getColumnClass(String tableName, String columnName) throws SQLException, ClassNotFoundException {
        String query = String.format("SELECT %s FROM %s WHERE 1=2", this.convertObjectName(columnName), this.convertObjectName(tableName));
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.getConnection().createStatement();
            rs = statement.executeQuery(query);
            Class<?> clazz = Class.forName(rs.getMetaData().getColumnClassName(1));
            return clazz;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isColumnNullable(String tableName, String columnName) throws SQLException {
        String query = String.format("SELECT %s FROM %s WHERE 1=2", this.convertObjectName(columnName), this.convertObjectName(tableName));
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.getConnection().createStatement();
            rs = statement.executeQuery(query);
            boolean bl = rs.getMetaData().isNullable(1) != 0;
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Override
    public void setColumnNullable(String tableName, DBAccessor.DBColumnInfo columnInfo, boolean nullable) throws SQLException {
        String columnName = columnInfo.getName();
        if (this.isColumnNullable(tableName, columnName) != nullable) {
            String query = this.dbmsHelper.getSetNullableStatement(tableName, columnInfo, nullable);
            this.executeQuery(query);
        } else {
            LOG.info("Column nullability property is not changed due to {} column from {} table is already in {} state, skipping", new Object[]{columnName, tableName, nullable ? "nullable" : "not nullable"});
        }
    }

    @Override
    public void setColumnNullable(String tableName, String columnName, boolean nullable) throws SQLException {
        try {
            Class columnClass = this.getColumnClass(tableName, columnName);
            this.setColumnNullable(tableName, new DBAccessor.DBColumnInfo(columnName, columnClass), nullable);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not modify table=[], column={}, error={}", new Object[]{tableName, columnName, e.getMessage()});
        }
    }

    @Override
    public void changeColumnType(String tableName, String columnName, Class fromType, Class toType) throws SQLException {
        String tempColumnName = columnName + "_temp";
        switch (this.configuration.getDatabaseType()) {
            case ORACLE: {
                if ((!String.class.equals((Object)fromType) || !toType.equals(Character[].class)) && !toType.equals(char[].class)) break;
                this.addColumn(tableName, new DBAccessor.DBColumnInfo(tempColumnName, toType));
                this.executeUpdate(String.format("UPDATE %s SET %s = %s", this.convertObjectName(tableName), this.convertObjectName(tempColumnName), this.convertObjectName(columnName)));
                this.dropColumn(tableName, columnName);
                this.renameColumn(tableName, tempColumnName, new DBAccessor.DBColumnInfo(columnName, toType));
                return;
            }
        }
        this.alterColumn(tableName, new DBAccessor.DBColumnInfo(columnName, toType, null));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public DBAccessor.DBColumnInfo getColumnInfo(String tableName, String columnName) {
        try {
            String sqlQuery = String.format("SELECT %s FROM %s WHERE 1=2", columnName, this.convertObjectName(tableName));
            try (Statement statement = this.getConnection().createStatement();){
                DBAccessor.DBColumnInfo dBColumnInfo;
                block14: {
                    ResultSet rs = statement.executeQuery(sqlQuery);
                    try {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        dBColumnInfo = new DBAccessor.DBColumnInfo(rsmd.getColumnName(1), DBAccessorImpl.fromSqlTypeToClass(rsmd.getColumnType(1)), (Integer)rsmd.getColumnDisplaySize(1), null, rsmd.isNullable(1) == 1);
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return dBColumnInfo;
            }
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getIndexesList(String tableName, boolean unique) throws SQLException {
        ResultSet rs = this.getDatabaseMetaData().getIndexInfo(null, this.dbSchema, this.convertObjectName(tableName), unique, false);
        ArrayList<String> indexList = new ArrayList<String>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    String indexName = rs.getString(this.convertObjectName("index_name"));
                    if (indexName == null) continue;
                    indexList.add(indexName);
                }
            }
            finally {
                rs.close();
            }
        }
        return indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPrimaryKeyConstraintName(String tableName) throws SQLException {
        String primaryKeyConstraintName = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        switch (databaseType) {
            case ORACLE: {
                String lookupPrimaryKeyNameSql = String.format("SELECT constraint_name FROM all_constraints WHERE UPPER(table_name) = UPPER('%s') AND constraint_type = 'P'", tableName);
                try {
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(lookupPrimaryKeyNameSql);
                    if (resultSet.next()) {
                        primaryKeyConstraintName = resultSet.getString("constraint_name");
                    }
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    JdbcUtils.closeStatement((Statement)statement);
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                return primaryKeyConstraintName;
            }
            case SQL_SERVER: {
                String lookupPrimaryKeyNameSql = String.format("SELECT constraint_name FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE OBJECTPROPERTY(OBJECT_ID(constraint_name), 'IsPrimaryKey') = 1 AND table_name = '%s'", tableName);
                try {
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(lookupPrimaryKeyNameSql);
                    if (resultSet.next()) {
                        primaryKeyConstraintName = resultSet.getString("constraint_name");
                    }
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    JdbcUtils.closeStatement((Statement)statement);
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                return primaryKeyConstraintName;
            }
            case MYSQL: 
            case POSTGRES: {
                String lookupPrimaryKeyNameSql = String.format("SELECT constraint_name FROM information_schema.table_constraints AS tc WHERE tc.constraint_type = 'PRIMARY KEY' AND table_name = '%s'", tableName);
                try {
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(lookupPrimaryKeyNameSql);
                    if (resultSet.next()) {
                        primaryKeyConstraintName = resultSet.getString("constraint_name");
                    }
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    JdbcUtils.closeStatement((Statement)statement);
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                return primaryKeyConstraintName;
            }
        }
        return primaryKeyConstraintName;
    }

    @Override
    public void dropPKConstraint(String tableName, String defaultConstraintName) throws SQLException {
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        if (databaseType == Configuration.DatabaseType.MYSQL) {
            String mysqlDropQuery = String.format("ALTER TABLE %s DROP PRIMARY KEY", tableName);
            this.executeQuery(mysqlDropQuery, true);
            return;
        }
        String primaryKeyConstraintName = this.getPrimaryKeyConstraintName(tableName);
        if (null == primaryKeyConstraintName) {
            primaryKeyConstraintName = defaultConstraintName;
            LOG.warn("Unable to dynamically determine the PK constraint name for {}, defaulting to {}", (Object)tableName, (Object)defaultConstraintName);
        }
        if (null == primaryKeyConstraintName) {
            LOG.warn("Unable to determine the primary key constraint name for {}", (Object)tableName);
        } else {
            this.dropPKConstraint(tableName, primaryKeyConstraintName, true);
        }
    }

    @Override
    public void addDefaultConstraint(String tableName, DBAccessor.DBColumnInfo column) throws SQLException {
        String defaultValue = this.escapeParameter(column.getDefaultValue());
        StringBuilder builder = new StringBuilder(String.format("ALTER TABLE %s ", tableName));
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        switch (databaseType) {
            case DERBY: 
            case MYSQL: 
            case POSTGRES: 
            case SQL_ANYWHERE: {
                builder.append(String.format("ALTER %s SET DEFAULT %s", column.getName(), defaultValue));
                break;
            }
            case ORACLE: {
                builder.append(String.format("MODIFY %s DEFAULT %s", column.getName(), defaultValue));
                break;
            }
            case SQL_SERVER: {
                builder.append(String.format("ALTER COLUMN %s SET DEFAULT %s", column.getName(), defaultValue));
                break;
            }
            default: {
                builder.append(String.format("ALTER %s SET DEFAULT %s", column.getName(), defaultValue));
            }
        }
        this.executeQuery(builder.toString());
    }

    private String escapeParameter(Object value) {
        return DBAccessorImpl.escapeParameter(value, this.databasePlatform);
    }

    public static String escapeParameter(Object value, DatabasePlatform databasePlatform) {
        if (value == null) {
            return null;
        }
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        }
        Object valueString = value.toString();
        if (value instanceof String || databasePlatform.convertToDatabaseType(value) instanceof String) {
            valueString = "'" + (String)valueString + "'";
        }
        return valueString;
    }

    @Override
    public void copyColumnToAnotherTable(String sourceTableName, DBAccessor.DBColumnInfo sourceColumn, String sourceIDFieldName1, String sourceIDFieldName2, String sourceIDFieldName3, String targetTableName, DBAccessor.DBColumnInfo targetColumn, String targetIDFieldName1, String targetIDFieldName2, String targetIDFieldName3, String sourceConditionFieldName, String condition, Object initialValue) throws SQLException {
        if (this.tableHasColumn(sourceTableName, sourceIDFieldName1) && this.tableHasColumn(sourceTableName, sourceIDFieldName2) && this.tableHasColumn(sourceTableName, sourceIDFieldName3) && this.tableHasColumn(sourceTableName, sourceColumn.getName()) && this.tableHasColumn(sourceTableName, sourceConditionFieldName) && this.tableHasColumn(targetTableName, targetIDFieldName1) && this.tableHasColumn(targetTableName, targetIDFieldName2) && this.tableHasColumn(targetTableName, targetIDFieldName3)) {
            String moveSQL = this.dbmsHelper.getCopyColumnToAnotherTableStatement(sourceTableName, sourceColumn.getName(), sourceIDFieldName1, sourceIDFieldName2, sourceIDFieldName3, targetTableName, targetColumn.getName(), targetIDFieldName1, targetIDFieldName2, targetIDFieldName3, sourceConditionFieldName, condition);
            boolean isTargetColumnNullable = targetColumn.isNullable();
            targetColumn.setNullable(true);
            this.addColumn(targetTableName, targetColumn);
            this.executeUpdate(moveSQL, false);
            if (initialValue != null) {
                String updateSQL = this.dbmsHelper.getColumnUpdateStatementWhereColumnIsNull(this.convertObjectName(targetTableName), this.convertObjectName(targetColumn.getName()), this.convertObjectName(targetColumn.getName()));
                this.executePreparedUpdate(updateSQL, initialValue);
            }
            if (!isTargetColumnNullable) {
                this.setColumnNullable(targetTableName, targetColumn.getName(), false);
            }
        }
    }

    @Override
    public List<Integer> getIntColumnValues(String tableName, String columnName, String[] conditionColumnNames, String[] values, boolean ignoreFailure) throws SQLException {
        return this.executeQuery(tableName, new String[]{columnName}, conditionColumnNames, values, ignoreFailure, new ResultGetter<List<Integer>>(){
            private List<Integer> results = new ArrayList<Integer>();

            @Override
            public void collect(ResultSet resultSet) throws SQLException {
                this.results.add(resultSet.getInt(1));
            }

            @Override
            public List<Integer> getResult() {
                return this.results;
            }
        });
    }

    @Override
    public Map<Long, String> getKeyToStringColumnMap(String tableName, String keyColumnName, String valueColumnName, String[] conditionColumnNames, String[] values, boolean ignoreFailure) throws SQLException {
        return this.executeQuery(tableName, new String[]{keyColumnName, valueColumnName}, conditionColumnNames, values, ignoreFailure, new ResultGetter<Map<Long, String>>(){
            Map<Long, String> map = new HashMap<Long, String>();

            @Override
            public void collect(ResultSet resultSet) throws SQLException {
                this.map.put(resultSet.getLong(1), resultSet.getString(2));
            }

            @Override
            public Map<Long, String> getResult() {
                return this.map;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T executeQuery(String tableName, String[] requestedColumnNames, String[] conditionColumnNames, String[] conditionValues, boolean ignoreFailure, ResultGetter<T> resultGetter) throws SQLException {
        String query = this.buildQuery(tableName, requestedColumnNames, conditionColumnNames, conditionValues);
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(query);
            if (resultSet != null) {
                while (resultSet.next()) {
                    resultGetter.collect(resultSet);
                }
            }
        }
        catch (SQLException e) {
            LOG.warn("Unable to execute query: " + query, (Throwable)e);
            if (!ignoreFailure) {
                throw e;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return resultGetter.getResult();
    }

    protected String buildQuery(String tableName, String[] requestedColumnNames, String[] conditionColumnNames, String[] conditionValues) throws SQLException {
        if (!this.tableExists(tableName)) {
            throw new IllegalArgumentException(String.format("%s table does not exist", tableName));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (requestedColumnNames == null || requestedColumnNames.length == 0) {
            throw new IllegalArgumentException("no columns for the select have been set");
        }
        for (String name : requestedColumnNames) {
            if (this.tableHasColumn(tableName, name)) continue;
            throw new IllegalArgumentException(String.format("%s table does not contain %s column", tableName, name));
        }
        builder.append(requestedColumnNames[0]);
        for (int i = 1; i < requestedColumnNames.length; ++i) {
            builder.append(", ").append(requestedColumnNames[i]);
        }
        builder.append(" FROM ").append(tableName);
        if (conditionColumnNames != null && conditionColumnNames.length > 0) {
            for (String name : conditionColumnNames) {
                if (this.tableHasColumn(tableName, name)) continue;
                throw new IllegalArgumentException(String.format("%s table does not contain %s column", tableName, name));
            }
            if (conditionColumnNames.length != conditionValues.length) {
                throw new IllegalArgumentException("number of columns should be equal to number of values");
            }
            builder.append(" WHERE ").append(conditionColumnNames[0]).append("='").append(conditionValues[0]).append("'");
            for (int i = 1; i < conditionColumnNames.length; ++i) {
                builder.append(" AND ").append(conditionColumnNames[i]).append("='").append(conditionValues[i]).append("'");
            }
        }
        return builder.toString();
    }

    @Override
    public void moveColumnToAnotherTable(String sourceTableName, DBAccessor.DBColumnInfo sourceColumn, String sourceIDFieldName, String targetTableName, DBAccessor.DBColumnInfo targetColumn, String targetIDFieldName, Object initialValue) throws SQLException {
        if (this.tableHasColumn(sourceTableName, sourceIDFieldName) && this.tableHasColumn(sourceTableName, sourceColumn.getName()) && this.tableHasColumn(targetTableName, targetIDFieldName)) {
            String moveSQL = this.dbmsHelper.getCopyColumnToAnotherTableStatement(sourceTableName, sourceColumn.getName(), sourceIDFieldName, targetTableName, targetColumn.getName(), targetIDFieldName);
            boolean isTargetColumnNullable = targetColumn.isNullable();
            targetColumn.setNullable(true);
            this.addColumn(targetTableName, targetColumn);
            this.executeUpdate(moveSQL, false);
            if (initialValue != null) {
                String updateSQL = this.dbmsHelper.getColumnUpdateStatementWhereColumnIsNull(this.convertObjectName(targetTableName), this.convertObjectName(targetColumn.getName()), this.convertObjectName(targetColumn.getName()));
                this.executePreparedUpdate(updateSQL, initialValue);
            }
            if (!isTargetColumnNullable) {
                this.setColumnNullable(targetTableName, targetColumn.getName(), false);
            }
            this.dropColumn(sourceTableName, sourceColumn.getName());
        }
    }

    @Override
    public void clearTable(String tableName) throws SQLException {
        if (this.tableExists(tableName)) {
            String sqlQuery = "DELETE FROM " + this.convertObjectName(tableName);
            this.executeQuery(sqlQuery);
        } else {
            LOG.warn("{} table doesn't exists, skipping", (Object)tableName);
        }
    }

    @Override
    public void clearTableColumn(String tableName, String columnName, Object value) throws SQLException {
        if (this.tableExists(tableName)) {
            String sqlQuery = String.format("UPDATE %s SET %s = ?", this.convertObjectName(tableName), this.convertObjectName(columnName));
            this.executePreparedUpdate(sqlQuery, value);
        } else {
            LOG.warn("{} table doesn't exists, skipping", (Object)tableName);
        }
    }

    private static interface ResultGetter<T> {
        public void collect(ResultSet var1) throws SQLException;

        public T getResult();
    }
}

