/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.notifications.dispatchers;

import com.google.inject.Singleton;
import id.onyx.obdp.server.notifications.Notification;
import id.onyx.obdp.server.notifications.NotificationDispatcher;
import id.onyx.obdp.server.notifications.Recipient;
import id.onyx.obdp.server.notifications.TargetConfigurationResult;
import id.onyx.obdp.server.state.alert.TargetType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.UdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;

@Singleton
public class SNMPDispatcher
implements NotificationDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SNMPDispatcher.class);
    public static final String BODY_OID_PROPERTY = "ambari.dispatch.snmp.oids.body";
    public static final String SUBJECT_OID_PROPERTY = "ambari.dispatch.snmp.oids.subject";
    public static final String TRAP_OID_PROPERTY = "ambari.dispatch.snmp.oids.trap";
    public static final String PORT_PROPERTY = "ambari.dispatch.snmp.port";
    public static final String SNMP_VERSION_PROPERTY = "ambari.dispatch.snmp.version";
    public static final String COMMUNITY_PROPERTY = "ambari.dispatch.snmp.community";
    public static final String SECURITY_USERNAME_PROPERTY = "ambari.dispatch.snmp.security.username";
    public static final String SECURITY_AUTH_PASSPHRASE_PROPERTY = "ambari.dispatch.snmp.security.auth.passphrase";
    public static final String SECURITY_PRIV_PASSPHRASE_PROPERTY = "ambari.dispatch.snmp.security.priv.passphrase";
    public static final String SECURITY_LEVEL_PROPERTY = "ambari.dispatch.snmp.security.level";
    private Snmp snmp;
    private final Integer port;
    private volatile UdpTransportMapping transportMapping;

    public SNMPDispatcher(Snmp snmp) {
        this.port = null;
        this.snmp = snmp;
    }

    public SNMPDispatcher() throws IOException {
        this((Integer)null);
    }

    public SNMPDispatcher(Integer port) throws IOException {
        this.port = port != null && port >= 0 && port <= 65535 ? port : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTransportMapping() throws IOException {
        if (this.transportMapping == null) {
            SNMPDispatcher sNMPDispatcher = this;
            synchronized (sNMPDispatcher) {
                if (this.transportMapping == null) {
                    if (this.port != null) {
                        LOG.info("Setting SNMP dispatch port: " + this.port);
                        this.transportMapping = new DefaultUdpTransportMapping(new UdpAddress(this.port.intValue()), true);
                    } else {
                        this.transportMapping = new DefaultUdpTransportMapping();
                    }
                }
            }
        }
    }

    @Override
    public String getType() {
        return TargetType.SNMP.name();
    }

    @Override
    public boolean isNotificationContentGenerationRequired() {
        return true;
    }

    @Override
    public void dispatch(Notification notification) {
        LOG.info("Sending SNMP trap: {}", (Object)notification.Subject);
        try {
            this.createTransportMapping();
            this.snmp = new Snmp((TransportMapping)this.transportMapping);
            SnmpVersion snmpVersion = this.getSnmpVersion(notification.DispatchProperties);
            this.sendTraps(notification, snmpVersion);
            this.successCallback(notification);
        }
        catch (InvalidSnmpConfigurationException ex) {
            LOG.error("Unable to dispatch SNMP trap with invalid configuration. " + ex.getMessage());
            this.failureCallback(notification);
        }
        catch (Exception ex) {
            LOG.error("Error occurred during SNMP trap dispatching.", (Throwable)ex);
            this.failureCallback(notification);
            this.transportMapping = null;
        }
    }

    @Override
    public TargetConfigurationResult validateTargetConfig(Map<String, Object> properties) {
        HashMap<String, String> stringValuesConfig = new HashMap<String, String>(properties.size());
        for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
            stringValuesConfig.put(propertyEntry.getKey(), propertyEntry.getValue().toString());
        }
        try {
            for (String property : this.getSetOfDefaultNeededPropertyNames()) {
                SNMPDispatcher.getDispatchProperty(stringValuesConfig, property);
            }
            SnmpVersion snmpVersion = this.getSnmpVersion(stringValuesConfig);
            block1 : switch (snmpVersion) {
                case SNMPv3: {
                    SNMPDispatcher.getDispatchProperty(stringValuesConfig, SECURITY_USERNAME_PROPERTY);
                    TrapSecurity securityLevel = this.getSecurityLevel(stringValuesConfig);
                    switch (securityLevel) {
                        case AUTH_PRIV: {
                            SNMPDispatcher.getDispatchProperty(stringValuesConfig, SECURITY_PRIV_PASSPHRASE_PROPERTY);
                            SNMPDispatcher.getDispatchProperty(stringValuesConfig, SECURITY_AUTH_PASSPHRASE_PROPERTY);
                            break block1;
                        }
                        case AUTH_NOPRIV: {
                            SNMPDispatcher.getDispatchProperty(stringValuesConfig, SECURITY_AUTH_PASSPHRASE_PROPERTY);
                        }
                    }
                    break;
                }
                case SNMPv2c: 
                case SNMPv1: {
                    SNMPDispatcher.getDispatchProperty(stringValuesConfig, COMMUNITY_PROPERTY);
                }
            }
        }
        catch (InvalidSnmpConfigurationException ex) {
            return TargetConfigurationResult.invalid(ex.getMessage());
        }
        return TargetConfigurationResult.valid();
    }

    protected Set<String> getSetOfDefaultNeededPropertyNames() {
        return new HashSet<String>(Arrays.asList(BODY_OID_PROPERTY, SUBJECT_OID_PROPERTY, TRAP_OID_PROPERTY, PORT_PROPERTY));
    }

    protected PDU prepareTrap(Notification notification, SnmpVersion snmpVersion) throws InvalidSnmpConfigurationException {
        PDU pdu = DefaultPDUFactory.createPDU((int)snmpVersion.getTargetVersion());
        pdu.setType(snmpVersion.getTrapType());
        pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(SNMPDispatcher.getDispatchProperty(notification.DispatchProperties, TRAP_OID_PROPERTY))));
        pdu.add(new VariableBinding(new OID(SNMPDispatcher.getDispatchProperty(notification.DispatchProperties, BODY_OID_PROPERTY)), (Variable)new OctetString(notification.Body)));
        pdu.add(new VariableBinding(new OID(SNMPDispatcher.getDispatchProperty(notification.DispatchProperties, SUBJECT_OID_PROPERTY)), (Variable)new OctetString(notification.Subject)));
        return pdu;
    }

    protected void sendTraps(Notification notification, SnmpVersion snmpVersion) throws InvalidSnmpConfigurationException, IOException {
        PDU trap = this.prepareTrap(notification, snmpVersion);
        String udpPort = SNMPDispatcher.getDispatchProperty(notification.DispatchProperties, PORT_PROPERTY);
        for (Recipient recipient : this.getNotificationRecipients(notification)) {
            String address = recipient.Identifier;
            Target target = this.createTrapTarget(notification, snmpVersion);
            target.setAddress((Address)new UdpAddress(address + "/" + udpPort));
            this.snmp.send(trap, target);
        }
    }

    protected Target createTrapTarget(Notification notification, SnmpVersion snmpVersion) throws InvalidSnmpConfigurationException {
        if (snmpVersion.isCommunityTargetRequired()) {
            OctetString community = new OctetString(SNMPDispatcher.getDispatchProperty(notification.DispatchProperties, COMMUNITY_PROPERTY));
            CommunityTarget communityTarget = new CommunityTarget();
            communityTarget.setCommunity(community);
            communityTarget.setVersion(snmpVersion.getTargetVersion());
            return communityTarget;
        }
        OctetString userName = new OctetString(SNMPDispatcher.getDispatchProperty(notification.DispatchProperties, SECURITY_USERNAME_PROPERTY));
        if (this.snmp.getUSM() == null) {
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            String authPassphraseProperty = notification.DispatchProperties.get(SECURITY_AUTH_PASSPHRASE_PROPERTY);
            String privPassphraseProperty = notification.DispatchProperties.get(SECURITY_PRIV_PASSPHRASE_PROPERTY);
            OctetString authPassphrase = authPassphraseProperty != null ? new OctetString(authPassphraseProperty) : null;
            OctetString privPassphrase = privPassphraseProperty != null ? new OctetString(privPassphraseProperty) : null;
            UsmUser usmUser = new UsmUser(userName, AuthMD5.ID, authPassphrase, PrivDES.ID, privPassphrase);
            usm.addUser(userName, usmUser);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        }
        UserTarget userTarget = new UserTarget();
        userTarget.setSecurityName(userName);
        userTarget.setSecurityLevel(this.getSecurityLevel(notification.DispatchProperties).getSecurityLevel());
        userTarget.setSecurityModel(3);
        userTarget.setVersion(snmpVersion.getTargetVersion());
        return userTarget;
    }

    @Override
    public boolean isDigestSupported() {
        return false;
    }

    private List<Recipient> getNotificationRecipients(Notification notification) throws InvalidSnmpConfigurationException {
        if (notification.Recipients == null || notification.Recipients.isEmpty()) {
            throw new InvalidSnmpConfigurationException("Destination addresses should be set.");
        }
        return notification.Recipients;
    }

    protected static String getDispatchProperty(Map<String, String> dispatchProperties, String key) throws InvalidSnmpConfigurationException {
        if (dispatchProperties == null || !dispatchProperties.containsKey(key)) {
            throw new InvalidSnmpConfigurationException(String.format("Property \"%s\" should be set.", key));
        }
        return dispatchProperties.get(key);
    }

    protected SnmpVersion getSnmpVersion(Map<String, String> dispatchProperties) throws InvalidSnmpConfigurationException {
        String snmpVersion = SNMPDispatcher.getDispatchProperty(dispatchProperties, SNMP_VERSION_PROPERTY);
        try {
            return SnmpVersion.valueOf(snmpVersion);
        }
        catch (IllegalArgumentException ex) {
            String errorMessage = String.format("Incorrect SNMP version - \"%s\". Possible values for \"%s\": %s", snmpVersion, SNMP_VERSION_PROPERTY, Arrays.toString((Object[])SnmpVersion.values()));
            throw new InvalidSnmpConfigurationException(errorMessage);
        }
    }

    protected TrapSecurity getSecurityLevel(Map<String, String> dispatchProperties) throws InvalidSnmpConfigurationException {
        String securityLevel = SNMPDispatcher.getDispatchProperty(dispatchProperties, SECURITY_LEVEL_PROPERTY);
        try {
            return TrapSecurity.valueOf(securityLevel);
        }
        catch (IllegalArgumentException ex) {
            String errorMessage = String.format("Incorrect security level for trap - \"%s\". Possible values for \"%s\": %s", securityLevel, SECURITY_LEVEL_PROPERTY, Arrays.toString((Object[])TrapSecurity.values()));
            throw new InvalidSnmpConfigurationException(errorMessage);
        }
    }

    private void failureCallback(Notification notification) {
        if (notification.Callback != null) {
            notification.Callback.onFailure(notification.CallbackIds);
        }
    }

    private void successCallback(Notification notification) {
        if (notification.Callback != null) {
            notification.Callback.onSuccess(notification.CallbackIds);
        }
    }

    public Integer getPort() {
        return this.port;
    }

    protected UdpTransportMapping getTransportMapping() {
        return this.transportMapping;
    }

    protected static enum SnmpVersion {
        SNMPv1(-92, 0, true),
        SNMPv2c(-89, 1, true),
        SNMPv3(-89, 3, false);

        private int trapType;
        private int targetVersion;
        private boolean communityTargetRequired;

        private SnmpVersion(int trapType, int targetVersion, boolean communityTargetRequired) {
            this.trapType = trapType;
            this.targetVersion = targetVersion;
            this.communityTargetRequired = communityTargetRequired;
        }

        public int getTrapType() {
            return this.trapType;
        }

        public int getTargetVersion() {
            return this.targetVersion;
        }

        public boolean isCommunityTargetRequired() {
            return this.communityTargetRequired;
        }
    }

    protected static class InvalidSnmpConfigurationException
    extends Exception {
        public InvalidSnmpConfigurationException(String message) {
            super(message);
        }
    }

    protected static enum TrapSecurity {
        NOAUTH_NOPRIV(1),
        AUTH_NOPRIV(2),
        AUTH_PRIV(3);

        int securityLevel;

        private TrapSecurity(int securityLevel) {
            this.securityLevel = securityLevel;
        }

        public int getSecurityLevel() {
            return this.securityLevel;
        }
    }
}

