/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.notifications.dispatchers;

import com.google.inject.Singleton;
import id.onyx.obdp.server.notifications.DispatchCredentials;
import id.onyx.obdp.server.notifications.Notification;
import id.onyx.obdp.server.notifications.NotificationDispatcher;
import id.onyx.obdp.server.notifications.Recipient;
import id.onyx.obdp.server.notifications.TargetConfigurationResult;
import id.onyx.obdp.server.state.alert.TargetType;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EmailDispatcher
implements NotificationDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(EmailDispatcher.class);
    public static final String JAVAMAIL_FROM_PROPERTY = "mail.smtp.from";

    @Override
    public String getType() {
        return TargetType.EMAIL.name();
    }

    @Override
    public boolean isNotificationContentGenerationRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Notification notification) {
        LOG.info("Sending email: {}", (Object)notification);
        if (null == notification.DispatchProperties) {
            LOG.error("Unable to dispatch an email notification that does not contain SMTP properties");
            if (null != notification.Callback) {
                notification.Callback.onFailure(notification.CallbackIds);
            }
            return;
        }
        String fromAddress = null;
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : notification.DispatchProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            properties.put(key, value);
            if (!key.equals(JAVAMAIL_FROM_PROPERTY)) continue;
            fromAddress = value;
        }
        if (null == notification.Recipients) {
            LOG.error("Unable to dispatch an email notification that does not have recipients");
            if (null != notification.Callback) {
                notification.Callback.onFailure(notification.CallbackIds);
            }
            return;
        }
        EmailAuthenticator authenticator = null;
        if (null != notification.Credentials) {
            authenticator = new EmailAuthenticator(notification.Credentials);
        }
        Session session = Session.getInstance((Properties)properties, authenticator);
        try {
            MimeMessage message = new MimeMessage(session);
            for (Recipient recipient : notification.Recipients) {
                InternetAddress address = new InternetAddress(recipient.Identifier);
                message.addRecipient(Message.RecipientType.TO, (Address)address);
            }
            message.setSentDate(new Date());
            message.setSubject(notification.Subject);
            message.setText(notification.Body, "UTF-8", "html");
            if (null != fromAddress) {
                message.setFrom(fromAddress);
            }
            Transport.send((Message)message);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully dispatched email to {}", notification.Recipients);
            }
            if (null != notification.Callback) {
                notification.Callback.onSuccess(notification.CallbackIds);
            }
        }
        catch (Exception exception) {
            LOG.error("Unable to dispatch notification via Email", (Throwable)exception);
            if (null != notification.Callback) {
                notification.Callback.onFailure(notification.CallbackIds);
            }
        }
        finally {
            try {
                session.getTransport().close();
            }
            catch (MessagingException me) {
                LOG.warn("Dispatcher unable to close SMTP transport", (Throwable)me);
            }
        }
    }

    @Override
    public boolean isDigestSupported() {
        return true;
    }

    @Override
    public TargetConfigurationResult validateTargetConfig(Map<String, Object> properties) {
        try {
            Transport transport = this.getMailTransport(properties);
            transport.connect();
            transport.close();
        }
        catch (AuthenticationFailedException e) {
            LOG.debug("Invalid credentials. Authentication failure.", (Throwable)e);
            return TargetConfigurationResult.invalid("Invalid credentials. Authentication failure: " + e.getMessage());
        }
        catch (MessagingException e) {
            LOG.debug("Invalid config.", (Throwable)e);
            return TargetConfigurationResult.invalid("Invalid config: " + e.getMessage());
        }
        return TargetConfigurationResult.valid();
    }

    protected Transport getMailTransport(Map<String, Object> properties) throws NoSuchProviderException {
        DispatchCredentials credentials = null;
        if (properties.containsKey("ambari.dispatch.credential.username")) {
            credentials = new DispatchCredentials();
            credentials.UserName = (String)properties.get("ambari.dispatch.credential.username");
            credentials.Password = (String)properties.get("ambari.dispatch.credential.password");
        }
        Properties props = new Properties();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new EmailAuthenticator(credentials));
        return session.getTransport();
    }

    private static final class EmailAuthenticator
    extends Authenticator {
        private final DispatchCredentials m_credentials;

        private EmailAuthenticator(DispatchCredentials credentials) {
            this.m_credentials = credentials;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.m_credentials != null) {
                return new PasswordAuthentication(this.m_credentials.UserName, this.m_credentials.Password);
            }
            return null;
        }
    }
}

