/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.notifications.dispatchers;

import com.google.inject.Singleton;
import id.onyx.obdp.server.notifications.Notification;
import id.onyx.obdp.server.notifications.dispatchers.SNMPDispatcher;
import id.onyx.obdp.server.state.alert.AlertNotification;
import id.onyx.obdp.server.state.alert.TargetType;
import id.onyx.obdp.server.state.services.AlertNoticeDispatchService;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;

@Singleton
public class AmbariSNMPDispatcher
extends SNMPDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariSNMPDispatcher.class);
    public static final String BASE_AMBARI_OID = "1.3.6.1.4.1.18060.16";
    public static final String APACHE_AMBARI_TRAPS_OID = "1.3.6.1.4.1.18060.16.0";
    public static final String AMBARI_ALERT_TRAP_OID = "1.3.6.1.4.1.18060.16.0.1";
    public static final String AMBARI_ALERTS_OID = "1.3.6.1.4.1.18060.16.1";
    public static final String AMBARI_ALERT_TABLE_OID = "1.3.6.1.4.1.18060.16.1.1";
    public static final String AMBARI_ALERT_ENTRY_OID = "1.3.6.1.4.1.18060.16.1.1.1";
    public static final String AMBARI_ALERT_DEFINITION_ID_OID = "1.3.6.1.4.1.18060.16.1.1.1.1";
    public static final String AMBARI_ALERT_DEFINITION_NAME_OID = "1.3.6.1.4.1.18060.16.1.1.1.2";
    public static final String AMBARI_ALERT_DEFINITION_HASH_OID = "1.3.6.1.4.1.18060.16.1.1.1.3";
    public static final String AMBARI_ALERT_NAME_OID = "1.3.6.1.4.1.18060.16.1.1.1.4";
    public static final String AMBARI_ALERT_TEXT_OID = "1.3.6.1.4.1.18060.16.1.1.1.5";
    public static final String AMBARI_ALERT_STATE_OID = "1.3.6.1.4.1.18060.16.1.1.1.6";
    public static final String AMBARI_ALERT_HOST_NAME_OID = "1.3.6.1.4.1.18060.16.1.1.1.7";
    public static final String AMBARI_ALERT_SERVICE_NAME_OID = "1.3.6.1.4.1.18060.16.1.1.1.8";
    public static final String AMBARI_ALERT_COMPONENT_NAME_OID = "1.3.6.1.4.1.18060.16.1.1.1.9";

    protected AmbariSNMPDispatcher(Snmp snmp) {
        super(snmp);
    }

    public AmbariSNMPDispatcher(Integer port) throws IOException {
        super(port);
    }

    @Override
    public String getType() {
        return TargetType.AMBARI_SNMP.name();
    }

    @Override
    protected PDU prepareTrap(Notification notification, SNMPDispatcher.SnmpVersion snmpVersion) throws SNMPDispatcher.InvalidSnmpConfigurationException {
        AlertNotification alertNotification;
        PDU pdu = DefaultPDUFactory.createPDU((int)snmpVersion.getTargetVersion());
        if (Notification.Type.ALERT.equals((Object)notification.getType())) {
            try {
                alertNotification = (AlertNotification)notification;
            }
            catch (ClassCastException e) {
                LOG.error("Notification wasn't casted to AlertNotification. Returning empty Protocol data unit", (Throwable)e);
                return pdu;
            }
        } else {
            LOG.error("Notification for AmbariSNMPDispatcher should be of type AlertNotification, but it wasn't. Returning empty Protocol data unit");
            return pdu;
        }
        pdu.setType(snmpVersion.getTrapType());
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        long uptimeInHundredthsOfSecond = runtimeMXBean.getUptime() / 10L;
        pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(uptimeInHundredthsOfSecond)));
        pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(AMBARI_ALERT_TRAP_OID)));
        AlertNoticeDispatchService.AlertInfo alertInfo = alertNotification.getAlertInfo();
        this.addIntVariableBindingCheckForNull(pdu, AMBARI_ALERT_DEFINITION_ID_OID, new BigDecimal(alertInfo.getAlertDefinitionId()).intValueExact());
        this.addStringVariableBindingCheckForNull(pdu, AMBARI_ALERT_DEFINITION_NAME_OID, alertInfo.getAlertDefinition().getDefinitionName());
        this.addStringVariableBindingCheckForNull(pdu, AMBARI_ALERT_DEFINITION_HASH_OID, alertInfo.getAlertDefinitionHash());
        this.addStringVariableBindingCheckForNull(pdu, AMBARI_ALERT_NAME_OID, alertInfo.getAlertName());
        this.addStringVariableBindingCheckForNull(pdu, AMBARI_ALERT_TEXT_OID, alertInfo.getAlertText());
        this.addIntVariableBindingCheckForNull(pdu, AMBARI_ALERT_STATE_OID, alertInfo.getAlertState().getIntValue());
        this.addStringVariableBindingCheckForNull(pdu, AMBARI_ALERT_HOST_NAME_OID, alertInfo.getHostName());
        this.addStringVariableBindingCheckForNull(pdu, AMBARI_ALERT_SERVICE_NAME_OID, alertInfo.getServiceName());
        this.addStringVariableBindingCheckForNull(pdu, AMBARI_ALERT_COMPONENT_NAME_OID, alertInfo.getComponentName());
        return pdu;
    }

    @Override
    protected Set<String> getSetOfDefaultNeededPropertyNames() {
        return new HashSet<String>(Collections.singletonList("ambari.dispatch.snmp.port"));
    }

    private void addStringVariableBindingCheckForNull(PDU pdu, String oid, Object val) {
        if (val == null) {
            pdu.add(new VariableBinding(new OID(oid), (Variable)new OctetString("null")));
        } else {
            pdu.add(new VariableBinding(new OID(oid), (Variable)new OctetString(String.valueOf(val))));
        }
    }

    private void addIntVariableBindingCheckForNull(PDU pdu, String oid, Integer val) {
        if (val == null) {
            pdu.add(new VariableBinding(new OID(oid), (Variable)new OctetString("null")));
        } else {
            pdu.add(new VariableBinding(new OID(oid), (Variable)new Integer32(val.intValue())));
        }
    }
}

