/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.notifications.dispatchers;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.notifications.Notification;
import id.onyx.obdp.server.notifications.NotificationDispatcher;
import id.onyx.obdp.server.notifications.TargetConfigurationResult;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.alert.AlertNotification;
import id.onyx.obdp.server.state.alert.TargetType;
import id.onyx.obdp.server.state.services.AlertNoticeDispatchService;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertScriptDispatcher
implements NotificationDispatcher {
    public static final String SCRIPT_CONFIG_DEFAULT_KEY = "notification.dispatch.alert.script";
    public static final String SCRIPT_CONFIG_TIMEOUT_KEY = "notification.dispatch.alert.script.timeout";
    public static final String DISPATCH_PROPERTY_SCRIPT_CONFIG_KEY = "ambari.dispatch-property.script";
    public static final String DISPATCH_PROPERTY_SCRIPT_FILENAME_KEY = "ambari.dispatch-property.script.filename";
    private static final Logger LOG = LoggerFactory.getLogger(AlertScriptDispatcher.class);
    private static final long DEFAULT_SCRIPT_TIMEOUT = 5000L;
    public static final Escaper SHELL_ESCAPE;
    @Inject
    protected Configuration m_configuration;
    private final Executor m_executor = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ScriptDispatchThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public String getScriptConfigurationKey(Notification notification) {
        if (null == notification || null == notification.DispatchProperties) {
            return SCRIPT_CONFIG_DEFAULT_KEY;
        }
        if (null == notification.DispatchProperties.get(DISPATCH_PROPERTY_SCRIPT_CONFIG_KEY)) {
            return SCRIPT_CONFIG_DEFAULT_KEY;
        }
        return notification.DispatchProperties.get(DISPATCH_PROPERTY_SCRIPT_CONFIG_KEY);
    }

    public long getScriptConfigurationTimeout() {
        String scriptTimeout = this.m_configuration.getProperty(SCRIPT_CONFIG_TIMEOUT_KEY);
        if (null == scriptTimeout) {
            return 5000L;
        }
        return Long.parseLong(scriptTimeout);
    }

    @Override
    public final String getType() {
        return TargetType.ALERT_SCRIPT.name();
    }

    @Override
    public final boolean isNotificationContentGenerationRequired() {
        return false;
    }

    @Override
    public void dispatch(Notification notification) {
        String scriptKey = null;
        String script = this.getScriptLocation(notification);
        if (null == script) {
            scriptKey = this.getScriptConfigurationKey(notification);
            script = this.m_configuration.getProperty(scriptKey);
        }
        if (null == script) {
            LOG.warn("Unable to dispatch notification because the {} configuration property was not found", (Object)scriptKey);
            if (null != notification.Callback) {
                notification.Callback.onFailure(notification.CallbackIds);
            }
            return;
        }
        if (notification.getType() != Notification.Type.ALERT) {
            LOG.warn("The {} dispatcher is not able to dispatch notifications of type {}", (Object)this.getType(), (Object)notification.getType());
            if (null != notification.Callback) {
                notification.Callback.onFailure(notification.CallbackIds);
            }
            return;
        }
        long timeout = this.getScriptConfigurationTimeout();
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        AlertNotification alertNotification = (AlertNotification)notification;
        ProcessBuilder processBuilder = this.getProcessBuilder(script, alertNotification);
        AlertScriptRunnable runnable = new AlertScriptRunnable(alertNotification, script, processBuilder, timeout, timeUnit);
        this.m_executor.execute(runnable);
    }

    String getScriptLocation(Notification notification) {
        String scriptName = null;
        String scriptDir = null;
        if (null == notification || null == notification.DispatchProperties) {
            return null;
        }
        scriptName = notification.DispatchProperties.get(DISPATCH_PROPERTY_SCRIPT_FILENAME_KEY);
        if (null == scriptName) {
            LOG.warn("the {} configuration property was not found for dispatching notification", (Object)DISPATCH_PROPERTY_SCRIPT_FILENAME_KEY);
            return null;
        }
        scriptDir = this.m_configuration.getDispatchScriptDirectory();
        return scriptDir + File.separator + scriptName;
    }

    @Override
    public final boolean isDigestSupported() {
        return false;
    }

    @Override
    public final TargetConfigurationResult validateTargetConfig(Map<String, Object> properties) {
        return TargetConfigurationResult.valid();
    }

    ProcessBuilder getProcessBuilder(String script, AlertNotification notification) {
        String shellCommandOption;
        String shellCommand;
        boolean isValidPath;
        if (script == null || script.isEmpty()) {
            throw new IllegalArgumentException("Script path cannot be null or empty");
        }
        String unixPathRegex = "^(/[a-zA-Z0-9._-]+)+$";
        String windowsPathRegex = "^[a-zA-Z]:\\\\([a-zA-Z0-9._-]+\\\\?)+$";
        boolean bl = isValidPath = SystemUtils.IS_OS_WINDOWS ? script.matches(windowsPathRegex) : script.matches(unixPathRegex);
        if (!isValidPath) {
            throw new IllegalArgumentException("Invalid script path format: " + script);
        }
        Path scriptPath = Paths.get(script, new String[0]);
        if (!scriptPath.isAbsolute()) {
            throw new IllegalArgumentException("Script path must be an absolute path: " + script);
        }
        if (!Files.exists(scriptPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Script does not exist: " + script);
        }
        if (!Files.isExecutable(scriptPath)) {
            throw new IllegalArgumentException("Script is not executable: " + script);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            shellCommand = "cmd";
            shellCommandOption = "/c";
        } else {
            shellCommand = "sh";
            shellCommandOption = "-c";
        }
        AlertNoticeDispatchService.AlertInfo alertInfo = notification.getAlertInfo();
        AlertDefinitionEntity definition = alertInfo.getAlertDefinition();
        String definitionName = definition.getDefinitionName();
        AlertState alertState = alertInfo.getAlertState();
        String serviceName = alertInfo.getServiceName();
        String alertLabel = "\"" + SHELL_ESCAPE.escape(definition.getLabel()) + "\"";
        String alertText = "\"" + SHELL_ESCAPE.escape(alertInfo.getAlertText()) + "\"";
        long alertTimestamp = alertInfo.getAlertTimestamp();
        String hostName = alertInfo.getHostName();
        Object[] params = new Object[]{script, definitionName, alertLabel, serviceName, alertState.name(), alertText, alertTimestamp, hostName};
        String foo = StringUtils.join((Object[])params, (String)" ");
        return new ProcessBuilder(shellCommand, shellCommandOption, foo);
    }

    static {
        Escapers.Builder builder = Escapers.builder();
        builder.addEscape('\"', "\\\"");
        builder.addEscape('!', "\\!");
        SHELL_ESCAPE = builder.build();
    }

    private static final class ScriptDispatchThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger s_threadIdPool = new AtomicInteger(1);

        private ScriptDispatchThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "script-dispatcher-" + s_threadIdPool.getAndIncrement());
            thread.setDaemon(false);
            thread.setPriority(4);
            return thread;
        }
    }

    private static final class AlertScriptRunnable
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(AlertScriptRunnable.class);
        private final ProcessBuilder m_processBuilder;
        private final long m_timeout;
        private final TimeUnit m_timeoutUnits;
        private final Notification m_notification;
        private final String m_script;

        private AlertScriptRunnable(Notification notification, String script, ProcessBuilder processBuilder, long timeout, TimeUnit timeoutUnits) {
            this.m_notification = notification;
            this.m_script = script;
            this.m_processBuilder = processBuilder;
            this.m_timeout = timeout;
            this.m_timeoutUnits = timeoutUnits;
        }

        @Override
        public void run() {
            boolean isDispatchSuccessful = true;
            try {
                Process process = this.m_processBuilder.start();
                int exitCode = this.execute(process, this.m_timeout, TimeUnit.MILLISECONDS);
                if (exitCode != 0) {
                    LOG.warn("Unable to dispatch {} notification because {} terminated with exit code {}", new Object[]{TargetType.ALERT_SCRIPT, this.m_script, exitCode});
                    isDispatchSuccessful = false;
                }
            }
            catch (TimeoutException timeoutException) {
                isDispatchSuccessful = false;
                LOG.warn("Unable to dispatch notification with {} in under {}ms", new Object[]{this.m_script, this.m_timeoutUnits.toMillis(this.m_timeout), timeoutException});
            }
            catch (Exception exception) {
                isDispatchSuccessful = false;
                LOG.warn("Unable to dispatch notification with {}", (Object)this.m_script, (Object)exception);
            }
            if (null != this.m_notification.Callback) {
                if (isDispatchSuccessful) {
                    this.m_notification.Callback.onSuccess(this.m_notification.CallbackIds);
                } else {
                    this.m_notification.Callback.onFailure(this.m_notification.CallbackIds);
                }
            }
        }

        public int execute(Process process, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
            long timeRemaining = unit.toMillis(timeout);
            long startTime = System.currentTimeMillis();
            while (timeRemaining > 0L) {
                try {
                    return process.exitValue();
                }
                catch (IllegalThreadStateException ex) {
                    Thread.sleep(Math.min(timeRemaining, 500L));
                    long timeElapsed = System.currentTimeMillis() - startTime;
                    timeRemaining = unit.toMillis(timeout) - timeElapsed;
                }
            }
            process.destroy();
            throw new TimeoutException();
        }
    }
}

