/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.notifications;

import com.google.inject.Singleton;
import id.onyx.obdp.server.notifications.NotificationDispatcher;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class DispatchFactory {
    private static final DispatchFactory s_instance = new DispatchFactory();
    private final Map<String, NotificationDispatcher> m_dispatchers = new HashMap<String, NotificationDispatcher>();

    private DispatchFactory() {
    }

    public static DispatchFactory getInstance() {
        return s_instance;
    }

    public void register(String type, NotificationDispatcher dispatcher) {
        if (null == dispatcher) {
            this.m_dispatchers.remove(type);
        } else {
            this.m_dispatchers.put(type, dispatcher);
        }
    }

    public NotificationDispatcher getDispatcher(String type) {
        return this.m_dispatchers.get(type);
    }
}

