/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.mpack;

import com.google.gson.Gson;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.controller.MpackRequest;
import id.onyx.obdp.server.controller.MpackResponse;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.orm.dao.MpackDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.MpackEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.Module;
import id.onyx.obdp.server.state.Mpack;
import id.onyx.obdp.server.state.stack.StackMetainfoXml;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpackManager {
    protected Map<Long, Mpack> mpackMap = new HashMap<Long, Mpack>();
    private File mpackStaging;
    private MpackDAO mpackDAO;
    private StackDAO stackDAO;
    private Mpack mpack;
    private File stackRoot;
    private static final String MPACK_METADATA = "mpack.json";
    private static final String MPACK_TAR_LOCATION = "staging";
    private static final String MODULES_DIRECTORY = "services";
    private static final String MIN_JDK_PROPERTY = "min-jdk";
    private static final String MAX_JDK_PROPERTY = "max-jdk";
    private static final String DEFAULT_JDK_VALUE = "1.8";
    private static final Logger LOG = LoggerFactory.getLogger(MpackManager.class);

    @AssistedInject
    public MpackManager(@Assisted(value="mpacksv2Staging") File mpacksStagingLocation, @Assisted(value="stackRoot") File stackRootDir, MpackDAO mpackDAOObj, StackDAO stackDAOObj) {
        this.mpackStaging = mpacksStagingLocation;
        this.mpackDAO = mpackDAOObj;
        this.stackRoot = stackRootDir;
        this.stackDAO = stackDAOObj;
        this.parseMpackDirectories();
    }

    private void parseMpackDirectories() {
        try {
            for (File dirEntry : this.mpackStaging.listFiles()) {
                if (!dirEntry.isDirectory()) continue;
                String mpackName = dirEntry.getName();
                LOG.info("Reading mpack :" + mpackName);
                if (mpackName.equals(MPACK_TAR_LOCATION)) continue;
                for (File file : dirEntry.listFiles()) {
                    String mpackVersion;
                    List<MpackEntity> resultSet;
                    if (!file.isDirectory() || (resultSet = this.mpackDAO.findByNameVersion(mpackName, mpackVersion = file.getName())).size() <= 0) continue;
                    MpackEntity mpackEntity = resultSet.get(0);
                    String mpackJsonContents = new String(Files.readAllBytes(Paths.get(file + "/mpack.json", new String[0])), "UTF-8");
                    Gson gson = new Gson();
                    Mpack existingMpack = (Mpack)gson.fromJson(mpackJsonContents, Mpack.class);
                    existingMpack.setResourceId(mpackEntity.getId());
                    existingMpack.setMpackUri(mpackEntity.getMpackUri());
                    existingMpack.setRegistryId(mpackEntity.getRegistryId());
                    this.mpackMap.put(mpackEntity.getId(), existingMpack);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<Long, Mpack> getMpackMap() {
        return this.mpackMap;
    }

    public void setMpackMap(Map<Long, Mpack> mpackMap) {
        this.mpackMap = mpackMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MpackResponse registerMpack(MpackRequest mpackRequest) throws IOException, IllegalArgumentException, ResourceAlreadyExistsException {
        Path mpackTarPath;
        String mpackName = "";
        String mpackVersion = "";
        this.mpack = new Mpack();
        Object mpackDirectory = "";
        if (mpackRequest.getRegistryId() != null) {
            mpackName = mpackRequest.getMpackName();
            mpackVersion = mpackRequest.getMpackVersion();
            LOG.info("Mpack Registration via Registry :" + mpackName);
            this.mpack = this.downloadMpackMetadata(mpackRequest.getMpackUri());
            this.mpack.setRegistryId(mpackRequest.getRegistryId());
            boolean isValidMetadata = this.validateMpackInfo(mpackName, mpackVersion, this.mpack.getName(), this.mpack.getVersion());
            if (!isValidMetadata) {
                String message = "Incorrect information : Mismatch in - (" + mpackName + "," + this.mpack.getName() + ") or (" + mpackVersion + "," + this.mpack.getVersion() + ")";
                throw new IllegalArgumentException(message);
            }
            mpackTarPath = this.downloadMpack(mpackRequest.getMpackUri(), this.mpack.getDefinition());
            this.createMpackDirectory(this.mpack);
            mpackDirectory = this.mpackStaging + File.separator + this.mpack.getName() + File.separator + this.mpack.getVersion();
        } else {
            this.mpack = this.downloadMpackMetadata(mpackRequest.getMpackUri());
            mpackTarPath = this.downloadMpack(mpackRequest.getMpackUri(), this.mpack.getDefinition());
            LOG.info("Custom Mpack Registration :" + mpackRequest.getMpackUri());
            if (this.createMpackDirectory(this.mpack).booleanValue()) {
                mpackDirectory = this.mpackStaging + File.separator + this.mpack.getName() + File.separator + this.mpack.getVersion();
            }
        }
        this.extractMpackTar(this.mpack, mpackTarPath, (String)mpackDirectory);
        this.mpack.setMpackUri(mpackRequest.getMpackUri());
        Long mpackResourceId = this.populateDB(this.mpack);
        if (mpackResourceId != null) {
            this.mpackMap.put(mpackResourceId, this.mpack);
            this.mpack.setResourceId(mpackResourceId);
            this.populateStackDB(this.mpack);
            return new MpackResponse(this.mpack);
        }
        String message = "Mpack :" + mpackRequest.getMpackName() + " version: " + mpackRequest.getMpackVersion() + " already exists in server";
        throw new ResourceAlreadyExistsException(message);
    }

    private Mpack downloadMpackMetadata(String mpackURI) throws IOException {
        URL url = new URL(mpackURI);
        File stagingDir = new File(this.mpackStaging.toString() + File.separator + MPACK_TAR_LOCATION);
        Path targetPath = new File(stagingDir.getPath() + File.separator + MPACK_METADATA).toPath();
        LOG.debug("Download mpack.json and store in :" + targetPath);
        if (!stagingDir.exists()) {
            stagingDir.mkdirs();
        }
        Files.copy(url.openStream(), targetPath, StandardCopyOption.REPLACE_EXISTING);
        Gson gson = new Gson();
        Mpack mpack = (Mpack)gson.fromJson((Reader)new FileReader(targetPath.toString()), Mpack.class);
        return mpack;
    }

    private void extractTar(Path tarPath, File untarDirectory) throws IOException {
        TarArchiveInputStream tarFile = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(new File(String.valueOf(tarPath))))));
        TarArchiveEntry entry = null;
        File outputFile = null;
        LOG.debug("Extracting tar file :" + tarFile);
        while ((entry = tarFile.getNextTarEntry()) != null) {
            outputFile = new File(untarDirectory, entry.getName());
            if (entry.isDirectory()) {
                if (outputFile.exists()) continue;
                LOG.debug("Creating output directory " + outputFile.getAbsolutePath());
                if (outputFile.mkdirs()) continue;
                throw new IllegalStateException("Couldn't create directory " + outputFile.getAbsolutePath());
            }
            File parentDir = outputFile.getParentFile();
            if (!parentDir.exists()) {
                LOG.debug("Attempting to create output directory " + parentDir.getAbsolutePath());
                if (!parentDir.mkdirs()) {
                    throw new IllegalStateException("Couldn't create directory " + parentDir.getAbsolutePath());
                }
            }
            LOG.debug("Creating output file " + outputFile.getAbsolutePath());
            FileOutputStream outputFileStream = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)tarFile, (OutputStream)outputFileStream);
            ((OutputStream)outputFileStream).close();
        }
        tarFile.close();
    }

    private void extractMpackTar(Mpack mpack, Path mpackTarPath, String mpackDirectory) throws IOException {
        this.extractTar(mpackTarPath, this.mpackStaging);
        String mpackTarDirectory = mpackTarPath.toString();
        Path extractedMpackDirectory = Files.move(Paths.get(this.mpackStaging + File.separator + mpackTarDirectory.substring(mpackTarDirectory.lastIndexOf(47) + 1, mpackTarDirectory.indexOf(".tar")) + File.separator, new String[0]), Paths.get(mpackDirectory, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        LOG.debug("Extracting Mpack definitions into :" + extractedMpackDirectory);
        this.createServicesDirectory(extractedMpackDirectory, mpack);
        File metainfoFile = new File(extractedMpackDirectory + File.separator + "metainfo.xml");
        if (!metainfoFile.exists()) {
            this.generateMetainfo(metainfoFile, mpack);
        }
        this.createSymLinks(mpack);
    }

    private void generateMetainfo(File metainfoFile, Mpack mpack) throws IOException {
        LOG.info("Generating {} for mpack {}", (Object)metainfoFile, (Object)mpack.getName());
        StackMetainfoXml generatedMetainfo = new StackMetainfoXml();
        StackMetainfoXml.Version version = new StackMetainfoXml.Version();
        version.setActive(true);
        generatedMetainfo.setVersion(version);
        HashMap<String, String> prerequisites = mpack.getPrerequisites();
        if (prerequisites != null && prerequisites.containsKey(MIN_JDK_PROPERTY)) {
            generatedMetainfo.setMinJdk(mpack.getPrerequisites().get(MIN_JDK_PROPERTY));
        } else {
            LOG.warn("Couldn't detect {} for mpack {}. Using default value {}", new Object[]{MIN_JDK_PROPERTY, mpack.getName(), DEFAULT_JDK_VALUE});
            generatedMetainfo.setMinJdk(DEFAULT_JDK_VALUE);
        }
        if (prerequisites != null && prerequisites.containsKey(MAX_JDK_PROPERTY)) {
            generatedMetainfo.setMaxJdk(mpack.getPrerequisites().get(MAX_JDK_PROPERTY));
        } else {
            LOG.warn("Couldn't detect {} for mpack {}. Using default value {}", new Object[]{MAX_JDK_PROPERTY, mpack.getName(), DEFAULT_JDK_VALUE});
            generatedMetainfo.setMaxJdk(DEFAULT_JDK_VALUE);
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{StackMetainfoXml.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            FileOutputStream stackMetainfoFileStream = new FileOutputStream(metainfoFile);
            marshaller.marshal((Object)generatedMetainfo, (OutputStream)stackMetainfoFileStream);
            stackMetainfoFileStream.flush();
            stackMetainfoFileStream.close();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private void createServicesDirectory(Path extractedMpackDirectory, Mpack mpack) throws IOException {
        File servicesDir = new File(extractedMpackDirectory.toAbsolutePath() + File.separator + MODULES_DIRECTORY);
        if (!servicesDir.exists()) {
            servicesDir.mkdirs();
        }
        List<Module> modules = mpack.getModules();
        LOG.info("Creating services directory for mpack :" + mpack.getName());
        for (Module module : modules) {
            String moduleDefinitionLocation = module.getDefinition();
            File serviceTargetDir = new File(servicesDir + File.separator + module.getName());
            this.extractTar(Paths.get(extractedMpackDirectory + File.separator + "modules" + File.separator + moduleDefinitionLocation, new String[0]), servicesDir);
            Path path = Files.move(Paths.get(servicesDir + File.separator + moduleDefinitionLocation.substring(moduleDefinitionLocation.indexOf("/") + 1, moduleDefinitionLocation.indexOf(".tar.gz")), new String[0]), serviceTargetDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Boolean createMpackDirectory(Mpack mpack) throws IOException, ResourceAlreadyExistsException {
        List<MpackEntity> mpackEntities = this.mpackDAO.findByNameVersion(mpack.getName(), mpack.getVersion());
        if (mpackEntities.size() == 0) {
            File mpackDirectory = new File(this.mpackStaging + File.separator + mpack.getName());
            if (!mpackDirectory.exists()) {
                mpackDirectory.mkdirs();
            }
            return true;
        }
        String message = "Mpack: " + mpack.getName() + " version: " + mpack.getVersion() + " already exists in server";
        throw new ResourceAlreadyExistsException(message);
    }

    private void createSymLinks(Mpack mpack) throws IOException {
        String stackName = mpack.getName();
        String stackVersion = mpack.getVersion();
        File stack = new File(this.stackRoot + "/" + stackName);
        Path stackPath = Paths.get(this.stackRoot + "/" + stackName + "/" + stackVersion, new String[0]);
        Path mpackPath = Paths.get(this.mpackStaging + "/" + mpack.getName() + "/" + mpack.getVersion(), new String[0]);
        if (Files.isSymbolicLink(stackPath)) {
            Files.delete(stackPath);
        }
        Files.createSymbolicLink(stackPath, mpackPath, new FileAttribute[0]);
    }

    public Path downloadMpack(String mpackURI, String mpackDefinitionLocation) throws IOException {
        File stagingDir = new File(this.mpackStaging.toString() + File.separator + MPACK_TAR_LOCATION);
        Path targetPath = new File(stagingDir.getPath() + File.separator + mpackDefinitionLocation).toPath();
        String mpackTarURI = mpackURI.substring(0, mpackURI.lastIndexOf(47)) + File.separator + mpackDefinitionLocation;
        URL url = new URL(mpackTarURI);
        if (!stagingDir.exists()) {
            stagingDir.mkdirs();
        }
        Files.copy(url.openStream(), targetPath, StandardCopyOption.REPLACE_EXISTING);
        return targetPath;
    }

    protected boolean validateMpackInfo(String expectedMpackName, String expectedMpackVersion, String actualMpackName, String actualMpackVersion) {
        if (expectedMpackName.equalsIgnoreCase(actualMpackName) && expectedMpackVersion.equalsIgnoreCase(actualMpackVersion)) {
            return true;
        }
        LOG.info("Incorrect information : Mismatch in - (" + expectedMpackName + "," + actualMpackName + ") or (" + expectedMpackVersion + "," + actualMpackVersion + ")");
        return false;
    }

    protected Long populateDB(Mpack mpacks) throws IOException {
        String mpackName = mpacks.getName();
        String mpackVersion = mpacks.getVersion();
        List<MpackEntity> resultSet = this.mpackDAO.findByNameVersion(mpackName, mpackVersion);
        StackEntity stackEntity = this.stackDAO.find(mpackName, mpackVersion);
        if (resultSet.size() == 0 && stackEntity == null) {
            LOG.info("Adding mpack {}-{} to the database", (Object)mpackName, (Object)mpackVersion);
            MpackEntity mpackEntity = new MpackEntity();
            mpackEntity.setMpackName(mpackName);
            mpackEntity.setMpackVersion(mpackVersion);
            mpackEntity.setMpackUri(this.mpack.getMpackUri());
            mpackEntity.setRegistryId(this.mpack.getRegistryId());
            Long mpackId = this.mpackDAO.create(mpackEntity);
            return mpackId;
        }
        return null;
    }

    protected void populateStackDB(Mpack mpack) throws IOException, ResourceAlreadyExistsException {
        String stackVersion;
        String stackName = mpack.getName();
        StackEntity stackEntity = this.stackDAO.find(stackName, stackVersion = mpack.getVersion());
        if (stackEntity != null) {
            String message = "Stack " + stackName + "-" + stackVersion + " already exists";
            LOG.error(message);
            throw new ResourceAlreadyExistsException(message);
        }
        LOG.info("Adding stack {}-{} to the database", (Object)stackName, (Object)stackVersion);
        stackEntity = new StackEntity();
        stackEntity.setStackName(stackName);
        stackEntity.setStackVersion(stackVersion);
        stackEntity.setMpackId(mpack.getResourceId());
        this.stackDAO.create(stackEntity);
    }

    public List<Module> getModules(Long mpackId) {
        Mpack mpack = this.mpackMap.get(mpackId);
        return mpack.getModules();
    }

    public boolean removeMpack(MpackEntity mpackEntity, StackEntity stackEntity) throws IOException {
        boolean stackDelete = false;
        File mpackDirToDelete = new File(this.mpackStaging + File.separator + mpackEntity.getMpackName() + File.separator + mpackEntity.getMpackVersion());
        File mpackDirectory = new File(this.mpackStaging + "/" + mpackEntity.getMpackName());
        String mpackName = mpackEntity.getMpackName() + "-" + mpackEntity.getMpackVersion() + ".tar.gz";
        Path mpackTarFile = Paths.get(this.mpackStaging + File.separator + MPACK_TAR_LOCATION + File.separator + mpackName, new String[0]);
        LOG.info("Removing mpack :" + mpackName);
        this.mpackMap.remove(mpackEntity.getId());
        FileUtils.deleteDirectory((File)mpackDirToDelete);
        if (mpackDirectory.isDirectory() && mpackDirectory.list().length == 0) {
            Files.delete(mpackDirectory.toPath());
        }
        if (stackEntity != null) {
            Path stackPath = Paths.get(this.stackRoot + "/" + stackEntity.getStackName() + "/" + stackEntity.getStackVersion(), new String[0]);
            File stackDirectory = new File(this.stackRoot + "/" + stackEntity.getStackName());
            if (!Files.exists(stackPath, new LinkOption[0])) {
                Files.delete(stackPath);
            }
            if (stackDirectory.isDirectory() && stackDirectory.list().length == 0) {
                Files.delete(stackDirectory.toPath());
            }
            stackDelete = true;
        }
        if (Files.exists(mpackTarFile, new LinkOption[0])) {
            Files.delete(mpackTarFile);
        }
        return stackDelete;
    }
}

