/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metrics.system.impl;

import com.google.common.eventbus.Subscribe;
import id.onyx.obdp.server.events.STOMPEvent;
import id.onyx.obdp.server.metrics.system.MetricsSink;
import id.onyx.obdp.server.metrics.system.SingleMetric;
import id.onyx.obdp.server.metrics.system.impl.AbstractMetricsSource;
import id.onyx.obdp.server.metrics.system.impl.MetricsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompEventsMetricsSource
extends AbstractMetricsSource {
    private static Logger LOG = LoggerFactory.getLogger(StompEventsMetricsSource.class);
    private Map<STOMPEvent.Type, Long> events = new HashMap<STOMPEvent.Type, Long>();
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final String EVENTS_TOTAL_METRIC = "events.total";
    private final String AVERAGE_METRIC_SUFFIX = ".avg";
    private int interval = 60;

    @Override
    public void init(MetricsConfiguration configuration, MetricsSink sink) {
        super.init(configuration, sink);
        for (STOMPEvent.Type type : STOMPEvent.Type.values()) {
            this.events.put(type, 0L);
        }
    }

    @Override
    public void start() {
        LOG.info("Starting stomp events source...");
        try {
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    List<SingleMetric> events = StompEventsMetricsSource.this.getEvents();
                    StompEventsMetricsSource.this.sink.publish(events);
                    LOG.debug("********* Published stomp events metrics to sink **********");
                }
            }, this.interval, this.interval, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.info("Throwing exception when starting stomp events source", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SingleMetric> getEvents() {
        ArrayList<SingleMetric> metrics = new ArrayList<SingleMetric>();
        Long totalEventsCounter = 0L;
        Map<STOMPEvent.Type, Long> map = this.events;
        synchronized (map) {
            for (Map.Entry<STOMPEvent.Type, Long> event : this.events.entrySet()) {
                totalEventsCounter = totalEventsCounter + event.getValue();
                metrics.add(new SingleMetric(event.getKey().getMetricName(), event.getValue().longValue(), System.currentTimeMillis()));
                String averageMetricName = event.getKey().getMetricName() + ".avg";
                Double eventsPerSecond = event.getValue() == 0L ? -1.0 : (double)this.interval / (double)event.getValue().longValue();
                metrics.add(new SingleMetric(averageMetricName, eventsPerSecond, System.currentTimeMillis()));
                this.events.put(event.getKey(), 0L);
            }
            metrics.add(new SingleMetric("events.total", totalEventsCounter.longValue(), System.currentTimeMillis()));
            String totalAverageMetricName = "events.total.avg";
            Double eventsPerSecond = totalEventsCounter == 0L ? -1.0 : (double)this.interval / (double)totalEventsCounter.longValue();
            metrics.add(new SingleMetric(totalAverageMetricName, eventsPerSecond, System.currentTimeMillis()));
        }
        return metrics;
    }

    @Subscribe
    public void onUpdateEvent(STOMPEvent STOMPEvent2) {
        STOMPEvent.Type metricType = STOMPEvent2.getType();
        this.events.put(metricType, this.events.get((Object)metricType) + 1L);
    }
}

