/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metrics.system.impl;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.metrics.system.MetricsSink;
import id.onyx.obdp.server.metrics.system.SingleMetric;
import id.onyx.obdp.server.metrics.system.impl.MetricsConfiguration;
import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationToken;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.sink.timeline.AbstractTimelineMetricsSink;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.hadoop.metrics2.sink.timeline.cache.TimelineMetricsCache;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class OBDPMetricSinkImpl
extends AbstractTimelineMetricsSink
implements MetricsSink {
    private static final String AMBARI_SERVER_APP_ID = "obdp_server";
    private Collection<String> collectorHosts;
    private String collectorUri;
    private String port;
    private String protocol;
    private String hostName;
    private OBDPManagementController ambariManagementController;
    private TimelineMetricsCache timelineMetricsCache;
    private boolean isInitialized = false;
    private boolean setInstanceId = false;
    private String instanceId;

    public OBDPMetricSinkImpl(OBDPManagementController amc) {
        this.ambariManagementController = amc;
    }

    @Override
    public void init(MetricsConfiguration configuration) {
        if (this.ambariManagementController == null) {
            return;
        }
        InternalAuthenticationToken authenticationToken = new InternalAuthenticationToken("admin");
        authenticationToken.setAuthenticated(true);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        Clusters clusters = this.ambariManagementController.getClusters();
        if (clusters == null || clusters.getClusters().isEmpty()) {
            this.LOG.info((Object)"No clusters configured.");
            return;
        }
        String ambariMetricsServiceName = "AMBARI_METRICS";
        this.collectorHosts = new HashSet<String>();
        for (Map.Entry<String, Cluster> kv : clusters.getClusters().entrySet()) {
            String clusterName;
            this.instanceId = clusterName = kv.getKey();
            Cluster c = kv.getValue();
            Resource.Type type = Resource.Type.ServiceConfigVersion;
            boolean externalHostConfigPresent = false;
            boolean externalPortConfigPresent = false;
            Config clusterEnv = c.getDesiredConfigByType("cluster-env");
            if (clusterEnv != null) {
                String metricsCollectorExternalPort;
                Map<String, String> configs = clusterEnv.getProperties();
                String metricsCollectorExternalHosts = configs.get("metrics_collector_external_hosts");
                if (StringUtils.isNotEmpty((String)metricsCollectorExternalHosts)) {
                    this.LOG.info((Object)("Setting Metrics Collector External Host : " + metricsCollectorExternalHosts));
                    this.collectorHosts.addAll(Arrays.asList(metricsCollectorExternalHosts.split(",")));
                    externalHostConfigPresent = true;
                    this.setInstanceId = true;
                }
                if (StringUtils.isNotEmpty((String)(metricsCollectorExternalPort = configs.get("metrics_collector_external_port")))) {
                    this.LOG.info((Object)("Setting Metrics Collector External Port : " + metricsCollectorExternalPort));
                    this.port = metricsCollectorExternalPort;
                    externalPortConfigPresent = true;
                }
            }
            HashSet<String> propertyIds = new HashSet<String>();
            propertyIds.add("configurations");
            Predicate predicate = new PredicateBuilder().property("cluster_name").equals(clusterName).and().property("service_name").equals(ambariMetricsServiceName).and().property("is_current").equals("true").toPredicate();
            Request request = PropertyHelper.getReadRequest(propertyIds);
            ResourceProvider provider = AbstractControllerResourceProvider.getResourceProvider(type, this.ambariManagementController);
            try {
                Service service;
                if (!externalHostConfigPresent && (service = c.getService(ambariMetricsServiceName)) != null) {
                    for (String component : service.getServiceComponents().keySet()) {
                        ServiceComponent sc = service.getServiceComponents().get(component);
                        for (ServiceComponentHost serviceComponentHost : sc.getServiceComponentHosts().values()) {
                            if (!serviceComponentHost.getServiceComponentName().equals("METRICS_COLLECTOR")) continue;
                            this.collectorHosts.add(serviceComponentHost.getHostName());
                        }
                    }
                }
                Set<Resource> resources = provider.getResources(request, predicate);
                block5: for (Resource resource : resources) {
                    if (resource == null) continue;
                    ArrayList configs = (ArrayList)resource.getPropertyValue("configurations");
                    for (LinkedHashMap config : configs) {
                        String httpPolicy;
                        if (config == null || !config.get("type").equals("ams-site")) continue;
                        TreeMap properties = (TreeMap)config.get("properties");
                        String timelineWebappAddress = (String)properties.get("timeline.metrics.service.webapp.address");
                        if (!externalPortConfigPresent && StringUtils.isNotEmpty((String)timelineWebappAddress) && timelineWebappAddress.contains(":")) {
                            this.port = timelineWebappAddress.split(":")[1];
                        }
                        this.protocol = (httpPolicy = (String)properties.get("timeline.metrics.service.http.policy")).equals("HTTP_ONLY") ? "http" : "https";
                        continue block5;
                    }
                }
            }
            catch (Exception e) {
                this.LOG.info((Object)"Exception caught when retrieving Collector URI", (Throwable)e);
            }
        }
        this.hostName = configuration.getProperty("ambariserver.hostname.override", this.getDefaultLocalHostName());
        this.LOG.info((Object)("Hostname used for ambari server metrics : " + this.hostName));
        if (this.protocol.contains("https")) {
            ComponentSSLConfiguration sslConfiguration = ComponentSSLConfiguration.instance();
            String trustStorePath = sslConfiguration.getTruststorePath();
            String trustStoreType = sslConfiguration.getTruststoreType();
            String trustStorePwd = sslConfiguration.getTruststorePassword();
            this.loadTruststore(trustStorePath, trustStoreType, trustStorePwd);
        }
        this.collectorUri = this.getCollectorUri(this.findPreferredCollectHost());
        int maxRowCacheSize = Integer.parseInt(configuration.getProperty("maxRowCacheSize", String.valueOf(10000)));
        int metricsSendInterval = Integer.parseInt(configuration.getProperty("sendInterval", String.valueOf(59000)));
        this.timelineMetricsCache = new TimelineMetricsCache(maxRowCacheSize, metricsSendInterval);
        if (CollectionUtils.isNotEmpty(this.collectorHosts)) {
            this.LOG.info((Object)("Metric Sink initialized with collectorHosts : " + this.collectorHosts.toString()));
            this.isInitialized = true;
        }
    }

    private String getDefaultLocalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.LOG.info((Object)"Error getting host address");
            return null;
        }
    }

    @Override
    public void publish(List<SingleMetric> metrics) {
        if (this.isInitialized) {
            List<TimelineMetric> metricList = this.getFilteredMetricList(metrics);
            if (!metricList.isEmpty()) {
                TimelineMetrics timelineMetrics = new TimelineMetrics();
                timelineMetrics.setMetrics(metricList);
                this.emitMetrics(timelineMetrics);
            }
        } else {
            this.LOG.debug((Object)"Metric Sink not yet initialized. Discarding metrics.");
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected String getCollectorUri(String host) {
        return this.constructTimelineMetricUri(this.protocol, host, this.port);
    }

    protected String getCollectorProtocol() {
        return this.protocol;
    }

    protected String getCollectorPort() {
        return this.port;
    }

    protected int getTimeoutSeconds() {
        return 10;
    }

    protected String getZookeeperQuorum() {
        return null;
    }

    protected Collection<String> getConfiguredCollectorHosts() {
        return this.collectorHosts;
    }

    protected String getHostname() {
        return this.hostName;
    }

    protected boolean isHostInMemoryAggregationEnabled() {
        return false;
    }

    protected int getHostInMemoryAggregationPort() {
        return 0;
    }

    protected String getHostInMemoryAggregationProtocol() {
        return "http";
    }

    private List<TimelineMetric> getFilteredMetricList(List<SingleMetric> metrics) {
        ArrayList<TimelineMetric> metricList = new ArrayList<TimelineMetric>();
        for (SingleMetric metric : metrics) {
            String metricName = metric.getMetricName();
            Double value = metric.getValue();
            TimelineMetric timelineMetric = this.createTimelineMetric(metric.getTimestamp(), AMBARI_SERVER_APP_ID, metricName, value);
            this.timelineMetricsCache.putTimelineMetric(timelineMetric, false);
            TimelineMetric cachedMetric = this.timelineMetricsCache.getTimelineMetric(metricName);
            if (cachedMetric == null) continue;
            metricList.add(cachedMetric);
        }
        return metricList;
    }

    private TimelineMetric createTimelineMetric(long currentTimeMillis, String component, String attributeName, Number attributeValue) {
        TimelineMetric timelineMetric = new TimelineMetric();
        timelineMetric.setMetricName(attributeName);
        timelineMetric.setHostName(this.hostName);
        if (this.setInstanceId) {
            timelineMetric.setInstanceId(this.instanceId);
        }
        timelineMetric.setAppId(component);
        timelineMetric.setStartTime(currentTimeMillis);
        timelineMetric.getMetricValues().put(currentTimeMillis, attributeValue.doubleValue());
        return timelineMetric;
    }
}

