/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metrics.system.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.metrics.system.MetricsService;
import id.onyx.obdp.server.metrics.system.MetricsSink;
import id.onyx.obdp.server.metrics.system.MetricsSource;
import id.onyx.obdp.server.metrics.system.impl.AbstractMetricsSource;
import id.onyx.obdp.server.metrics.system.impl.MetricsConfiguration;
import id.onyx.obdp.server.metrics.system.impl.OBDPMetricSinkImpl;
import id.onyx.obdp.server.metrics.system.impl.StompEventsMetricsSource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MetricsServiceImpl
implements MetricsService {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsServiceImpl.class);
    private static Map<String, MetricsSource> sources = new HashMap<String, MetricsSource>();
    private static MetricsSink sink = null;
    private MetricsConfiguration configuration = null;
    @Inject
    OBDPManagementController amc;
    @Inject
    STOMPUpdatePublisher STOMPUpdatePublisher;

    @Override
    public void start() {
        LOG.info("********* Initializing OBDPServer Metrics Service **********");
        try {
            this.configuration = MetricsConfiguration.getMetricsConfiguration();
            if (this.configuration == null) {
                return;
            }
            sink = new OBDPMetricSinkImpl(this.amc);
            this.initializeMetricsSink();
            this.initializeMetricSources();
            if (!sink.isInitialized()) {
                Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (!sink.isInitialized()) {
                            LOG.info("Attempting to initialize metrics sink");
                            MetricsServiceImpl.this.initializeMetricsSink();
                            if (sink.isInitialized()) {
                                LOG.info("Metric sink initialization successful");
                            }
                        }
                    }
                }, 5L, 5L, TimeUnit.MINUTES);
            }
        }
        catch (Exception e) {
            LOG.info("Unable to initialize MetricsService : ", (Object)e.getMessage());
        }
    }

    private void initializeMetricsSink() {
        LOG.info("********* Configuring Metric Sink **********");
        sink.init(this.configuration);
    }

    private void initializeMetricSources() {
        try {
            String[] sourceNames;
            LOG.info("********* Configuring Metric Sources **********");
            String commaSeparatedSources = this.configuration.getProperty("metric.sources");
            if (StringUtils.isEmpty((String)commaSeparatedSources)) {
                LOG.info("No metric sources configured.");
                return;
            }
            for (String sourceName : sourceNames = commaSeparatedSources.split(",")) {
                Class<?> sourceClass;
                if (StringUtils.isEmpty((String)sourceName)) continue;
                sourceName = sourceName.trim();
                String className = this.configuration.getProperty("source." + sourceName + ".class");
                try {
                    sourceClass = Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    LOG.info("Source class not found for source name :" + sourceName);
                    continue;
                }
                AbstractMetricsSource src = (AbstractMetricsSource)sourceClass.newInstance();
                src.init(MetricsConfiguration.getSubsetConfiguration(this.configuration, "source." + sourceName + "."), sink);
                sources.put(sourceName, src);
                if (src instanceof StompEventsMetricsSource) {
                    this.STOMPUpdatePublisher.registerAPI(src);
                    this.STOMPUpdatePublisher.registerAgent(src);
                }
                src.start();
            }
        }
        catch (Exception e) {
            LOG.error("Error when configuring metric sink and source", (Throwable)e);
        }
    }

    public static MetricsSource getSource(String type) {
        return sources.get(type);
    }

    public static MetricsSink getSink() {
        return sink;
    }
}

