/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metrics.system.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConfiguration {
    public static final String CONFIG_FILE = "metrics.properties";
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfiguration.class);
    private Properties properties;

    public static MetricsConfiguration getMetricsConfiguration() {
        Properties properties = MetricsConfiguration.readConfigFile();
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        return new MetricsConfiguration(properties);
    }

    public MetricsConfiguration(Properties properties) {
        this.properties = properties;
    }

    private static Properties readConfigFile() {
        Properties properties = new Properties();
        InputStream inputStream = MetricsConfiguration.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        if (inputStream == null) {
            LOG.info("metrics.properties not found in classpath");
            return null;
        }
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fnf) {
            LOG.info("No configuration file metrics.properties found in classpath.");
            return null;
        }
        catch (IOException ie) {
            LOG.error("Can't read configuration file metrics.properties", (Throwable)ie);
            return null;
        }
        return properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static MetricsConfiguration getSubsetConfiguration(MetricsConfiguration metricsConfiguration, String prefix) {
        if (null == metricsConfiguration) {
            return null;
        }
        Properties properties = metricsConfiguration.getProperties();
        if (null == properties || StringUtils.isEmpty((String)prefix)) {
            return new MetricsConfiguration(properties);
        }
        Properties subsetProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            if (!key.startsWith(prefix)) continue;
            key = key.substring(prefix.length());
            subsetProperties.put(key, val);
        }
        return new MetricsConfiguration(subsetProperties);
    }
}

