/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metrics.system.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import id.onyx.obdp.server.metrics.system.MetricsSink;
import id.onyx.obdp.server.metrics.system.SingleMetric;
import id.onyx.obdp.server.metrics.system.impl.AbstractMetricsSource;
import id.onyx.obdp.server.metrics.system.impl.MetricsConfiguration;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmMetricsSource
extends AbstractMetricsSource {
    static final MetricRegistry registry = new MetricRegistry();
    private static final Logger LOG = LoggerFactory.getLogger(JvmMetricsSource.class);
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private static String JVM_PREFIX = "jvm";
    private int interval = 10;

    @Override
    public void init(MetricsConfiguration configuration, MetricsSink sink) {
        super.init(configuration, sink);
        this.registerAll(JVM_PREFIX + ".gc", (MetricSet)new GarbageCollectorMetricSet(), registry);
        this.registerAll(JVM_PREFIX + ".buffers", (MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()), registry);
        this.registerAll(JVM_PREFIX + ".memory", (MetricSet)new MemoryUsageGaugeSet(), registry);
        this.registerAll(JVM_PREFIX + ".threads", (MetricSet)new ThreadStatesGaugeSet(), registry);
        registry.register(JVM_PREFIX + ".file.open.descriptor.ratio", (Metric)new FileDescriptorRatioGauge());
        this.interval = Integer.parseInt(configuration.getProperty("interval", "10"));
        LOG.info("Initialized JVM Metrics source...");
    }

    @Override
    public void start() {
        try {
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOG.debug("Publishing JVM metrics to sink");
                        JvmMetricsSource.this.sink.publish(JvmMetricsSource.this.getMetrics());
                    }
                    catch (Exception e) {
                        LOG.debug("Error in publishing JVM metrics to sink.");
                    }
                }
            }, this.interval, this.interval, TimeUnit.SECONDS);
            LOG.info("Started JVM Metrics source...");
        }
        catch (Exception e) {
            LOG.info("Throwing exception when starting metric source", (Throwable)e);
        }
    }

    private void registerAll(String prefix, MetricSet metricSet, MetricRegistry registry) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public List<SingleMetric> getMetrics() {
        ArrayList<SingleMetric> metrics = new ArrayList<SingleMetric>();
        SortedMap gaugeSet = registry.getGauges((MetricFilter)new NonNumericMetricFilter());
        for (String metricName : gaugeSet.keySet()) {
            Number value = (Number)((Gauge)gaugeSet.get(metricName)).getValue();
            metrics.add(new SingleMetric(metricName, value.doubleValue(), System.currentTimeMillis()));
        }
        return metrics;
    }

    public class NonNumericMetricFilter
    implements MetricFilter {
        public boolean matches(String name, Metric metric) {
            return !name.equalsIgnoreCase("jvm.threads.deadlocks");
        }
    }
}

