/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metrics.system.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import id.onyx.obdp.server.metrics.system.MetricsSink;
import id.onyx.obdp.server.metrics.system.SingleMetric;
import id.onyx.obdp.server.metrics.system.impl.AbstractMetricsSource;
import id.onyx.obdp.server.metrics.system.impl.MetricsConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetricsSource
extends AbstractMetricsSource {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseMetricsSource.class);
    private static String dbMonitorPrefix = "monitor.";
    private ExecutorService executor;
    private MetricsConfiguration configuration;
    private Set<String> includedMetricKeywords = new HashSet<String>();
    private Set<Pattern> acceptedEntityPatterns = new HashSet<Pattern>();
    private Set<String> acceptedEntities = new HashSet<String>();
    private static String TIMER = "Timer.";
    private static String COUNTER = "Counter.";

    @Override
    public void init(MetricsConfiguration metricsConfig, MetricsSink sink) {
        super.init(metricsConfig, sink);
        this.configuration = metricsConfig;
        this.initializeFilterSets();
        LOG.info("Initialized Ambari DB Metrics Source...");
    }

    private void initializeFilterSets() {
        String commaSeparatedValues = this.configuration.getProperty(dbMonitorPrefix + "query.keywords.include");
        if (StringUtils.isNotEmpty((String)commaSeparatedValues)) {
            this.includedMetricKeywords.addAll(Arrays.asList(commaSeparatedValues.split(",")));
        }
        if (StringUtils.isNotEmpty((String)(commaSeparatedValues = this.configuration.getProperty(dbMonitorPrefix + "entities")))) {
            String[] entityPatterns;
            for (String pattern : entityPatterns = commaSeparatedValues.split(",")) {
                this.acceptedEntityPatterns.add(Pattern.compile(pattern));
            }
        }
    }

    @Override
    public void start() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("DatabaseMetricsSource-%d").build();
        this.executor = Executors.newSingleThreadExecutor(threadFactory);
        LOG.info("Started Ambari DB Metrics source...");
    }

    public void publish(final Map<String, Long> metricsMap) {
        try {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    long currentTime = System.currentTimeMillis();
                    Iterator it = metricsMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry metricEntry = it.next();
                        String metricName = (String)metricEntry.getKey();
                        if (DatabaseMetricsSource.this.acceptMetric(metricName)) continue;
                        it.remove();
                    }
                    ArrayList<SingleMetric> metrics = new ArrayList<SingleMetric>();
                    for (String metricName : metricsMap.keySet()) {
                        String baseMetricName;
                        double value = ((Long)metricsMap.get(metricName)).doubleValue();
                        metrics.add(new SingleMetric(metricName, value, currentTime));
                        if (!metricName.startsWith(COUNTER) || !metricsMap.containsKey(TIMER + (baseMetricName = metricName.substring(COUNTER.length())))) continue;
                        double timerValue = ((Long)metricsMap.get(TIMER + baseMetricName)).doubleValue();
                        if (value == 0.0) continue;
                        metrics.add(new SingleMetric(baseMetricName, timerValue / value, currentTime));
                    }
                    DatabaseMetricsSource.this.sink.publish(metrics);
                }
            });
        }
        catch (Exception e) {
            LOG.info("Exception when publishing Database metrics to sink", (Throwable)e);
        }
    }

    public boolean acceptMetric(String metricName) {
        boolean accept = false;
        if (this.acceptedEntities.contains(metricName)) {
            accept = true;
        } else {
            for (Pattern p : this.acceptedEntityPatterns) {
                Matcher m = p.matcher(metricName);
                if (!m.find()) continue;
                accept = true;
            }
        }
        for (String keyword : this.includedMetricKeywords) {
            if (!metricName.contains(keyword)) continue;
            accept = true;
        }
        String[] splits = metricName.split("\\.");
        if (splits.length <= 2) {
            accept = true;
        }
        if (accept) {
            this.acceptedEntities.add(metricName);
            return true;
        }
        return false;
    }

    public String getConfigurationValue(String key, String defaultValue) {
        return this.configuration.getProperty(dbMonitorPrefix + key, defaultValue);
    }
}

