/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metrics.system.impl;

import com.google.inject.Singleton;
import id.onyx.obdp.server.metrics.system.impl.DatabaseMetricsSource;
import id.onyx.obdp.server.metrics.system.impl.MetricsServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.tools.profiler.PerformanceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AmbariPerformanceMonitor
extends PerformanceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariPerformanceMonitor.class);
    private boolean isInitialized = false;
    private DatabaseMetricsSource metricsSource;
    private static String entityPackagePrefix = "org.apache";

    public AmbariPerformanceMonitor() {
        LOG.info("AmbariPerformanceMonitor instantiated");
        this.init();
    }

    private void init() {
        if (this.metricsSource == null) {
            this.metricsSource = (DatabaseMetricsSource)MetricsServiceImpl.getSource("database");
        }
        if (this.metricsSource != null) {
            LOG.info("AmbariPerformanceMonitor initialized");
            long interval = Long.parseLong(this.metricsSource.getConfigurationValue("dumptime", "60000"));
            this.setDumpTime(interval);
            String profileWeight = this.metricsSource.getConfigurationValue("query.weight", "HEAVY");
            this.setProfileWeight(this.getWeight(profileWeight));
            this.isInitialized = true;
        } else {
            LOG.info("AmbariPerformanceMonitor not yet initialized.");
        }
    }

    public void dumpResults() {
        this.lastDumpTime = System.currentTimeMillis();
        TreeSet operations = new TreeSet(this.operationTimings.keySet());
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        for (String operation : operations) {
            String[] splits = operation.split(":");
            Object value = this.operationTimings.get(operation);
            if (value == null) {
                value = 0L;
            }
            if (!(value instanceof Long)) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < splits.length; ++i) {
                if (splits[i].startsWith(entityPackagePrefix)) {
                    String[] queryClassSplits = splits[i].split("\\.");
                    list.add(queryClassSplits[queryClassSplits.length - 1]);
                    continue;
                }
                if (splits[i] == null || splits[i].equals("null")) continue;
                list.add(splits[i]);
            }
            metrics.put(StringUtils.join(list, (String)"."), (Long)value);
        }
        if (!metrics.isEmpty()) {
            if (!this.isInitialized) {
                this.init();
            }
            if (this.isInitialized) {
                LOG.debug("Publishing {} metrics to sink.", (Object)metrics.size());
                this.metricsSource.publish(metrics);
            }
        }
    }

    private int getWeight(String value) {
        if (StringUtils.isEmpty((String)value) || value.equals("NONE")) {
            return 0;
        }
        if (value.equals("ALL")) {
            return Integer.MAX_VALUE;
        }
        if (value.equals("NORMAL")) {
            return 5;
        }
        return 10;
    }
}

