/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metadata;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.metadata.RoleCommandPair;
import id.onyx.obdp.server.stageplanner.RoleGraphNode;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCommandOrder
implements Cloneable {
    @Inject
    OBDPMetaInfo obdpMetaInfo;
    private static final Logger LOG = LoggerFactory.getLogger(RoleCommandOrder.class);
    private LinkedHashSet<String> sectionKeys;
    private static final String GENERAL_DEPS_KEY = "general_deps";
    public static final String GLUSTERFS_DEPS_KEY = "optional_glusterfs";
    public static final String NO_GLUSTERFS_DEPS_KEY = "optional_no_glusterfs";
    public static final String NAMENODE_HA_DEPS_KEY = "namenode_optional_ha";
    public static final String RESOURCEMANAGER_HA_DEPS_KEY = "resourcemanager_optional_ha";
    public static final String COMMENT_STR = "_comment";
    private static final Set<RoleCommand> independentCommands = Sets.newHashSet((Object[])new RoleCommand[]{RoleCommand.START, RoleCommand.EXECUTE, RoleCommand.SERVICE_CHECK});
    private Map<RoleCommandPair, Set<RoleCommandPair>> dependencies = new HashMap<RoleCommandPair, Set<RoleCommandPair>>();

    private void addDependency(Role blockedRole, RoleCommand blockedCommand, Role blockerRole, RoleCommand blockerCommand, boolean overrideExisting) {
        RoleCommandPair rcp1 = new RoleCommandPair(blockedRole, blockedCommand);
        RoleCommandPair rcp2 = new RoleCommandPair(blockerRole, blockerCommand);
        if (this.dependencies.get(rcp1) == null || overrideExisting) {
            this.dependencies.put(rcp1, new HashSet());
        }
        this.dependencies.get(rcp1).add(rcp2);
    }

    void addDependencies(Map<String, Object> jsonSection) {
        if (jsonSection == null) {
            return;
        }
        for (String blockedObj : jsonSection.keySet()) {
            String blocked = blockedObj;
            if (COMMENT_STR.equals(blocked)) continue;
            ArrayList blockers = (ArrayList)jsonSection.get(blocked);
            for (String blocker : blockers) {
                String[] blockedTuple = blocked.split("-");
                String blockedRole = blockedTuple[0];
                String blockedCommand = blockedTuple[1];
                boolean overrideExisting = blockedTuple.length == 3;
                String[] blockerTuple = blocker.split("-");
                String blockerRole = blockerTuple[0];
                String blockerCommand = blockerTuple[1];
                this.addDependency(Role.valueOf(blockedRole), RoleCommand.valueOf(blockedCommand), Role.valueOf(blockerRole), RoleCommand.valueOf(blockerCommand), overrideExisting);
            }
        }
    }

    public void initialize(Cluster cluster, LinkedHashSet<String> sectionKeys) {
        this.sectionKeys = sectionKeys;
        this.dependencies.clear();
        HashSet<StackId> stackIds = new HashSet<StackId>();
        for (Service service : cluster.getServices().values()) {
            stackIds.add(service.getDesiredStackId());
        }
        for (StackId stackId : stackIds) {
            StackInfo stack;
            try {
                stack = this.obdpMetaInfo.getStack(stackId.getStackName(), stackId.getStackVersion());
            }
            catch (OBDPException ignored) {
                throw new NullPointerException("Stack not found: " + stackId);
            }
            HashMap<String, Object> userData = stack.getRoleCommandOrder().getContent();
            Map generalSection = (Map)userData.get(GENERAL_DEPS_KEY);
            this.addDependencies(generalSection);
            for (String sectionKey : sectionKeys) {
                Map section = (Map)userData.get(sectionKey);
                this.addDependencies(section);
            }
        }
        this.extendTransitiveDependency();
        this.addMissingRestartDependencies();
    }

    public int order(RoleGraphNode rgn1, RoleGraphNode rgn2) {
        RoleCommandPair rcp1 = new RoleCommandPair(rgn1.getRole(), rgn1.getCommand());
        RoleCommandPair rcp2 = new RoleCommandPair(rgn2.getRole(), rgn2.getCommand());
        if (this.dependencies.get(rcp1) != null && this.dependencies.get(rcp1).contains(rcp2)) {
            return 1;
        }
        if (this.dependencies.get(rcp2) != null && this.dependencies.get(rcp2).contains(rcp1)) {
            return -1;
        }
        if (!rgn2.getCommand().equals((Object)rgn1.getCommand())) {
            return this.compareCommands(rgn1, rgn2);
        }
        return 0;
    }

    public Set<Service> getTransitiveServices(Service service, RoleCommand cmd) throws OBDPException {
        HashSet<Service> transitiveServices = new HashSet<Service>();
        Cluster cluster = service.getCluster();
        HashSet<RoleCommandPair> allDeps = new HashSet<RoleCommandPair>();
        for (ServiceComponent sc : service.getServiceComponents().values()) {
            RoleCommandPair rcp = new RoleCommandPair(Role.valueOf(sc.getName()), cmd);
            Set<RoleCommandPair> deps = this.dependencies.get(rcp);
            if (deps == null) continue;
            allDeps.addAll(deps);
        }
        block1: for (Service s : cluster.getServices().values()) {
            for (RoleCommandPair rcp : allDeps) {
                ServiceComponent sc = s.getServiceComponents().get(rcp.getRole().toString());
                if (sc == null) continue;
                transitiveServices.add(s);
                continue block1;
            }
        }
        return transitiveServices;
    }

    private void extendTransitiveDependency() {
        for (Map.Entry<RoleCommandPair, Set<RoleCommandPair>> roleCommandPairSetEntry : this.dependencies.entrySet()) {
            HashSet<RoleCommandPair> visited = new HashSet<RoleCommandPair>();
            HashSet<RoleCommandPair> transitiveDependencies = new HashSet<RoleCommandPair>();
            for (RoleCommandPair directlyBlockedOn : this.dependencies.get(roleCommandPairSetEntry.getKey())) {
                visited.add(directlyBlockedOn);
                this.identifyTransitiveDependencies(directlyBlockedOn, visited, transitiveDependencies);
            }
            if (transitiveDependencies.size() <= 0) continue;
            this.dependencies.get(roleCommandPairSetEntry.getKey()).addAll(transitiveDependencies);
        }
    }

    private void identifyTransitiveDependencies(RoleCommandPair rcp, HashSet<RoleCommandPair> visited, HashSet<RoleCommandPair> transitiveDependencies) {
        if (this.dependencies.get(rcp) != null) {
            for (RoleCommandPair blockedOn : this.dependencies.get(rcp)) {
                if (visited.contains(blockedOn)) continue;
                visited.add(blockedOn);
                transitiveDependencies.add(blockedOn);
                this.identifyTransitiveDependencies(blockedOn, visited, transitiveDependencies);
            }
        }
    }

    private void addMissingRestartDependencies() {
        HashMap missingDependencies = new HashMap();
        for (Map.Entry<RoleCommandPair, Set<RoleCommandPair>> roleCommandPairSetEntry : this.dependencies.entrySet()) {
            RoleCommandPair restartPair;
            RoleCommandPair roleCommandPair = roleCommandPairSetEntry.getKey();
            if (!roleCommandPair.getCmd().equals((Object)RoleCommand.START) || this.dependencies.containsKey(restartPair = new RoleCommandPair(roleCommandPair.getRole(), RoleCommand.RESTART))) continue;
            HashSet<RoleCommandPair> roleCommandDeps = new HashSet<RoleCommandPair>();
            for (RoleCommandPair rco : roleCommandPairSetEntry.getValue()) {
                roleCommandDeps.add(new RoleCommandPair(rco.getRole(), RoleCommand.RESTART));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding dependency for {}, dependencies => {}", (Object)restartPair, roleCommandDeps);
            }
            missingDependencies.put(restartPair, roleCommandDeps);
        }
        if (!missingDependencies.isEmpty()) {
            this.dependencies.putAll(missingDependencies);
        }
    }

    private int compareCommands(RoleGraphNode rgn1, RoleGraphNode rgn2) {
        RoleCommand rc2;
        RoleCommand rc1 = rgn1.getCommand();
        if (rc1.equals((Object)(rc2 = rgn2.getCommand()))) {
            return 0;
        }
        if (independentCommands.contains((Object)rc1) && independentCommands.contains((Object)rc2)) {
            return 0;
        }
        if (rc1.equals((Object)RoleCommand.INSTALL)) {
            return -1;
        }
        if (rc2.equals((Object)RoleCommand.INSTALL)) {
            return 1;
        }
        if (rc1.equals((Object)RoleCommand.START) || rc1.equals((Object)RoleCommand.EXECUTE) || rc1.equals((Object)RoleCommand.SERVICE_CHECK)) {
            return -1;
        }
        if (rc2.equals((Object)RoleCommand.START) || rc2.equals((Object)RoleCommand.EXECUTE) || rc2.equals((Object)RoleCommand.SERVICE_CHECK)) {
            return 1;
        }
        if (rc1.equals((Object)RoleCommand.STOP)) {
            return -1;
        }
        if (rc2.equals((Object)RoleCommand.STOP)) {
            return 1;
        }
        return 0;
    }

    public int compareDeps(RoleCommandOrder rco) {
        if (this == rco) {
            return 0;
        }
        if (!this.dependencies.keySet().equals(rco.dependencies.keySet())) {
            LOG.debug("dependency keysets differ");
            return 1;
        }
        LOG.debug("dependency keysets match");
        for (Map.Entry<RoleCommandPair, Set<RoleCommandPair>> roleCommandPairSetEntry : this.dependencies.entrySet()) {
            Set<RoleCommandPair> v2;
            Set<RoleCommandPair> v1 = this.dependencies.get(roleCommandPairSetEntry.getKey());
            if (v1.equals(v2 = rco.dependencies.get(roleCommandPairSetEntry.getKey()))) continue;
            LOG.debug("different entry found for key ({}, {})", (Object)roleCommandPairSetEntry.getKey().getRole(), (Object)roleCommandPairSetEntry.getKey().getCmd());
            return 1;
        }
        LOG.debug("dependency entries match");
        return 0;
    }

    public LinkedHashSet<String> getSectionKeys() {
        return this.sectionKeys;
    }

    public Map<RoleCommandPair, Set<RoleCommandPair>> getDependencies() {
        return this.dependencies;
    }

    public Object clone() throws CloneNotSupportedException {
        RoleCommandOrder clone = (RoleCommandOrder)super.clone();
        clone.sectionKeys = new LinkedHashSet<String>(this.sectionKeys);
        clone.dependencies = new HashMap<RoleCommandPair, Set<RoleCommandPair>>(this.dependencies);
        return clone;
    }
}

