/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metadata;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OBDPServiceAlertDefinitions {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPServiceAlertDefinitions.class);
    private List<AlertDefinition> m_agentDefinitions = null;
    private List<AlertDefinition> m_serverDefinitions = null;
    @Inject
    private AlertDefinitionFactory m_factory;

    public List<AlertDefinition> getAgentDefinitions() {
        if (null != this.m_agentDefinitions) {
            return this.m_agentDefinitions;
        }
        this.m_agentDefinitions = this.getDefinitions(RootComponent.AMBARI_AGENT);
        return this.m_agentDefinitions;
    }

    public List<AlertDefinition> getServerDefinitions() {
        if (null != this.m_serverDefinitions) {
            return this.m_serverDefinitions;
        }
        this.m_serverDefinitions = this.getDefinitions(RootComponent.OBDP_SERVER);
        return this.m_serverDefinitions;
    }

    private List<AlertDefinition> getDefinitions(RootComponent component) {
        ArrayList<AlertDefinition> definitions = new ArrayList<AlertDefinition>();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("alerts.json");
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            Set<AlertDefinition> allDefinitions = this.m_factory.getAlertDefinitions(reader, RootService.OBDP.name());
            String componentName = component.name();
            for (AlertDefinition definition : allDefinitions) {
                if (!componentName.equals(definition.getComponentName())) continue;
                definitions.add(definition);
            }
        }
        catch (Exception exception) {
            LOG.error("Unable to load the Ambari alerts JSON file", (Throwable)exception);
        }
        return definitions;
    }
}

