/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metadata;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.metadata.RoleCommandOrderProvider;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CachedRoleCommandOrderProvider
implements RoleCommandOrderProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CachedRoleCommandOrderProvider.class);
    @Inject
    private Injector injector;
    @Inject
    private Clusters clusters;
    private Map<Integer, RoleCommandOrder> rcoMap = new ConcurrentHashMap<Integer, RoleCommandOrder>();

    @Inject
    public CachedRoleCommandOrderProvider() {
    }

    @Override
    public RoleCommandOrder getRoleCommandOrder(Long clusterId) {
        Cluster cluster = null;
        try {
            cluster = this.clusters.getCluster(clusterId);
            return this.getRoleCommandOrder(cluster);
        }
        catch (OBDPException e) {
            return null;
        }
    }

    @Override
    public RoleCommandOrder getRoleCommandOrder(Cluster cluster) {
        boolean hasGLUSTERFS = false;
        boolean isNameNodeHAEnabled = false;
        boolean isResourceManagerHAEnabled = false;
        try {
            if (cluster != null && cluster.getService("GLUSTERFS") != null) {
                hasGLUSTERFS = true;
            }
        }
        catch (OBDPException oBDPException) {
            // empty catch block
        }
        try {
            if (cluster != null && cluster.getService("HDFS") != null && cluster.getService("HDFS").getServiceComponent("JOURNALNODE") != null) {
                isNameNodeHAEnabled = true;
            }
        }
        catch (OBDPException oBDPException) {
            // empty catch block
        }
        try {
            if (cluster != null && cluster.getService("YARN") != null && cluster.getService("YARN").getServiceComponent("RESOURCEMANAGER").getServiceComponentHosts().size() > 1) {
                isResourceManagerHAEnabled = true;
            }
        }
        catch (OBDPException oBDPException) {
            // empty catch block
        }
        int clusterCacheId = new HashCodeBuilder().append(cluster != null ? cluster.getClusterId() : -1L).append(hasGLUSTERFS).append(isNameNodeHAEnabled).append(isResourceManagerHAEnabled).toHashCode();
        RoleCommandOrder rco = this.rcoMap.get(clusterCacheId);
        if (rco == null) {
            rco = (RoleCommandOrder)this.injector.getInstance(RoleCommandOrder.class);
            LinkedHashSet<String> sectionKeys = new LinkedHashSet<String>();
            if (hasGLUSTERFS) {
                sectionKeys.add("optional_glusterfs");
            } else {
                sectionKeys.add("optional_no_glusterfs");
            }
            if (isNameNodeHAEnabled) {
                sectionKeys.add("namenode_optional_ha");
            }
            if (isResourceManagerHAEnabled) {
                sectionKeys.add("resourcemanager_optional_ha");
            }
            rco.initialize(cluster, sectionKeys);
            this.rcoMap.put(clusterCacheId, rco);
        }
        return rco;
    }

    public void clearRoleCommandOrderCache() {
        this.rcoMap.clear();
    }
}

