/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.metadata;

import com.google.inject.Singleton;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.state.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class ActionMetadata {
    private final Map<String, List<String>> serviceActions = new HashMap<String, List<String>>();
    private final Map<String, String> serviceClients = new HashMap<String, String>();
    private final Map<String, String> serviceCheckActions = new HashMap<String, String>();
    private final List<String> defaultHostComponentCommands = new ArrayList<String>();
    public static final String SERVICE_CHECK_POSTFIX = "_SERVICE_CHECK";
    private static final Map<String, String> SERVICE_CHECKS;

    public ActionMetadata() {
        this.fillServiceClients();
        this.fillHostComponentCommands();
    }

    private void fillHostComponentCommands() {
        this.defaultHostComponentCommands.add("RESTART");
        this.defaultHostComponentCommands.add("START");
        this.defaultHostComponentCommands.add("STOP");
        this.defaultHostComponentCommands.add("INSTALL");
        this.defaultHostComponentCommands.add("CONFIGURE");
        this.defaultHostComponentCommands.add("CONFIGURE_FUNCTION");
        this.defaultHostComponentCommands.add("DISABLE_SECURITY");
        this.defaultHostComponentCommands.add("RECONFIGURE");
    }

    private void fillServiceClients() {
        this.serviceClients.put("hdfs", Role.HDFS_CLIENT.toString());
        this.serviceClients.put("glusterfs", Role.GLUSTERFS_CLIENT.toString());
        this.serviceClients.put("hbase", Role.HBASE_CLIENT.toString());
        this.serviceClients.put("mapreduce", Role.MAPREDUCE_CLIENT.toString());
        this.serviceClients.put("zookeeper", Role.ZOOKEEPER_CLIENT.toString());
        this.serviceClients.put("hive", Role.HIVE_CLIENT.toString());
        this.serviceClients.put("hcat", Role.HCAT.toString());
        this.serviceClients.put("oozie", Role.OOZIE_CLIENT.toString());
        this.serviceClients.put("pig", Role.PIG.toString());
        this.serviceClients.put("mahout", Role.MAHOUT.toString());
        this.serviceClients.put("sqoop", Role.SQOOP.toString());
        this.serviceClients.put("yarn", Role.YARN_CLIENT.toString());
        this.serviceClients.put("kerberos", Role.KERBEROS_CLIENT.toString());
        this.serviceClients.put("accumulo", Role.ACCUMULO_CLIENT.toString());
    }

    public List<String> getActions(String serviceName) {
        List<String> result = this.serviceActions.get(serviceName.toLowerCase());
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public String getClient(String serviceName) {
        return this.serviceClients.get(serviceName.toLowerCase());
    }

    public String getServiceCheckAction(String serviceName) {
        return this.serviceCheckActions.get(serviceName.toLowerCase());
    }

    public String getServiceNameByServiceCheckAction(String serviceCheckAction) {
        for (Map.Entry<String, String> entry : this.serviceCheckActions.entrySet()) {
            if (!entry.getValue().equals(serviceCheckAction)) continue;
            return entry.getKey().toUpperCase();
        }
        return null;
    }

    public void addServiceCheckAction(String serviceName) {
        Object actionName = serviceName + SERVICE_CHECK_POSTFIX;
        if (SERVICE_CHECKS.containsKey(serviceName)) {
            actionName = SERVICE_CHECKS.get(serviceName);
        }
        this.serviceCheckActions.put(serviceName.toLowerCase(), (String)actionName);
        this.serviceActions.put(serviceName.toLowerCase(), Arrays.asList(actionName));
    }

    public boolean isDefaultHostComponentCommand(String command) {
        return command != null && this.defaultHostComponentCommands.contains(command);
    }

    static {
        HashMap<String, String> serviceChecks = new HashMap<String, String>();
        serviceChecks.put(Service.Type.ZOOKEEPER.toString(), "ZOOKEEPER_QUORUM_SERVICE_CHECK");
        SERVICE_CHECKS = Collections.unmodifiableMap(serviceChecks);
    }
}

