/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.logging;

import com.google.common.base.Ticker;
import id.onyx.obdp.server.logging.LockProfileDelegate;
import id.onyx.obdp.server.logging.ProfiledLock;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class ProfiledReentrantReadWriteLock
implements ReadWriteLock {
    private final ProfiledReadLock readLock;
    private final ProfiledWriteLock writeLock;

    ProfiledReentrantReadWriteLock(ReentrantReadWriteLock delegate, Ticker ticker, String label) {
        this.readLock = new ProfiledReadLock(delegate, ticker, label);
        this.writeLock = new ProfiledWriteLock(delegate, ticker, label);
    }

    @Override
    public ProfiledLock readLock() {
        return this.readLock;
    }

    @Override
    public ProfiledLock writeLock() {
        return this.writeLock;
    }

    private static class ProfiledReadLock
    extends ReentrantReadWriteLock.ReadLock
    implements ProfiledLock {
        private final LockProfileDelegate helper;
        private final ReentrantReadWriteLock delegate;

        ProfiledReadLock(ReentrantReadWriteLock delegate, Ticker ticker, String label) {
            super(delegate);
            this.delegate = delegate;
            this.helper = new LockProfileDelegate(ticker, label, this);
        }

        @Override
        public void lock() {
            boolean alreadyOwned = this.helper.logRequest();
            super.lock();
            this.helper.logRequestCompleted(alreadyOwned, true);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            boolean alreadyOwned = this.helper.logRequest();
            super.lockInterruptibly();
            this.helper.logRequestCompleted(alreadyOwned, true);
        }

        @Override
        public boolean tryLock() {
            boolean alreadyOwned = this.helper.logRequest();
            boolean result = super.tryLock();
            this.helper.logRequestCompleted(alreadyOwned, result);
            return result;
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            boolean alreadyOwned = this.helper.logRequest();
            boolean result = super.tryLock(timeout, unit);
            this.helper.logRequestCompleted(alreadyOwned, result);
            return result;
        }

        @Override
        public void unlock() {
            super.unlock();
            this.helper.logUnlock();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return this.delegate.getReadHoldCount() > 0;
        }

        @Override
        public Map<String, Long> getTimeSpentWaitingForLock() {
            return this.helper.getTimeSpentWaitingForLock();
        }

        @Override
        public Map<String, Long> getTimeSpentLocked() {
            return this.helper.getTimeSpentLocked();
        }

        @Override
        public Map<String, Integer> getLockCount() {
            return this.helper.getLockCount();
        }

        @Override
        public String toString() {
            return this.delegate.readLock().toString();
        }

        @Override
        public String getLabel() {
            return this.helper.getLabel();
        }
    }

    private static class ProfiledWriteLock
    extends ReentrantReadWriteLock.WriteLock
    implements ProfiledLock {
        private final LockProfileDelegate helper;
        private final ReentrantReadWriteLock delegate;

        ProfiledWriteLock(ReentrantReadWriteLock delegate, Ticker ticker, String label) {
            super(delegate);
            this.delegate = delegate;
            this.helper = new LockProfileDelegate(ticker, label, this);
        }

        @Override
        public void lock() {
            boolean alreadyOwned = this.helper.logRequest();
            super.lock();
            this.helper.logRequestCompleted(alreadyOwned, true);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            boolean alreadyOwned = this.helper.logRequest();
            super.lockInterruptibly();
            this.helper.logRequestCompleted(alreadyOwned, true);
        }

        @Override
        public boolean tryLock() {
            boolean alreadyOwned = this.helper.logRequest();
            boolean result = super.tryLock();
            this.helper.logRequestCompleted(alreadyOwned, result);
            return result;
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            boolean alreadyOwned = this.helper.logRequest();
            boolean result = super.tryLock(timeout, unit);
            this.helper.logRequestCompleted(alreadyOwned, result);
            return result;
        }

        @Override
        public void unlock() {
            super.unlock();
            this.helper.logUnlock();
        }

        @Override
        public Map<String, Long> getTimeSpentWaitingForLock() {
            return this.helper.getTimeSpentWaitingForLock();
        }

        @Override
        public Map<String, Long> getTimeSpentLocked() {
            return this.helper.getTimeSpentLocked();
        }

        @Override
        public Map<String, Integer> getLockCount() {
            return this.helper.getLockCount();
        }

        @Override
        public String toString() {
            return this.delegate.writeLock().toString();
        }

        @Override
        public String getLabel() {
            return this.helper.getLabel();
        }
    }
}

