/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.logging;

import com.google.common.base.Ticker;
import id.onyx.obdp.server.logging.LockProfileDelegate;
import id.onyx.obdp.server.logging.ProfiledLock;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class ProfiledReentrantLock
implements ProfiledLock {
    private final ReentrantLock delegate;
    private final LockProfileDelegate helper;

    ProfiledReentrantLock(ReentrantLock delegate, Ticker ticker, String label) {
        this.delegate = delegate;
        this.helper = new LockProfileDelegate(ticker, label, this);
    }

    @Override
    public void lock() {
        boolean alreadyOwned = this.helper.logRequest();
        this.delegate.lock();
        this.helper.logRequestCompleted(alreadyOwned, true);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        boolean alreadyOwned = this.helper.logRequest();
        this.delegate.lockInterruptibly();
        this.helper.logRequestCompleted(alreadyOwned, true);
    }

    @Override
    public boolean tryLock() {
        boolean alreadyOwned = this.helper.logRequest();
        boolean result = this.delegate.tryLock();
        this.helper.logRequestCompleted(alreadyOwned, result);
        return result;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        boolean alreadyOwned = this.helper.logRequest();
        boolean result = this.delegate.tryLock(timeout, unit);
        this.helper.logRequestCompleted(alreadyOwned, result);
        return result;
    }

    @Override
    public void unlock() {
        this.delegate.unlock();
        this.helper.logUnlock();
    }

    @Override
    public Condition newCondition() {
        return this.delegate.newCondition();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.delegate.isHeldByCurrentThread();
    }

    @Override
    public Map<String, Long> getTimeSpentWaitingForLock() {
        return this.helper.getTimeSpentWaitingForLock();
    }

    @Override
    public Map<String, Long> getTimeSpentLocked() {
        return this.helper.getTimeSpentLocked();
    }

    @Override
    public Map<String, Integer> getLockCount() {
        return this.helper.getLockCount();
    }

    @Override
    public String getLabel() {
        return this.helper.getLabel();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

