/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.logging;

import com.google.common.base.Ticker;
import id.onyx.obdp.server.logging.ProfiledLock;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LockProfileDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(LockProfileDelegate.class);
    private final ThreadLocal<Long> lockRequestTime = new ThreadLocal();
    private final ThreadLocal<Long> lockAcquireTime = new ThreadLocal();
    private final ConcurrentMap<String, Long> timeSpentWaitingForLock = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, Long> timeSpentLocked = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, Integer> lockCount = new ConcurrentHashMap<String, Integer>();
    private final String label;
    private final ProfiledLock lock;
    private final Ticker ticker;

    LockProfileDelegate(Ticker ticker, String label, ProfiledLock lock) {
        this.label = LockProfileDelegate.addSpacePostfixIfNeeded(label);
        this.lock = lock;
        this.ticker = ticker;
    }

    String getLabel() {
        return this.label;
    }

    Map<String, Long> getTimeSpentWaitingForLock() {
        return new TreeMap<String, Long>(this.timeSpentWaitingForLock);
    }

    Map<String, Long> getTimeSpentLocked() {
        return new TreeMap<String, Long>(this.timeSpentLocked);
    }

    Map<String, Integer> getLockCount() {
        return new TreeMap<String, Integer>(this.lockCount);
    }

    boolean logRequest() {
        boolean alreadyOwned = this.lock.isHeldByCurrentThread();
        if (!alreadyOwned) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}request {} from {}", new Object[]{this.label, this.lock, LockProfileDelegate.getFilteredStackTrace()});
            }
            this.lockRequestTime.set(this.ticker.read());
        }
        return alreadyOwned;
    }

    void logRequestCompleted(boolean alreadyOwned, boolean acquired) {
        if (!alreadyOwned) {
            if (acquired) {
                long elapsed = this.storeElapsedTime(this.lockRequestTime, this.timeSpentWaitingForLock);
                LOG.debug("{}acquired {} after {} ms", new Object[]{this.label, this.lock, elapsed});
                LockProfileDelegate.increment(this.lockCount);
                this.lockAcquireTime.set(this.ticker.read());
            } else {
                LOG.debug("{}failed to acquire {}", (Object)this.label, (Object)this.lock);
            }
        }
    }

    void logUnlock() {
        boolean released;
        boolean bl = released = !this.lock.isHeldByCurrentThread();
        if (released) {
            long elapsed = this.storeElapsedTime(this.lockAcquireTime, this.timeSpentLocked);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}released {} after {} ms", new Object[]{this.label, this.lock, elapsed});
            }
        }
    }

    private long storeElapsedTime(ThreadLocal<Long> startHolder, ConcurrentMap<String, Long> map) {
        long end = this.ticker.read();
        long elapsed = Long.MIN_VALUE;
        Long start = startHolder.get();
        if (start != null && start <= end) {
            elapsed = TimeUnit.NANOSECONDS.toMillis(end - start);
            String name = Thread.currentThread().getName();
            map.putIfAbsent(name, 0L);
            if (elapsed > 0L) {
                map.put(name, (Long)map.get(name) + elapsed);
            }
        }
        startHolder.remove();
        return elapsed;
    }

    private static void increment(ConcurrentMap<String, Integer> map) {
        String name = Thread.currentThread().getName();
        map.putIfAbsent(name, 0);
        map.put(name, (Integer)map.get(name) + 1);
    }

    private static String addSpacePostfixIfNeeded(String label) {
        if (label == null) {
            return "";
        }
        return (label = label.trim()).length() > 0 ? label + " " : label;
    }

    private static String getFilteredStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            String className = element.getClassName();
            if (!className.startsWith("id.onyx.obdp") || className.startsWith("id.onyx.obdp.server.logging")) continue;
            sb.append(className).append("#").append(element.getMethodName()).append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(");\t");
        }
        return sb.toString();
    }
}

