/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.logging;

import com.google.common.base.Ticker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.logging.ProfiledLock;
import id.onyx.obdp.server.logging.ProfiledReentrantLock;
import id.onyx.obdp.server.logging.ProfiledReentrantReadWriteLock;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LockFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LockFactory.class);
    private final boolean profiling;
    private final Set<ProfiledLock> profiledLocks;

    @Inject
    public LockFactory(Configuration config) {
        this.profiling = config.isServerLocksProfilingEnabled();
        this.profiledLocks = this.profiling ? new CopyOnWriteArraySet() : null;
        LOG.info("Lock profiling is {}", (Object)(this.profiling ? "enabled" : "disabled"));
    }

    public Lock newLock() {
        return this.newLock(LockFactory.getDefaultPrefix());
    }

    public Lock newLock(String label) {
        ReentrantLock baseLock = new ReentrantLock();
        if (this.profiling) {
            ProfiledReentrantLock profiledLock = new ProfiledReentrantLock(baseLock, Ticker.systemTicker(), label);
            this.profiledLocks.add(profiledLock);
            return profiledLock;
        }
        return baseLock;
    }

    public ReadWriteLock newReadWriteLock() {
        return this.newReadWriteLock(LockFactory.getDefaultPrefix());
    }

    public ReadWriteLock newReadWriteLock(String label) {
        ReentrantReadWriteLock baseLock = new ReentrantReadWriteLock();
        if (this.profiling) {
            ProfiledReentrantReadWriteLock profiledLock = new ProfiledReentrantReadWriteLock(baseLock, Ticker.systemTicker(), label);
            this.profiledLocks.add(profiledLock.readLock());
            this.profiledLocks.add(profiledLock.writeLock());
            return profiledLock;
        }
        return baseLock;
    }

    public void debugDump(StringBuilder sb) {
        if (this.profiling) {
            sb.append("\n\t\tLocks: [");
            for (ProfiledLock lock : this.profiledLocks) {
                sb.append("\n\t\t\t").append(lock.getLabel()).append(lock).append(" waited: ").append(lock.getTimeSpentWaitingForLock()).append(" held: ").append(lock.getTimeSpentLocked()).append(" times locked: ").append(lock.getLockCount());
            }
            if (!this.profiledLocks.isEmpty()) {
                sb.append("\n");
            }
            sb.append("]");
        }
    }

    private static String getDefaultPrefix() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace.length > 3 ? stackTrace[3].getFileName() + ":" + stackTrace[3].getLineNumber() : "";
    }
}

