/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.logging;

import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseLinkLogger
extends AbstractSessionLog
implements SessionLog {
    private static final Logger JPA_LOG = LoggerFactory.getLogger((String)"eclipselink");
    private static final String LOG_TEMPLATE = "[EL {}]: {} {}";

    public void log(SessionLogEntry sessionLogEntry) {
        int level = sessionLogEntry.getLevel();
        if (!this.shouldLog(level, sessionLogEntry.getNameSpace())) {
            return;
        }
        switch (level) {
            case 0: 
            case 1: 
            case 2: {
                JPA_LOG.trace(LOG_TEMPLATE, new Object[]{"Trace", this.getSupplementDetailString(sessionLogEntry), this.formatMessage(sessionLogEntry)});
                return;
            }
            case 4: 
            case 5: {
                JPA_LOG.info(LOG_TEMPLATE, new Object[]{"Info", this.getSupplementDetailString(sessionLogEntry), this.formatMessage(sessionLogEntry)});
                return;
            }
            case 3: {
                JPA_LOG.debug(LOG_TEMPLATE, new Object[]{"Debug", this.getSupplementDetailString(sessionLogEntry), this.formatMessage(sessionLogEntry)});
                return;
            }
            case 7: {
                JPA_LOG.error(LOG_TEMPLATE, new Object[]{"Error", this.getSupplementDetailString(sessionLogEntry), this.formatMessage(sessionLogEntry)});
                return;
            }
            case 6: {
                JPA_LOG.warn(LOG_TEMPLATE, new Object[]{"Warning", this.getSupplementDetailString(sessionLogEntry), this.formatMessage(sessionLogEntry)});
                return;
            }
            case 8: {
                return;
            }
        }
        JPA_LOG.debug(LOG_TEMPLATE, new Object[]{"Unknown", this.getSupplementDetailString(sessionLogEntry), this.formatMessage(sessionLogEntry)});
    }
}

