/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.listeners;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.Collections;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketInitializerListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketInitializerListener.class);
    private final JettyWebSocketServletContainerInitializer initializer;

    public WebSocketInitializerListener(JettyWebSocketServletContainerInitializer initializer) {
        this.initializer = initializer;
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        try {
            this.initializer.onStartup(Collections.emptySet(), servletContext);
            LOG.info("WebSocket container initialized");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        try {
            JettyWebSocketServerContainer container = (JettyWebSocketServerContainer)servletContext.getAttribute(JettyWebSocketServerContainer.class.getName());
            if (container != null) {
                container.stop();
                LOG.info("WebSocket container stopped.");
            } else {
                LOG.info("No WebSocket container found during shutdown.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

