/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.ldap.service.ads.detectors.OccurrenceAndWeightBasedDetector;
import jakarta.inject.Inject;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserObjectClassDetector
extends OccurrenceAndWeightBasedDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserObjectClassDetector.class);

    @Inject
    public UserObjectClassDetector() {
        for (ObjectClassValue ocVal : ObjectClassValue.values()) {
            this.occurrenceMap().put(ocVal.ocVal(), 0);
            this.weightsMap().put(ocVal.ocVal(), ocVal.weight());
        }
    }

    @Override
    protected boolean applies(Entry entry, String attribute) {
        LOGGER.info("Checking for object class [{}] in entry [{}]", (Object)attribute, (Object)entry.getDn());
        return entry.hasObjectClass(new String[]{attribute});
    }

    @Override
    public String detectedProperty() {
        return OBDPServerConfigurationKey.USER_OBJECT_CLASS.key();
    }

    private static enum ObjectClassValue {
        PERSON("person", 1),
        POSIX_ACCOUNT("posixAccount", 1);

        private String ocVal;
        private Integer weight;

        private ObjectClassValue(String attr, Integer weght) {
            this.ocVal = attr;
            this.weight = weght;
        }

        Integer weight() {
            return this.weight;
        }

        String ocVal() {
            return this.ocVal;
        }
    }
}

