/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.ldap.service.ads.detectors.OccurrenceAndWeightBasedDetector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserNameAttrDetector
extends OccurrenceAndWeightBasedDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserNameAttrDetector.class);

    @Inject
    public UserNameAttrDetector() {
        for (UserNameAttrs nameAttr : UserNameAttrs.values()) {
            this.occurrenceMap().put(nameAttr.attrName(), 0);
            this.weightsMap().put(nameAttr.attrName(), nameAttr.weight());
        }
    }

    @Override
    protected boolean applies(Entry entry, String attribute) {
        LOGGER.info("Checking for attribute  [{}] in entry [{}]", (Object)attribute, (Object)entry.getDn());
        return entry.containsAttribute(new String[]{attribute});
    }

    @Override
    public String detectedProperty() {
        return OBDPServerConfigurationKey.USER_NAME_ATTRIBUTE.key();
    }

    private static enum UserNameAttrs {
        SAM_ACCOUNT_NAME("sAMAccountName", 5),
        UID("uid", 3),
        CN("cn", 1);

        private String attrName;
        private Integer weight;

        private UserNameAttrs(String attr, Integer weght) {
            this.attrName = attr;
            this.weight = weght;
        }

        Integer weight() {
            return this.weight;
        }

        String attrName() {
            return this.attrName;
        }
    }
}

