/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.ldap.service.ads.detectors.OccurrenceAndWeightBasedDetector;
import jakarta.inject.Inject;
import org.apache.directory.api.ldap.model.entry.Entry;

public class UserGroupMemberAttrDetector
extends OccurrenceAndWeightBasedDetector {
    @Inject
    public UserGroupMemberAttrDetector() {
        for (UserGroupMemberAttr userGroupMemberAttr : UserGroupMemberAttr.values()) {
            this.occurrenceMap().put(userGroupMemberAttr.attrName(), 0);
            this.weightsMap().put(userGroupMemberAttr.attrName(), userGroupMemberAttr.weight);
        }
    }

    @Override
    protected boolean applies(Entry entry, String attribute) {
        return entry.containsAttribute(new String[]{attribute});
    }

    @Override
    public String detectedProperty() {
        return OBDPServerConfigurationKey.USER_GROUP_MEMBER_ATTRIBUTE.key();
    }

    private static enum UserGroupMemberAttr {
        MEMBER_OF("memberOf", 1),
        IS_MEMBER_OF("ismemberOf", 1);

        private String attrName;
        private Integer weight;

        private UserGroupMemberAttr(String attr, Integer weght) {
            this.attrName = attr;
            this.weight = weght;
        }

        Integer weight() {
            return this.weight;
        }

        String attrName() {
            return this.attrName;
        }
    }
}

