/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import com.google.common.collect.Maps;
import id.onyx.obdp.server.ldap.service.AttributeDetector;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OccurrenceAndWeightBasedDetector
implements AttributeDetector<Entry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OccurrenceAndWeightBasedDetector.class);
    private Map<String, Integer> occurrenceMap = Maps.newHashMap();
    private Map<String, Integer> weightsMap = Maps.newHashMap();

    protected Map<String, Integer> occurrenceMap() {
        return this.occurrenceMap;
    }

    protected Map<String, Integer> weightsMap() {
        return this.weightsMap;
    }

    protected abstract boolean applies(Entry var1, String var2);

    public abstract String detectedProperty();

    @Override
    public Map<String, String> detect() {
        LOGGER.info("Calculating the most probable attribute/value ...");
        HashMap detectedMap = Maps.newHashMap();
        Map.Entry<String, Integer> selectedEntry = null;
        for (Map.Entry<String, Integer> entry : this.occurrenceMap().entrySet()) {
            if (selectedEntry == null) {
                selectedEntry = entry;
                LOGGER.debug("Initial attribute / value entry: {}", selectedEntry);
                continue;
            }
            if (selectedEntry.getValue() >= entry.getValue()) continue;
            LOGGER.info("Changing potential attribute / value entry from : [{}] to: [{}]", selectedEntry, entry);
            selectedEntry = entry;
        }
        String detectedVal = "N/A";
        if ((Integer)selectedEntry.getValue() > 0) {
            detectedVal = selectedEntry.getKey();
        } else {
            LOGGER.warn("Unable to detect attribute or attribute value");
        }
        LOGGER.info("Detected attribute or value: [{}]", (Object)detectedVal);
        detectedMap.put(this.detectedProperty(), detectedVal);
        return detectedMap;
    }

    @Override
    public void collect(Entry entry) {
        LOGGER.info("Collecting ldap attributes/values form entry with dn: [{}]", (Object)entry.getDn());
        for (String attributeValue : this.occurrenceMap().keySet()) {
            if (this.applies(entry, attributeValue)) {
                Integer cnt = (int)this.occurrenceMap().get(attributeValue);
                cnt = this.weightsMap().containsKey(attributeValue) ? Integer.valueOf(cnt + this.weightsMap().get(attributeValue)) : Integer.valueOf(cnt + 1);
                this.occurrenceMap().put(attributeValue, cnt);
                LOGGER.info("Collected potential name attr: {}, count: {}", (Object)attributeValue, (Object)cnt);
                continue;
            }
            LOGGER.info("The result entry doesn't contain the attribute: [{}]", (Object)attributeValue);
        }
    }
}

