/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.ldap.service.ads.detectors.OccurrenceAndWeightBasedDetector;
import jakarta.inject.Inject;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupObjectClassDetector
extends OccurrenceAndWeightBasedDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupObjectClassDetector.class);

    @Inject
    public GroupObjectClassDetector() {
        for (ObjectClassValue ocVal : ObjectClassValue.values()) {
            this.occurrenceMap().put(ocVal.ocVal(), 0);
            this.weightsMap().put(ocVal.ocVal(), ocVal.weight());
        }
    }

    @Override
    protected boolean applies(Entry entry, String attribute) {
        return entry.hasObjectClass(new String[]{attribute});
    }

    @Override
    public String detectedProperty() {
        return OBDPServerConfigurationKey.GROUP_OBJECT_CLASS.key();
    }

    private static enum ObjectClassValue {
        GROUP("group", 1),
        GROUP_OF_NAMES("groupOfNames", 1),
        POSIX_GROUP("posixGroup", 1),
        GROUP_OF_UNIQUE_NAMES("groupOfUniqueNames", 1);

        private String ocVal;
        private Integer weight;

        private ObjectClassValue(String attr, Integer weght) {
            this.ocVal = attr;
            this.weight = weght;
        }

        Integer weight() {
            return this.weight;
        }

        String ocVal() {
            return this.ocVal;
        }
    }
}

