/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.ldap.service.ads.detectors.OccurrenceAndWeightBasedDetector;
import jakarta.inject.Inject;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupNameAttrDetector
extends OccurrenceAndWeightBasedDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupNameAttrDetector.class);

    @Inject
    public GroupNameAttrDetector() {
        for (GroupNameAttr groupNameAttr : GroupNameAttr.values()) {
            this.occurrenceMap().put(groupNameAttr.attrName(), 0);
            this.weightsMap().put(groupNameAttr.attrName(), groupNameAttr.weight());
        }
    }

    @Override
    protected boolean applies(Entry entry, String attribute) {
        return entry.containsAttribute(new String[]{attribute});
    }

    @Override
    public String detectedProperty() {
        return OBDPServerConfigurationKey.GROUP_NAME_ATTRIBUTE.key();
    }

    private static enum GroupNameAttr {
        DISTINGUISHED_NAME("distinguishedName", 1),
        CN("cn", 1);

        private String attrName;
        private Integer weight;

        private GroupNameAttr(String attr, Integer weght) {
            this.attrName = attr;
            this.weight = weght;
        }

        Integer weight() {
            return this.weight;
        }

        String attrName() {
            return this.attrName;
        }
    }
}

