/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.ldap.service.ads.detectors.OccurrenceAndWeightBasedDetector;
import jakarta.inject.Inject;
import org.apache.directory.api.ldap.model.entry.Entry;

public class GroupMemberAttrDetector
extends OccurrenceAndWeightBasedDetector {
    @Inject
    public GroupMemberAttrDetector() {
        for (GroupMemberAttr groupMemberAttr : GroupMemberAttr.values()) {
            this.occurrenceMap().put(groupMemberAttr.attrName(), 0);
            this.weightsMap().put(groupMemberAttr.attrName(), groupMemberAttr.weight());
        }
    }

    @Override
    protected boolean applies(Entry entry, String attribute) {
        return entry.containsAttribute(new String[]{attribute});
    }

    @Override
    public String detectedProperty() {
        return OBDPServerConfigurationKey.GROUP_MEMBER_ATTRIBUTE.key();
    }

    static enum GroupMemberAttr {
        MEMBER("member", 1),
        MEMBER_UID("memberUid", 1),
        UNIQUE_MEMBER("uniqueMember", 1);

        private String attrName;
        private Integer weight;

        private GroupMemberAttr(String attr, Integer weght) {
            this.attrName = attr;
            this.weight = weght;
        }

        Integer weight() {
            return this.weight;
        }

        String attrName() {
            return this.attrName;
        }
    }
}

