/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import com.google.common.collect.Maps;
import id.onyx.obdp.server.ldap.service.AttributeDetector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChainedAttributeDetector
implements AttributeDetector<Entry> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainedAttributeDetector.class);
    private final Set<AttributeDetector> detectors;

    @Inject
    public ChainedAttributeDetector(Set<AttributeDetector> detectors) {
        this.detectors = detectors;
    }

    @Override
    public void collect(Entry entry) {
        for (AttributeDetector detector : this.detectors) {
            LOG.info("Collecting information for the detector: [{}]", (Object)detector);
            detector.collect(entry);
        }
    }

    @Override
    public Map<String, String> detect() {
        HashMap detectedAttributes = Maps.newHashMap();
        for (AttributeDetector detector : this.detectors) {
            LOG.info("Detecting ldap configuration value using the detector: [{}]", (Object)detector);
            detectedAttributes.putAll(detector.detect());
        }
        return detectedAttributes;
    }

    public String toString() {
        return "ChainedAttributeDetector{detectors=" + this.detectors + "}";
    }
}

