/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads.detectors;

import id.onyx.obdp.server.ldap.service.AttributeDetector;
import id.onyx.obdp.server.ldap.service.ads.detectors.ChainedAttributeDetector;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AttributeDetectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeDetectorFactory.class);
    private static final String USER_ATTRIBUTES_DETECTORS = "UserAttributesDetectors";
    private static final String GROUP_ATTRIBUTES_DETECTORS = "GroupAttributesDetectors";
    @Inject
    @Named(value="GroupAttributesDetectors")
    Set<AttributeDetector> groupAttributeDetectors;
    @Inject
    @Named(value="UserAttributesDetectors")
    private Set<AttributeDetector> userAttributeDetectors;

    @Inject
    public AttributeDetectorFactory() {
    }

    public ChainedAttributeDetector userAttributDetector() {
        LOG.info("Creating instance with user attribute detectors: [{}]", this.userAttributeDetectors);
        return new ChainedAttributeDetector(this.userAttributeDetectors);
    }

    public ChainedAttributeDetector groupAttributeDetector() {
        LOG.info("Creating instance with group attribute detectors: [{}]", this.groupAttributeDetectors);
        return new ChainedAttributeDetector(this.groupAttributeDetectors);
    }
}

