/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads;

import com.google.common.eventbus.Subscribe;
import id.onyx.obdp.server.events.OBDPConfigurationChangedEvent;
import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.AmbariLdapException;
import id.onyx.obdp.server.ldap.service.LdapConnectionConfigService;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.directory.ldap.client.api.DefaultLdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.ValidatingPoolableLdapConnectionFactory;
import org.apache.directory.ldap.client.template.LdapConnectionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LdapConnectionTemplateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapConnectionTemplateFactory.class);
    @Inject
    private Provider<OBDPLdapConfiguration> ambariLdapConfigurationProvider;
    @Inject
    private LdapConnectionConfigService ldapConnectionConfigService;
    private LdapConnectionTemplate ldapConnectionTemplateInstance;

    @Inject
    public LdapConnectionTemplateFactory() {
    }

    public LdapConnectionTemplate create(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        LOG.info("Constructing new instance based on the provided ambari ldap configuration: {}", (Object)ambariLdapConfiguration);
        LdapConnectionConfig ldapConnectionConfig = this.ldapConnectionConfigService.createLdapConnectionConfig(ambariLdapConfiguration);
        DefaultLdapConnectionFactory ldapConnectionFactory = new DefaultLdapConnectionFactory(ldapConnectionConfig);
        LdapConnectionPool ldapConnectionPool = new LdapConnectionPool((PooledObjectFactory)new ValidatingPoolableLdapConnectionFactory((LdapConnectionFactory)ldapConnectionFactory));
        LdapConnectionTemplate template = new LdapConnectionTemplate(ldapConnectionPool);
        LOG.info("Ldap connection template instance: {}", (Object)template);
        return template;
    }

    public LdapConnectionTemplate load() throws AmbariLdapException {
        if (null == this.ldapConnectionTemplateInstance) {
            this.ldapConnectionTemplateInstance = this.create((OBDPLdapConfiguration)this.ambariLdapConfigurationProvider.get());
        }
        return this.ldapConnectionTemplateInstance;
    }

    @Subscribe
    public void onConfigChange(OBDPConfigurationChangedEvent event) throws AmbariLdapException {
        this.ldapConnectionTemplateInstance = this.create((OBDPLdapConfiguration)this.ambariLdapConfigurationProvider.get());
    }
}

