/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads;

import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.AmbariLdapException;
import id.onyx.obdp.server.ldap.service.LdapConnectionConfigService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultLdapConnectionConfigService
implements LdapConnectionConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapConnectionConfigService.class);

    @Inject
    public DefaultLdapConnectionConfigService() {
    }

    @Override
    public LdapConnectionConfig createLdapConnectionConfig(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        LOG.debug("Assembling ldap connection config based on: {}", (Object)ambariLdapConfiguration);
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setLdapHost(ambariLdapConfiguration.serverHost());
        config.setLdapPort(ambariLdapConfiguration.serverPort());
        config.setName(ambariLdapConfiguration.bindDn());
        config.setCredentials(ambariLdapConfiguration.bindPassword());
        config.setUseSsl(ambariLdapConfiguration.useSSL());
        if ("custom".equals(ambariLdapConfiguration.trustStore())) {
            LOG.info("Using custom trust manager configuration");
            config.setTrustManagers(this.trustManagers(ambariLdapConfiguration));
        }
        return config;
    }

    private TrustManager[] trustManagers(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        try {
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmFactory.init(this.keyStore(ambariLdapConfiguration));
            return tmFactory.getTrustManagers();
        }
        catch (Exception e) {
            LOG.error("Failed to initialize trust managers", (Throwable)e);
            throw new AmbariLdapException(e);
        }
    }

    private KeyStore keyStore(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        if (Strings.isEmpty((String)ambariLdapConfiguration.trustStoreType())) {
            throw new AmbariLdapException("Key Store Type must be specified");
        }
        if (Strings.isEmpty((String)ambariLdapConfiguration.trustStorePath())) {
            throw new AmbariLdapException("Key Store Path must be specified");
        }
        try {
            KeyStore ks = KeyStore.getInstance(ambariLdapConfiguration.trustStoreType());
            FileInputStream fis = new FileInputStream(ambariLdapConfiguration.trustStorePath());
            ks.load(fis, ambariLdapConfiguration.trustStorePassword().toCharArray());
            return ks;
        }
        catch (Exception e) {
            LOG.error("Failed to create keystore", (Throwable)e);
            throw new AmbariLdapException(e);
        }
    }
}

