/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads;

import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.AmbariLdapException;
import id.onyx.obdp.server.ldap.service.LdapConfigurationService;
import id.onyx.obdp.server.ldap.service.ads.LdapConnectionTemplateFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.search.FilterBuilder;
import org.apache.directory.ldap.client.template.ConnectionCallback;
import org.apache.directory.ldap.client.template.EntryMapper;
import org.apache.directory.ldap.client.template.LdapConnectionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultLdapConfigurationService
implements LdapConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLdapConfigurationService.class);
    @Inject
    private LdapConnectionTemplateFactory ldapConnectionTemplateFactory;

    @Inject
    public DefaultLdapConfigurationService() {
    }

    @Override
    public void checkConnection(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        LOGGER.info("Trying to connect to the LDAP server using provided configuration...");
        LdapConnectionTemplate ldapConnectionTemplate = this.ldapConnectionTemplateFactory.create(ambariLdapConfiguration);
        Boolean isConnected = (Boolean)ldapConnectionTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doWithConnection(LdapConnection connection) throws LdapException {
                return connection.isConnected() && connection.isAuthenticated();
            }
        });
        if (!isConnected.booleanValue()) {
            LOGGER.error("Could not connect to the LDAP server");
            throw new AmbariLdapException("Could not connect to the LDAP server. Configuration: " + ambariLdapConfiguration);
        }
        LOGGER.info("Successfully conencted to the LDAP.");
    }

    @Override
    public String checkUserAttributes(String testUserName, String testPassword, OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        String userDn;
        try {
            LOGGER.info("Checking user attributes for user [{}] ...", (Object)testUserName);
            String filter = FilterBuilder.and((FilterBuilder[])new FilterBuilder[]{FilterBuilder.equal((String)"objectClass", (String)ambariLdapConfiguration.userObjectClass()), FilterBuilder.equal((String)ambariLdapConfiguration.userNameAttribute(), (String)testUserName)}).toString();
            LOGGER.info("Searching for the user: [{}] using the search filter: [{}]", (Object)testUserName, (Object)filter);
            userDn = (String)this.ldapConnectionTemplateFactory.create(ambariLdapConfiguration).searchFirst(new Dn(new String[]{ambariLdapConfiguration.userSearchBase()}), filter, SearchScope.SUBTREE, this.getUserDnNameEntryMapper(ambariLdapConfiguration));
            if (null == userDn) {
                LOGGER.info("Could not find test user based on the provided configuration. User attributes may not be complete or the user may not exist.");
                throw new AmbariLdapException("Could not find test user based on the provided configuration. User attributes may not be complete or the user may not exist.");
            }
            LOGGER.info("Attribute validation succeeded. Filter: [{}]", (Object)filter);
        }
        catch (Exception e) {
            LOGGER.error("User attributes validation failed.", (Throwable)e);
            throw new AmbariLdapException(e.getMessage(), e);
        }
        return userDn;
    }

    @Override
    public Set<String> checkGroupAttributes(String userDn, OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        List groups;
        try {
            LOGGER.info("Checking group attributes for user dn: [{}] ...", (Object)userDn);
            String filter = FilterBuilder.and((FilterBuilder[])new FilterBuilder[]{FilterBuilder.equal((String)"objectClass", (String)ambariLdapConfiguration.groupObjectClass()), FilterBuilder.equal((String)ambariLdapConfiguration.groupMemberAttribute(), (String)userDn)}).toString();
            LOGGER.info("Searching for the groups the user dn: [{}] is member of using the search filter: [{}]", (Object)userDn, (Object)filter);
            LdapConnectionTemplate ldapConnectionTemplate = this.ldapConnectionTemplateFactory.create(ambariLdapConfiguration);
            SearchRequest searchRequest = ldapConnectionTemplate.newSearchRequest(new Dn(new String[]{ambariLdapConfiguration.groupSearchBase()}), filter, SearchScope.SUBTREE);
            searchRequest.addAttributes(new String[]{ambariLdapConfiguration.groupMemberAttribute(), ambariLdapConfiguration.groupNameAttribute()});
            groups = ldapConnectionTemplate.search(searchRequest, this.getGroupNameEntryMapper(ambariLdapConfiguration));
            if (groups == null || groups.isEmpty()) {
                LOGGER.info("No groups found for the user dn. Group attributes configuration is incomplete");
                throw new AmbariLdapException("Group attribute ldap configuration is incomplete");
            }
            LOGGER.info("Group attribute configuration check succeeded.");
        }
        catch (Exception e) {
            LOGGER.error("User attributes validation failed.", (Throwable)e);
            throw new AmbariLdapException(e.getMessage(), e);
        }
        return new HashSet<String>(groups);
    }

    private EntryMapper<String> getGroupNameEntryMapper(final OBDPLdapConfiguration ambariLdapConfiguration) {
        EntryMapper<String> entryMapper = new EntryMapper<String>(){

            public String map(Entry entry) throws LdapException {
                return entry.get(ambariLdapConfiguration.groupNameAttribute()).get().getValue();
            }
        };
        return entryMapper;
    }

    private EntryMapper<String> getUserDnNameEntryMapper(OBDPLdapConfiguration ambariLdapConfiguration) {
        EntryMapper<String> entryMapper = new EntryMapper<String>(){

            public String map(Entry entry) throws LdapException {
                return entry.getDn().getNormName();
            }
        };
        return entryMapper;
    }
}

