/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.ldap.service.ads;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.AmbariLdapException;
import id.onyx.obdp.server.ldap.service.LdapAttributeDetectionService;
import id.onyx.obdp.server.ldap.service.ads.LdapConnectionTemplateFactory;
import id.onyx.obdp.server.ldap.service.ads.detectors.AttributeDetectorFactory;
import id.onyx.obdp.server.ldap.service.ads.detectors.ChainedAttributeDetector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.search.FilterBuilder;
import org.apache.directory.ldap.client.template.EntryMapper;
import org.apache.directory.ldap.client.template.LdapConnectionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultLdapAttributeDetectionService
implements LdapAttributeDetectionService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapAttributeDetectionService.class);
    private static final int SAMPLE_RESULT_SIZE = 50;
    @Inject
    private AttributeDetectorFactory attributeDetectorFactory;
    @Inject
    private LdapConnectionTemplateFactory ldapConnectionTemplateFactory;

    @Inject
    public DefaultLdapAttributeDetectionService() {
    }

    @Override
    public OBDPLdapConfiguration detectLdapUserAttributes(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        LOG.info("Detecting LDAP user attributes ...");
        if (Strings.isEmpty((String)ambariLdapConfiguration.userSearchBase())) {
            LOG.warn("No user search base provided");
            return ambariLdapConfiguration;
        }
        try {
            LdapConnectionTemplate ldapConnectionTemplate = this.ldapConnectionTemplateFactory.create(ambariLdapConfiguration);
            ChainedAttributeDetector userAttributeDetector = this.attributeDetectorFactory.userAttributDetector();
            SearchRequest searchRequest = this.assembleUserSearchRequest(ldapConnectionTemplate, ambariLdapConfiguration);
            List entries = ldapConnectionTemplate.search(searchRequest, this.getEntryMapper());
            for (Entry entry : entries) {
                LOG.info("Collecting user attribute information from the sample entry with dn: [{}]", (Object)entry.getDn());
                userAttributeDetector.collect(entry);
            }
            Map<String, String> detectedUserAttributes = userAttributeDetector.detect();
            this.setDetectedAttributes(ambariLdapConfiguration, detectedUserAttributes);
            LOG.info("Decorated ambari ldap config : [{}]", (Object)ambariLdapConfiguration);
        }
        catch (Exception e) {
            LOG.error("Ldap operation failed while detecting user attributes", (Throwable)e);
            throw new AmbariLdapException(e);
        }
        return ambariLdapConfiguration;
    }

    @Override
    public OBDPLdapConfiguration detectLdapGroupAttributes(OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        LOG.info("Detecting LDAP group attributes ...");
        if (Strings.isEmpty((String)ambariLdapConfiguration.groupSearchBase())) {
            LOG.warn("No group search base provided");
            return ambariLdapConfiguration;
        }
        try {
            LdapConnectionTemplate ldapConnectionTemplate = this.ldapConnectionTemplateFactory.create(ambariLdapConfiguration);
            ChainedAttributeDetector groupAttributeDetector = this.attributeDetectorFactory.groupAttributeDetector();
            SearchRequest searchRequest = this.assembleGroupSearchRequest(ldapConnectionTemplate, ambariLdapConfiguration);
            List groupEntries = ldapConnectionTemplate.search(searchRequest, this.getEntryMapper());
            for (Entry groupEntry : groupEntries) {
                LOG.info("Collecting group attribute information from the sample entry with dn: [{}]", (Object)groupEntry.getDn());
                groupAttributeDetector.collect(groupEntry);
            }
            Map<String, String> detectedGroupAttributes = groupAttributeDetector.detect();
            this.setDetectedAttributes(ambariLdapConfiguration, detectedGroupAttributes);
            LOG.info("Decorated ambari ldap config : [{}]", (Object)ambariLdapConfiguration);
        }
        catch (Exception e) {
            LOG.error("Ldap operation failed while detecting group attributes", (Throwable)e);
            throw new AmbariLdapException(e);
        }
        return ambariLdapConfiguration;
    }

    private void setDetectedAttributes(OBDPLdapConfiguration ambariLdapConfiguration, Map<String, String> detectedAttributes) {
        for (Map.Entry<String, String> detecteMapEntry : detectedAttributes.entrySet()) {
            LOG.info("Setting detected configuration value: [{}] - > [{}]", (Object)detecteMapEntry.getKey(), (Object)detecteMapEntry.getValue());
            OBDPServerConfigurationKey key = OBDPServerConfigurationKey.translate(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, detecteMapEntry.getKey());
            if (key == null) continue;
            ambariLdapConfiguration.setValueFor(key, detecteMapEntry.getValue());
        }
    }

    private SearchRequest assembleUserSearchRequest(LdapConnectionTemplate ldapConnectionTemplate, OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        try {
            SearchRequest req = ldapConnectionTemplate.newSearchRequest(ambariLdapConfiguration.userSearchBase(), FilterBuilder.present((String)"objectClass").toString(), SearchScope.SUBTREE);
            req.setSizeLimit(50L);
            return req;
        }
        catch (Exception e) {
            LOG.error("Could not assemble ldap search request", (Throwable)e);
            throw new AmbariLdapException(e);
        }
    }

    private SearchRequest assembleGroupSearchRequest(LdapConnectionTemplate ldapConnectionTemplate, OBDPLdapConfiguration ambariLdapConfiguration) throws AmbariLdapException {
        try {
            SearchRequest req = ldapConnectionTemplate.newSearchRequest(ambariLdapConfiguration.groupSearchBase(), FilterBuilder.present((String)"objectClass").toString(), SearchScope.SUBTREE);
            req.setSizeLimit(50L);
            return req;
        }
        catch (Exception e) {
            LOG.error("Could not assemble ldap search request", (Throwable)e);
            throw new AmbariLdapException(e);
        }
    }

    public EntryMapper<Entry> getEntryMapper() {
        return new EntryMapper<Entry>(){

            public Entry map(Entry entry) throws LdapException {
                return entry;
            }
        };
    }
}

